/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.node;

import VASSAL.build.GameModule;
import VASSAL.chat.ChatServerConnection;
import VASSAL.chat.ChatServerFactory;
import VASSAL.chat.HttpMessageServer;
import VASSAL.chat.node.NodeServerInfo;
import VASSAL.chat.node.SocketNodeClient;
import VASSAL.chat.peer2peer.PeerPoolInfo;
import VASSAL.command.Command;
import VASSAL.configure.StringConfigurer;
import VASSAL.configure.TextConfigurer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Properties;
import javax.swing.SwingUtilities;

public class NodeClientFactory
extends ChatServerFactory {
    private static NodeClientFactory instance;
    private static final String UNNAMED_MODULE = "<unknown module>";
    private static final String UNKNOWN_USER = "<unknown user>";
    public static final String NODE_TYPE = "node";
    public static final String NODE_HOST = "nodeHost";
    public static final String NODE_PORT = "nodePort";

    private NodeClientFactory() {
    }

    public ChatServerConnection buildServer(Properties properties) {
        final String string = properties.getProperty(NODE_HOST, "63.144.41.13");
        final int n = Integer.parseInt(properties.getProperty(NODE_PORT, "5050"));
        NodeServerInfo nodeServerInfo = new NodeServerInfo(){

            public String getHostName() {
                return string;
            }

            public int getPort() {
                return n;
            }
        };
        PeerPoolInfo peerPoolInfo = new PeerPoolInfo(){

            public String getModuleName() {
                return GameModule.getGameModule() == null ? NodeClientFactory.UNNAMED_MODULE : GameModule.getGameModule().getGameName();
            }

            public String getUserName() {
                return GameModule.getUserId();
            }
        };
        PeerPoolInfo peerPoolInfo2 = new PeerPoolInfo(){

            public String getModuleName() {
                return GameModule.getGameModule() == null ? NodeClientFactory.UNNAMED_MODULE : GameModule.getGameModule().getGameName();
            }

            public String getUserName() {
                return GameModule.getGameModule() == null ? NodeClientFactory.UNKNOWN_USER : (String)GameModule.getGameModule().getPrefs().getValue("RealName");
            }
        };
        HttpMessageServer httpMessageServer = new HttpMessageServer(peerPoolInfo2);
        SocketNodeClient socketNodeClient = new SocketNodeClient(GameModule.getGameModule().getGameName(), GameModule.getUserId() + "." + System.currentTimeMillis(), GameModule.getGameModule(), nodeServerInfo, httpMessageServer, httpMessageServer);
        GameModule.getGameModule().getPrefs().getOption("RealName").fireUpdate();
        GameModule.getGameModule().getPrefs().getOption("Profile").fireUpdate();
        socketNodeClient.addPropertyChangeListener("Status", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (GameModule.getGameModule().getChatter() != null) {
                    GameModule.getGameModule().getChatter().show((String)propertyChangeEvent.getNewValue());
                }
            }
        });
        socketNodeClient.addPropertyChangeListener("Msg", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Command command = GameModule.getGameModule().decode((String)propertyChangeEvent.getNewValue());
                if (command != null) {
                    Runnable runnable = new Runnable(this, command){
                        private final /* synthetic */ Command val$c;
                        private final /* synthetic */ 5 this$1;
                        {
                            this.this$1 = var1_1;
                            this.val$c = command;
                        }

                        public void run() {
                            this.val$c.execute();
                            GameModule.getGameModule().getLogger().log(this.val$c);
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }
            }
        });
        return socketNodeClient;
    }

    public static NodeClientFactory getInstance() {
        if (instance == null) {
            instance = new NodeClientFactory();
            StringConfigurer stringConfigurer = new StringConfigurer("RealName", "Name: ", "newbie");
            TextConfigurer textConfigurer = new TextConfigurer("Profile", "Personal Info:", "");
            StringConfigurer stringConfigurer2 = new StringConfigurer("UserName", "Password", System.getProperty("user.name") + "'s password");
            stringConfigurer2.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    GameModule.setUserId((String)propertyChangeEvent.getNewValue());
                }
            });
            GameModule.setUserId((String)stringConfigurer2.getValue());
            GameModule.getGameModule().getPrefs().addOption("Personal", stringConfigurer, "Enter the name by which you would like to be known to other players");
            GameModule.getGameModule().getPrefs().addOption("Personal", stringConfigurer2, "Enter a password for identification purposes.");
            GameModule.getGameModule().getPrefs().addOption("Personal", textConfigurer);
        }
        return instance;
    }
}

