/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.node;

import VASSAL.Info;
import VASSAL.chat.ChatServerConnection;
import VASSAL.chat.DynamicClient;
import VASSAL.chat.HttpRequestWrapper;
import VASSAL.chat.ServerStatus;
import VASSAL.chat.WelcomeMessageServer;
import VASSAL.chat.messageboard.Message;
import VASSAL.chat.messageboard.MessageBoard;
import VASSAL.chat.node.SocketNodeClient;
import VASSAL.chat.peer2peer.DirectPeerPool;
import VASSAL.chat.peer2peer.P2PClient;
import VASSAL.chat.peer2peer.PeerPoolInfo;
import VASSAL.command.CommandEncoder;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class NodeHybridClient
extends DynamicClient {
    private String addressURL;
    private MessageBoard msgSvr;
    private WelcomeMessageServer welcomeMsgSvr;
    private PeerPoolInfo info;
    private CommandEncoder encoder;
    private ServerStatus status;

    public NodeHybridClient(CommandEncoder commandEncoder, PeerPoolInfo peerPoolInfo, MessageBoard messageBoard, WelcomeMessageServer welcomeMessageServer, String string) {
        this.addressURL = string;
        this.encoder = commandEncoder;
        this.info = peerPoolInfo;
        this.msgSvr = messageBoard;
        this.welcomeMsgSvr = welcomeMessageServer;
    }

    public void postMessage(String string) {
        this.msgSvr.postMessage(string);
    }

    public Message[] getMessages() {
        return this.msgSvr.getMessages();
    }

    public MessageBoard getMessageServer() {
        return this.msgSvr;
    }

    protected ChatServerConnection buildDelegate() {
        ChatServerConnection chatServerConnection = null;
        try {
            String string = this.getAddressFromURL();
            int n = string.indexOf(":");
            if (n < 0) {
                this.fireStatus("Bad server address '" + string + "': No port specified");
            } else {
                try {
                    int n2 = Integer.parseInt(string.substring(n + 1));
                    string = string.substring(0, n);
                    chatServerConnection = new SocketNodeClient(this.info.getModuleName(), this.info.getUserName(), this.encoder, string, n2, this.msgSvr, this.welcomeMsgSvr);
                }
                catch (NumberFormatException numberFormatException) {
                    this.fireStatus("Bad server address '" + string + "'");
                }
            }
        }
        catch (IOException iOException) {
            this.fireStatus("Unable to determine server address");
        }
        if (chatServerConnection == null) {
            this.fireStatus("Defaulting to peer-to-peer mode");
            chatServerConnection = new P2PClient(this.encoder, this.msgSvr, this.welcomeMsgSvr, new DirectPeerPool());
        }
        return chatServerConnection;
    }

    private String getAddressFromURL() throws IOException {
        HttpRequestWrapper httpRequestWrapper = new HttpRequestWrapper(this.addressURL);
        Properties properties = new Properties();
        ((Hashtable)properties).put("module", this.info.getModuleName());
        ((Hashtable)properties).put("vassalVersion", Info.getVersion());
        Enumeration enumeration = httpRequestWrapper.doGet(properties);
        if (!enumeration.hasMoreElements()) {
            throw new IOException("Empty response");
        }
        return (String)enumeration.nextElement();
    }

    public ServerStatus getStatusServer() {
        return this.status;
    }

    public void setStatusServer(ServerStatus serverStatus) {
        this.status = serverStatus;
    }
}

