/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.node;

import VASSAL.chat.node.AsynchronousServerNode;
import VASSAL.chat.node.BufferedSocketHandler;
import VASSAL.chat.node.ConnectionLimiter;
import VASSAL.chat.node.Node;
import VASSAL.chat.node.Protocol;
import VASSAL.chat.node.SocketHandler;
import VASSAL.chat.node.SocketWatcher;
import java.io.IOException;
import java.net.Socket;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;

public class PlayerNode
extends Node
implements SocketWatcher {
    private SocketHandler input;
    protected String id;
    protected String info;
    private AsynchronousServerNode server;
    private static ConnectionLimiter connLimiter = new ConnectionLimiter();

    public PlayerNode(Socket socket, AsynchronousServerNode asynchronousServerNode) throws IOException {
        super(null, null, null);
        this.server = asynchronousServerNode;
        this.input = new BufferedSocketHandler(socket, this);
        this.input.start();
    }

    public String getId() {
        return this.id;
    }

    public boolean isLeaf() {
        return true;
    }

    public void send(String string) {
        this.input.writeLine(string);
    }

    public String getInfo() {
        return this.info;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PlayerNode)) {
            return false;
        }
        PlayerNode playerNode = (PlayerNode)object;
        return this.id.equals(playerNode.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public void handleMessage(String string) {
        String[] stringArray = Protocol.decodeRegisterCommand(string);
        if (stringArray != null) {
            this.id = stringArray[0];
            this.info = stringArray[2];
            this.server.registerNode(stringArray[1], this);
        } else {
            stringArray = Protocol.decodeJoinCommand(string);
            if (stringArray != null) {
                this.server.move(this, stringArray[0]);
            } else {
                stringArray = Protocol.decodeForwardCommand(string);
                if (stringArray != null) {
                    this.server.forward(stringArray[0], stringArray[1]);
                } else {
                    stringArray = Protocol.decodeStatsCommand(string);
                    if (stringArray != null) {
                        this.info = stringArray[0];
                        this.server.updateInfo(this);
                    } else {
                        Properties properties = Protocol.decodeRoomsInfo(string);
                        if (properties != null) {
                            Iterator iterator = ((Hashtable)properties).keySet().iterator();
                            while (iterator.hasNext()) {
                                String string2 = (String)iterator.next();
                                Node node = this.server.getModule(this).getDescendant(string2);
                                if (node == null) continue;
                                node.setInfo(properties.getProperty(string2));
                                this.server.updateInfo(node);
                            }
                        } else {
                            String string3 = Protocol.decodeLoginCommand(string);
                            if (string3 != null) {
                                connLimiter.register(string3, this.input);
                            }
                        }
                    }
                }
            }
        }
    }

    public void socketClosed(SocketHandler socketHandler) {
        this.server.disconnect(this);
    }
}

