/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.node;

import VASSAL.chat.node.SocketWatcher;
import java.io.IOException;
import java.net.Socket;
import java.util.Vector;

public abstract class SocketHandler {
    protected Socket sock;
    protected SocketWatcher handler;
    private Vector writeQueue = new Vector();
    private boolean isOpen = true;
    private Thread readThread;
    private Thread writeThread;
    private static final String SIGN_OFF = "!BYE";

    public SocketHandler(Socket socket, SocketWatcher socketWatcher) throws IOException {
        this.sock = socket;
        this.handler = socketWatcher;
    }

    public void start() {
        if (this.readThread == null) {
            this.readThread = this.startReadThread();
        }
        if (this.writeThread == null) {
            this.writeThread = this.startWriteThread();
        }
    }

    private Thread startReadThread() {
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    String string;
                    while ((string = SocketHandler.this.readNext()) != null && !SocketHandler.SIGN_OFF.equals(string)) {
                        if (string.length() <= 0) continue;
                        try {
                            SocketHandler.this.handler.handleMessage(string);
                        }
                        catch (Exception exception) {
                            System.err.println("Caught " + exception.getClass().getName() + " handling " + string);
                            exception.printStackTrace();
                        }
                    }
                }
                catch (IOException iOException) {
                    String string = iOException.getClass().getName();
                    string = string.substring(string.lastIndexOf(46) + 1);
                }
                SocketHandler.this.closeSocket();
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
        return thread;
    }

    private Thread startWriteThread() {
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    String string;
                    do {
                        if ((string = SocketHandler.this.getLine()) == null) continue;
                        SocketHandler.this.writeNext(string);
                    } while (!SocketHandler.SIGN_OFF.equals(string));
                }
                catch (IOException iOException) {
                    String string = iOException.getClass().getName();
                    string = string.substring(string.lastIndexOf(46) + 1);
                }
                SocketHandler.this.closeSocket();
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
        return thread;
    }

    protected abstract void closeStreams() throws IOException;

    protected abstract String readNext() throws IOException;

    protected abstract void writeNext(String var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeLine(String string) {
        Vector vector = this.writeQueue;
        synchronized (vector) {
            this.writeQueue.addElement(string);
            this.writeQueue.notifyAll();
        }
    }

    public void close() {
        this.writeLine(SIGN_OFF);
    }

    private synchronized void closeSocket() {
        if (this.isOpen) {
            try {
                this.closeStreams();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.sock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.isOpen = false;
            this.handler.socketClosed(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLine() {
        Vector vector = this.writeQueue;
        synchronized (vector) {
            if (this.writeQueue.size() == 0) {
                try {
                    this.writeQueue.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            String string = "";
            if (this.writeQueue.size() > 0) {
                string = (String)this.writeQueue.elementAt(0);
                this.writeQueue.removeElementAt(0);
            }
            return string;
        }
    }
}

