/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.peer2peer;

import java.io.IOException;
import java.net.ServerSocket;
import org.litesoft.p2pchat.PendingPeerManager;

public class AcceptPeerThread
extends Thread {
    private boolean running = true;
    private ServerSocket socket;
    private PendingPeerManager ppm;
    private int port;
    private static final int MAX_ATTEMPTS = 10;

    public AcceptPeerThread(int n, PendingPeerManager pendingPeerManager) throws IOException {
        this.ppm = pendingPeerManager;
        for (int i = 0; i < 10; ++i) {
            this.port = n + i;
            try {
                this.socket = new ServerSocket(this.port);
                break;
            }
            catch (Exception exception) {
                if (i != 9) continue;
                throw new IOException(exception.getMessage());
            }
        }
    }

    public int getPort() {
        return this.port;
    }

    public AcceptPeerThread(ServerSocket serverSocket, PendingPeerManager pendingPeerManager) {
        this.socket = serverSocket;
        this.ppm = pendingPeerManager;
    }

    public synchronized void start() {
        this.running = true;
        super.start();
    }

    public void run() {
        while (this.running) {
            try {
                this.ppm.addNewPeer(this.socket.accept());
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.halt();
            }
        }
    }

    public void halt() {
        this.interrupt();
        this.running = false;
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

