/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.peer2peer;

import VASSAL.build.GameModule;
import VASSAL.chat.HttpRequestWrapper;
import VASSAL.chat.peer2peer.AcceptPeerThread;
import VASSAL.chat.peer2peer.P2PPlayer;
import VASSAL.chat.peer2peer.PeerPool;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Enumeration;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.litesoft.p2pchat.PeerInfo;
import org.litesoft.p2pchat.PendingPeerManager;

public class DirectPeerPool
implements PeerPool {
    private AcceptPeerThread acceptThread;
    private JDialog frame;
    private String myIp;

    public void initialize(P2PPlayer p2PPlayer, PendingPeerManager pendingPeerManager) throws IOException {
        this.myIp = p2PPlayer.getInfo().getAddresses();
        try {
            this.myIp = this.discoverMyIpAddressFromRemote();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.acceptThread = new AcceptPeerThread(p2PPlayer.getInfo().getPort(), pendingPeerManager);
        p2PPlayer.getInfo().setPort(this.acceptThread.getPort());
        this.acceptThread.start();
        if (this.frame == null) {
            this.initComponents(p2PPlayer, pendingPeerManager);
        }
        ((Component)this.frame).setVisible(true);
    }

    private String discoverMyIpAddressFromRemote() throws IOException {
        String string = null;
        HttpRequestWrapper httpRequestWrapper = new HttpRequestWrapper("http://www.vassalengine.org/util/getMyAddress");
        Enumeration enumeration = httpRequestWrapper.doGet(null);
        if (!enumeration.hasMoreElements()) {
            throw new IOException("Empty response");
        }
        string = (String)enumeration.nextElement();
        return string;
    }

    public void disconnect() {
        if (this.frame != null) {
            this.frame.dispose();
            this.frame = null;
        }
        if (this.acceptThread != null) {
            this.acceptThread.halt();
            this.acceptThread = null;
        }
    }

    public void connectFailed(PeerInfo peerInfo) {
        JOptionPane.showMessageDialog(this.frame, "Could not reach " + peerInfo.getAddresses() + ":" + peerInfo.getPort(), "Invite failed", 1);
    }

    public void initComponents(P2PPlayer p2PPlayer, final PendingPeerManager pendingPeerManager) {
        JFrame jFrame = null;
        if (GameModule.getGameModule() != null) {
            jFrame = GameModule.getGameModule().getFrame();
        }
        this.frame = new JDialog((Frame)jFrame, "Direct Connection");
        this.frame.setDefaultCloseOperation(1);
        this.frame.getContentPane().setLayout(new BoxLayout(this.frame.getContentPane(), 1));
        this.frame.getContentPane().add(this.createLabel("Your IP address is " + this.myIp + ":" + p2PPlayer.getInfo().getPort()));
        this.frame.getContentPane().add(this.createLabel("Enter another player's address below and hit the \"Invite\" button."));
        this.frame.setDefaultCloseOperation(0);
        Box box = Box.createHorizontalBox();
        box.setAlignmentX(0.0f);
        JButton jButton = new JButton("Invite");
        box.add(jButton);
        final JTextField jTextField = new JTextField("address:port");
        box.add(jTextField);
        this.frame.getContentPane().add(box);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PeerInfo peerInfo = PeerInfo.deFormat(jTextField.getText());
                if (peerInfo != null) {
                    pendingPeerManager.addNewPeer(peerInfo);
                    jTextField.setText("");
                } else {
                    JOptionPane.showMessageDialog(DirectPeerPool.this.frame, "Invalid format <host>:<port>");
                }
            }
        };
        jButton.addActionListener(actionListener);
        jTextField.addActionListener(actionListener);
        this.frame.pack();
        this.frame.setLocationRelativeTo(jFrame);
    }

    private JLabel createLabel(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setAlignmentX(0.0f);
        return jLabel;
    }
}

