/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.peer2peer;

import VASSAL.build.module.Chatter;
import VASSAL.chat.ChatServerConnection;
import VASSAL.chat.Player;
import VASSAL.chat.Room;
import VASSAL.chat.SimpleRoom;
import VASSAL.chat.peer2peer.P2PPlayer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.Random;
import org.litesoft.p2pchat.PeerInfo;

public class EchoClient
implements Runnable,
PropertyChangeListener {
    public static final String NAME = "EchoBot";
    private static Random rng = new Random();
    private int changeRoom;
    private int numRooms;
    private FileWriter log;
    private ChatServerConnection client;

    public EchoClient(ChatServerConnection chatServerConnection, int n, int n2, FileWriter fileWriter) {
        this.client = chatServerConnection;
        this.changeRoom = n;
        this.numRooms = n2;
        this.log = fileWriter;
        chatServerConnection.addPropertyChangeListener("AvailableRooms", this);
        chatServerConnection.addPropertyChangeListener("Status", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                System.err.println("" + propertyChangeEvent.getNewValue());
            }
        });
        chatServerConnection.setConnected(true);
        chatServerConnection.setRoom(new SimpleRoom("Room0"));
        new Thread(this).start();
    }

    public synchronized void showCHAT(PeerInfo peerInfo, String string) {
        P2PPlayer p2PPlayer = new P2PPlayer(peerInfo);
        if (!p2PPlayer.getName().startsWith(NAME) && string.startsWith("CHAT")) {
            string = "<" + this.client.getUserInfo().getName() + string.substring(string.indexOf("> -"));
            Chatter.DisplayText displayText = new Chatter.DisplayText(null, string);
            this.client.sendTo(p2PPlayer, displayText);
        }
    }

    public void run() {
        while (true) {
            try {
                int n = Math.round(rng.nextFloat() * 2.0f * (float)this.changeRoom * 1000.0f);
                Thread.sleep(n);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            String string = "Room" + (int)((float)this.numRooms * rng.nextFloat());
            this.client.setRoom(new SimpleRoom(string));
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.log != null && propertyChangeEvent.getPropertyName().equals("AvailableRooms")) {
            try {
                this.log.write("----------" + new Date() + "---------\n");
                this.log.write(EchoClient.report((Room[])propertyChangeEvent.getNewValue()));
                this.log.flush();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static String report(Room[] roomArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < roomArray.length; ++i) {
            stringBuffer.append(roomArray[i].getName() + ": ");
            Player[] playerArray = (Player[])roomArray[i].getPlayerList().toArray();
            for (int j = 0; j < playerArray.length; ++j) {
                stringBuffer.append(playerArray[j]);
                if (j >= playerArray.length - 1) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }
}

