/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.peer2peer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class IpWatch
implements Runnable {
    private PropertyChangeSupport propSupport = new PropertyChangeSupport(this);
    private String currentIp;
    private long wait = 1000L;

    public IpWatch(long l) {
        this.wait = l;
        this.currentIp = this.findIp();
    }

    public IpWatch() {
        this(1000L);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void run() {
        while (true) {
            String string = this.findIp();
            this.propSupport.firePropertyChange("address", this.currentIp, string);
            this.currentIp = string;
            try {
                Thread.sleep(this.wait);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public String getCurrentIp() {
        return this.currentIp;
    }

    private String findIp() {
        try {
            InetAddress[] inetAddressArray = InetAddress.getAllByName(InetAddress.getLocalHost().getHostName());
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < inetAddressArray.length; ++i) {
                stringBuffer.append(inetAddressArray[i].getHostAddress());
                if (i >= inetAddressArray.length - 1) continue;
                stringBuffer.append(",");
            }
            return stringBuffer.toString();
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public static void main(String[] stringArray) {
        IpWatch ipWatch = new IpWatch();
        ipWatch.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                System.out.println("Address = " + propertyChangeEvent.getNewValue());
            }
        });
        System.out.println("Address = " + ipWatch.getCurrentIp());
        new Thread(ipWatch).start();
    }
}

