/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.peer2peer;

import VASSAL.build.GameModule;
import VASSAL.chat.ChatServerConnection;
import VASSAL.chat.Player;
import VASSAL.chat.Room;
import VASSAL.chat.ServerStatus;
import VASSAL.chat.SimplePlayer;
import VASSAL.chat.SimpleRoom;
import VASSAL.chat.WelcomeMessageServer;
import VASSAL.chat.messageboard.Message;
import VASSAL.chat.messageboard.MessageBoard;
import VASSAL.chat.peer2peer.P2PPlayer;
import VASSAL.chat.peer2peer.PeerPool;
import VASSAL.chat.peer2peer.RoomManager;
import VASSAL.chat.peer2peer.RoomTracker;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import org.litesoft.p2pchat.ActivePeer;
import org.litesoft.p2pchat.ActivePeerManager;
import org.litesoft.p2pchat.MyInfo;
import org.litesoft.p2pchat.PeerInfo;
import org.litesoft.p2pchat.PendingPeerManager;
import org.litesoft.p2pchat.UserDialog;

public class P2PClient
implements ChatServerConnection,
UserDialog {
    private Player me;
    private PendingPeerManager ppm;
    protected ActivePeerManager peerMgr;
    private PeerPool pool;
    private MessageBoard msgSvr;
    private WelcomeMessageServer welcomeMessageServer;
    private RoomManager roomMgr;
    private RoomTracker tracker;
    private PropertyChangeSupport propSupport = new PropertyChangeSupport(this);
    private CommandEncoder encoder;
    private boolean connected = false;
    private ServerStatus svrStatus;

    public P2PClient(CommandEncoder commandEncoder, MessageBoard messageBoard, WelcomeMessageServer welcomeMessageServer, PeerPool peerPool) {
        this.encoder = commandEncoder;
        this.msgSvr = messageBoard;
        this.welcomeMessageServer = welcomeMessageServer;
        this.pool = peerPool;
        this.ppm = new PendingPeerManager(this);
        this.roomMgr = new RoomManager();
        this.tracker = new RoomTracker();
        this.me = new SimplePlayer("???");
    }

    public RoomManager getRoomMgr() {
        return this.roomMgr;
    }

    public void sendToOthers(Command command) {
        this.sendToOthers(this.encoder.encode(command));
    }

    public void sendToAll(String string) {
        if (this.isConnected()) {
            this.sendToOthers(string);
            this.showCHAT(((P2PPlayer)this.me).getInfo(), string);
        }
    }

    public void sendToOthers(String string) {
        if (this.isConnected()) {
            Room room = this.getRoom();
            Player[] playerArray = (Player[])room.getPlayerList().toArray();
            for (int i = 0; i < playerArray.length; ++i) {
                ActivePeer activePeer;
                if (playerArray[i].equals(this.me) || (activePeer = this.peerMgr.getPeerListenerByID(((P2PPlayer)playerArray[i]).getInfo().getID())) == null) continue;
                activePeer.sendCHAT(string);
            }
        }
    }

    public void sendTo(Player player, Command command) {
        if (this.peerMgr != null) {
            this.peerMgr.getPeerListenerByInfo(((P2PPlayer)player).getInfo()).sendCHAT(this.encoder.encode(command));
        }
    }

    public Room getRoom() {
        return this.roomMgr.getRoomContaining(this.me);
    }

    public void setRoom(Room room) {
        if (this.me instanceof P2PPlayer) {
            ((P2PPlayer)this.me).setRoom(room.getName());
            if (this.isConnected()) {
                this.peerMgr.sendToAllNAME();
                this.propSupport.firePropertyChange("AvailableRooms", null, this.roomMgr.update(((P2PPlayer)this.me).getInfo()));
                Room room2 = this.getRoom();
                this.propSupport.firePropertyChange("Room", null, room2);
            }
        }
    }

    public Room[] getAvailableRooms() {
        return this.roomMgr.getRooms();
    }

    public Player getUserInfo() {
        return this.me;
    }

    public void setUserInfo(Player player) {
        if (this.me instanceof P2PPlayer) {
            ((P2PPlayer)this.me).setStats(player);
            if (this.isConnected()) {
                this.propSupport.firePropertyChange("AvailableRooms", null, this.roomMgr.update(((P2PPlayer)this.me).getInfo()));
                this.propSupport.firePropertyChange("Room", null, this.getRoom());
                this.peerMgr.sendToAllNAME();
            }
        } else {
            this.me = player;
        }
        this.propSupport.firePropertyChange("Player", null, this.me);
    }

    public void setConnected(boolean bl) {
        if (bl) {
            try {
                MyInfo myInfo = new MyInfo(null, 5050);
                P2PPlayer p2PPlayer = new P2PPlayer(myInfo);
                p2PPlayer.setName(this.me.getName());
                p2PPlayer.setRoom(this.roomMgr.getDefaultRoom().getName());
                p2PPlayer.setId(GameModule.getUserId() + "." + System.currentTimeMillis());
                this.setUserInfo(p2PPlayer);
                this.pool.initialize(p2PPlayer, this.ppm);
                if (this.peerMgr == null) {
                    this.peerMgr = new ActivePeerManager(myInfo, this, this.ppm);
                }
                this.roomMgr.update(((P2PPlayer)this.me).getInfo());
                this.propSupport.firePropertyChange("Status", null, "Server connection established");
                this.propSupport.firePropertyChange("Connected", null, Boolean.TRUE);
                this.propSupport.firePropertyChange("AvailableRooms", null, this.roomMgr.getRooms());
                this.propSupport.firePropertyChange("Room", null, this.getRoom());
                this.welcomeMessageServer.getWelcomeMessage().execute();
                this.connected = true;
            }
            catch (IOException iOException) {
                this.propSupport.firePropertyChange("Status", null, "Unable to establish connection: " + iOException.getMessage());
                this.propSupport.firePropertyChange("Connected", null, Boolean.FALSE);
                this.connected = false;
            }
        } else if (this.isConnected()) {
            if (this.peerMgr != null) {
                this.peerMgr.clear();
            }
            this.roomMgr.clear();
            this.pool.disconnect();
            this.propSupport.firePropertyChange("Connected", Boolean.TRUE, Boolean.FALSE);
            this.propSupport.firePropertyChange("AvailableRooms", null, new Room[0]);
            this.propSupport.firePropertyChange("Room", new SimpleRoom(), null);
            this.connected = false;
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    public Message[] getMessages() {
        return this.msgSvr.getMessages();
    }

    public void postMessage(String string) {
        this.msgSvr.postMessage(string);
    }

    public MessageBoard getMessageServer() {
        return this.msgSvr;
    }

    public ServerStatus getStatusServer() {
        return this.svrStatus;
    }

    public Player stringToPlayer(String string) {
        return this.roomMgr.getPlayerById(string);
    }

    public String playerToString(Player player) {
        return ((P2PPlayer)player).getId();
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void setActivePeerManager(ActivePeerManager activePeerManager) {
        this.peerMgr = activePeerManager;
    }

    public void setPendingPeerManager(PendingPeerManager pendingPeerManager) {
        this.ppm = pendingPeerManager;
    }

    public synchronized void showUnrecognized(PeerInfo peerInfo, String string) {
    }

    public synchronized void showStreamsFailed(PeerInfo peerInfo) {
        P2PPlayer p2PPlayer = new P2PPlayer(peerInfo);
        this.propSupport.firePropertyChange("Status", null, "Lost connection to to " + p2PPlayer.getName());
    }

    public synchronized void showConnectFailed(PeerInfo peerInfo) {
        this.pool.connectFailed(peerInfo);
    }

    public synchronized void showConnect(PeerInfo peerInfo) {
    }

    public synchronized void showDisconnect(PeerInfo peerInfo) {
        this.propSupport.firePropertyChange("AvailableRooms", null, this.roomMgr.remove(peerInfo));
        this.propSupport.firePropertyChange("Room", null, this.getRoom());
    }

    public synchronized void showCHAT(PeerInfo peerInfo, String string) {
        this.propSupport.firePropertyChange("Msg", null, string);
    }

    public synchronized void showPMSG(PeerInfo peerInfo, String string) {
        this.showCHAT(peerInfo, string);
    }

    public synchronized void showNAME(PeerInfo peerInfo) {
        this.tracker.init(this.getRoom());
        this.propSupport.firePropertyChange("AvailableRooms", null, this.roomMgr.update(peerInfo));
        Room room = this.getRoom();
        this.propSupport.firePropertyChange("Room", null, room);
        this.tracker.finalize(room);
    }

    public synchronized void showHELO(PeerInfo peerInfo) {
        this.propSupport.firePropertyChange("AvailableRooms", null, this.roomMgr.update(peerInfo));
        this.propSupport.firePropertyChange("Room", null, this.getRoom());
    }
}

