/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.peer2peer;

import VASSAL.chat.Player;
import VASSAL.chat.SimplePlayer;
import VASSAL.chat.SimpleStatus;
import VASSAL.tools.PropertiesEncoder;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import org.litesoft.p2pchat.PeerInfo;

public class P2PPlayer
extends SimplePlayer {
    private static final String NAME = "name";
    private static final String ID = "id";
    private static final String ROOM = "room";
    private static final String LOOKING = "looking";
    private static final String AWAY = "away";
    private static final String PROFILE = "profile";
    private PeerInfo info;
    private Properties props;

    public P2PPlayer(PeerInfo peerInfo) {
        this.info = peerInfo;
        if (peerInfo.getChatName() != null) {
            try {
                this.props = new PropertiesEncoder(peerInfo.getChatName()).getProperties();
                this.setStats();
            }
            catch (IOException iOException) {
                this.props = new Properties();
                this.setProps();
            }
        } else {
            this.props = new Properties();
            this.setProps();
        }
    }

    public void setStats(Player player) {
        this.setName(player.getName());
        this.setStatus(player.getStatus());
        this.setProps();
    }

    private void setProps() {
        ((Hashtable)this.props).put(NAME, this.getName());
        ((Hashtable)this.props).put(LOOKING, "" + ((SimpleStatus)this.status).isLooking());
        ((Hashtable)this.props).put(AWAY, "" + ((SimpleStatus)this.getStatus()).isAway());
        ((Hashtable)this.props).put(PROFILE, ((SimpleStatus)this.status).getProfile());
        this.info.setChatName(new PropertiesEncoder(this.props).getStringValue());
    }

    private void setStats() {
        this.setName(this.props.getProperty(NAME, "???"));
        this.setStatus(new SimpleStatus("true".equals(this.props.getProperty(LOOKING)), "true".equals(this.props.getProperty(AWAY)), this.props.getProperty(PROFILE, "")));
    }

    public String getRoom() {
        return this.props.getProperty(ROOM);
    }

    public void setRoom(String string) {
        ((Hashtable)this.props).put(ROOM, string);
        this.setProps();
    }

    public String getId() {
        return this.props.getProperty(ID);
    }

    public void setId(String string) {
        ((Hashtable)this.props).put(ID, string);
        this.setProps();
    }

    public boolean equals(Object object) {
        if (object instanceof P2PPlayer) {
            P2PPlayer p2PPlayer = (P2PPlayer)object;
            return this.getId() == null ? this.info.equals(p2PPlayer.info) : this.getId().equals(p2PPlayer.getId());
        }
        return false;
    }

    public PeerInfo getInfo() {
        return this.info;
    }

    public String summary() {
        return this.getName() + " [looking = " + ((SimpleStatus)this.status).isLooking() + ", away = " + ((SimpleStatus)this.getStatus()).isAway() + ", room = " + this.props.getProperty(ROOM) + ", host = " + this.getInfo().getAddresses() + "]";
    }
}

