/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.peer2peer;

import VASSAL.chat.Player;
import VASSAL.chat.Room;
import VASSAL.chat.SimpleRoom;
import VASSAL.chat.peer2peer.P2PPlayer;
import java.util.Enumeration;
import java.util.Vector;
import org.litesoft.p2pchat.PeerInfo;

public class RoomManager {
    private Vector rooms = new Vector();
    private SimpleRoom defaultRoom = new SimpleRoom("Main Room");

    public RoomManager() {
        this.rooms.addElement(this.defaultRoom);
    }

    public Room[] update(PeerInfo peerInfo) {
        P2PPlayer p2PPlayer = new P2PPlayer(peerInfo);
        SimpleRoom simpleRoom = this.getRoomContaining(p2PPlayer);
        Room room = new SimpleRoom(p2PPlayer.getRoom());
        if (this.rooms.contains(room)) {
            room = (Room)this.rooms.elementAt(this.rooms.indexOf(room));
        } else {
            this.rooms.addElement(room);
        }
        room.addPlayer(p2PPlayer);
        if (simpleRoom != null && !((Object)simpleRoom).equals(room)) {
            simpleRoom.removePlayer(p2PPlayer);
            if (simpleRoom.getPlayerList().size() == 0 && !((Object)simpleRoom).equals(this.defaultRoom)) {
                this.rooms.removeElement(simpleRoom);
            }
        }
        return this.getRooms();
    }

    public Room[] remove(PeerInfo peerInfo) {
        P2PPlayer p2PPlayer = new P2PPlayer(peerInfo);
        for (int i = 0; i < this.rooms.size(); ++i) {
            Room room = (Room)this.rooms.elementAt(i);
            room.removePlayer(p2PPlayer);
            if (room.getPlayerList().size() != 0 || room.equals(this.defaultRoom)) continue;
            this.rooms.removeElementAt(i--);
        }
        return this.getRooms();
    }

    public P2PPlayer getPlayerById(String string) {
        for (int i = 0; i < this.rooms.size(); ++i) {
            Room room = (Room)this.rooms.elementAt(i);
            Player[] playerArray = (Player[])room.getPlayerList().toArray();
            for (int j = 0; j < playerArray.length; ++j) {
                P2PPlayer p2PPlayer = (P2PPlayer)playerArray[j];
                if (!string.equals(p2PPlayer.getId())) continue;
                return p2PPlayer;
            }
        }
        return null;
    }

    public Room[] getRooms() {
        Room[] roomArray = new Room[this.rooms.size()];
        for (int i = 0; i < roomArray.length; ++i) {
            roomArray[i] = (Room)this.rooms.elementAt(i);
        }
        return roomArray;
    }

    public SimpleRoom getRoomContaining(Player player) {
        Enumeration enumeration = this.rooms.elements();
        while (enumeration.hasMoreElements()) {
            SimpleRoom simpleRoom = (SimpleRoom)enumeration.nextElement();
            if (!simpleRoom.contains(player)) continue;
            return simpleRoom;
        }
        return null;
    }

    public void setDefaultRoomName(String string) {
        this.defaultRoom.setName(string);
    }

    public Room getDefaultRoom() {
        return this.defaultRoom;
    }

    public void clear() {
        this.rooms.removeAllElements();
        this.defaultRoom.setPlayers(new Player[0]);
        this.rooms.addElement(this.defaultRoom);
    }
}

