/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.peer2peer;

import VASSAL.chat.peer2peer.AcceptPeerThread;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Properties;
import org.litesoft.p2pchat.ActivePeerManager;
import org.litesoft.p2pchat.MyInfo;
import org.litesoft.p2pchat.PeerInfo;
import org.litesoft.p2pchat.PeerReader;
import org.litesoft.p2pchat.PeerWriter;
import org.litesoft.p2pchat.PendingPeerManager;
import org.litesoft.p2pchat.UserDialog;

public class UnitTest
implements UserDialog {
    private String id;

    public UnitTest(String string) {
        this.id = string;
    }

    public static void main(String[] stringArray) throws Exception {
        Properties properties = new Properties();
        if ("true".equals(properties.getProperty("reader"))) {
            UnitTest.testPeer();
        }
        if ("true".equals(properties.getProperty("manager"))) {
            UnitTest.testPeerManager();
        }
        if ("true".equals(properties.getProperty("managers"))) {
            UnitTest.testPeerManagers();
        }
    }

    private static void testPeerManager() throws InterruptedException, IOException {
        UnitTest.startSocketReader(5555);
        UnitTest unitTest = new UnitTest("Client");
        PendingPeerManager pendingPeerManager = new PendingPeerManager(unitTest);
        ActivePeerManager activePeerManager = new ActivePeerManager(new MyInfo("TestClient", 5556), unitTest, pendingPeerManager);
        PeerInfo peerInfo = new PeerInfo("SocketReader", "localhost", 5555);
        peerInfo.setID("SocketReader");
        pendingPeerManager.addNewPeer(peerInfo);
        Thread.sleep(10000L);
        activePeerManager.sendToAllCHAT("A message");
        activePeerManager.getPeerListenerByID("1").close();
        System.err.println("Closed peer");
    }

    private static void testPeerManagers() throws InterruptedException, IOException {
        UnitTest unitTest = new UnitTest("Server");
        PendingPeerManager pendingPeerManager = new PendingPeerManager(unitTest);
        new AcceptPeerThread(5555, pendingPeerManager).start();
        UnitTest unitTest2 = new UnitTest("Client");
        PendingPeerManager pendingPeerManager2 = new PendingPeerManager(unitTest2);
        ActivePeerManager activePeerManager = new ActivePeerManager(new MyInfo("Client", 5556), unitTest2, pendingPeerManager2);
        PeerInfo peerInfo = new PeerInfo("Server", "localhost", 5555);
        peerInfo.setID("Server");
        pendingPeerManager2.addNewPeer(peerInfo);
        Thread.sleep(5000L);
        activePeerManager.sendToAllCHAT("A message");
        activePeerManager.clear();
    }

    private static void testPeer() throws InterruptedException, IOException {
        UnitTest.startSocketReader(5555);
        Socket socket = new Socket("localhost", 5555);
        PeerReader peerReader = new PeerReader(socket.getInputStream());
        System.err.println("Created reader " + peerReader);
        PeerWriter peerWriter = new PeerWriter(socket.getOutputStream());
        System.err.println("Created writer" + peerWriter);
        peerWriter.writeLine("A message");
        Thread.sleep(2000L);
        peerReader.close();
        peerWriter.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startSocketReader(final int n) throws InterruptedException {
        final Object object = new Object();
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    String string;
                    ServerSocket serverSocket;
                    Object object2 = object;
                    synchronized (object2) {
                        serverSocket = new ServerSocket(n);
                        object.notifyAll();
                    }
                    object2 = serverSocket.accept();
                    PeerReader peerReader = new PeerReader(((Socket)object2).getInputStream());
                    do {
                        string = peerReader.readLine();
                        System.err.println("" + string);
                    } while (string != null);
                    System.err.println("Done");
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        };
        Object object2 = object;
        synchronized (object2) {
            new Thread(runnable).start();
            object.wait();
        }
    }

    public void setActivePeerManager(ActivePeerManager activePeerManager) {
    }

    public void setPendingPeerManager(PendingPeerManager pendingPeerManager) {
    }

    public void showUnrecognized(PeerInfo peerInfo, String string) {
        System.err.println(this + "Unrecognized " + peerInfo);
    }

    public void showStreamsFailed(PeerInfo peerInfo) {
        System.err.println(this + "Streams Failed " + peerInfo);
    }

    public void showConnectFailed(PeerInfo peerInfo) {
        System.err.println(this + "Connect Failed " + peerInfo);
    }

    public void showConnect(PeerInfo peerInfo) {
        System.err.println(this + "Connect " + peerInfo);
    }

    public void showDisconnect(PeerInfo peerInfo) {
        System.err.println(this + "Disconnect " + peerInfo);
    }

    public void showCHAT(PeerInfo peerInfo, String string) {
        System.err.println(this + "Chat " + peerInfo);
    }

    public void showPMSG(PeerInfo peerInfo, String string) {
        System.err.println(this + "Private Chat " + peerInfo);
    }

    public void showNAME(PeerInfo peerInfo) {
        System.err.println(this + "Name " + peerInfo);
    }

    public void showHELO(PeerInfo peerInfo) {
        System.err.println(this + "Hello " + peerInfo);
    }

    public String toString() {
        return this.id + ": ";
    }
}

