/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.ui;

import VASSAL.build.AbstractBuildable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GlobalOptions;
import VASSAL.build.module.ServerConnection;
import VASSAL.chat.ChatServerConnection;
import VASSAL.chat.Room;
import VASSAL.chat.ui.BasicChatControlsInitializer;
import VASSAL.chat.ui.ChatControlsInitializer;
import VASSAL.chat.ui.RoomTree;
import VASSAL.configure.HotKeyConfigurer;
import VASSAL.configure.IconConfigurer;
import VASSAL.preferences.VisibilityOption;
import VASSAL.tools.ComponentSplitter;
import VASSAL.tools.KeyStrokeListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;

public class ChatServerControls
extends AbstractBuildable {
    protected RoomTree currentRoom;
    protected JTextField newRoom;
    protected JToolBar toolbar;
    protected RoomTree roomTree;
    protected JButton launch;
    protected ChatServerConnection client;
    protected JPanel controlPanel;
    protected ComponentSplitter.SplitPane splitter;
    protected ChatControlsInitializer oldClient;
    protected BasicChatControlsInitializer basicControls;

    public ChatServerControls() {
        JSplitPane jSplitPane = new JSplitPane(1);
        this.roomTree = new RoomTree();
        JScrollPane jScrollPane = new JScrollPane(this.roomTree);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        Box box = Box.createHorizontalBox();
        box.add(new JLabel("New Game: "));
        this.newRoom = new JTextField(12);
        this.newRoom.setMaximumSize(this.newRoom.getPreferredSize());
        box.add(this.newRoom);
        jPanel.add(box);
        jPanel.add(jScrollPane);
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createRaisedBevelBorder(), "Active Games"));
        jSplitPane.setLeftComponent(jPanel);
        this.currentRoom = new RoomTree();
        this.currentRoom.addTreeWillExpandListener(new TreeWillExpandListener(){

            public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
                throw new ExpandVetoException(treeExpansionEvent);
            }

            public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
            }
        });
        jScrollPane = new JScrollPane(this.currentRoom);
        jScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createRaisedBevelBorder(), "Current Game"));
        jSplitPane.setRightComponent(jScrollPane);
        jSplitPane.setDividerLocation(160);
        jSplitPane.setPreferredSize(new Dimension(320, 120));
        this.controlPanel = new JPanel();
        this.controlPanel.setLayout(new BorderLayout());
        this.controlPanel.add("Center", jSplitPane);
        this.toolbar = new JToolBar();
        this.controlPanel.add("North", this.toolbar);
        this.toolbar.addSeparator();
    }

    public void addTo(Buildable buildable) {
        GameModule gameModule = GameModule.getGameModule();
        this.setClient((ChatServerConnection)gameModule.getServer());
        this.launch = new JButton("Server");
        this.launch.setAlignmentY(0.0f);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChatServerControls.this.toggleVisible();
            }
        };
        this.launch.addActionListener(actionListener);
        final KeyStrokeListener keyStrokeListener = new KeyStrokeListener(actionListener);
        keyStrokeListener.setKeyStroke(KeyStroke.getKeyStroke(83, 8));
        URL uRL = this.getClass().getResource("/images/connect.gif");
        if (uRL != null) {
            this.launch.setIcon(new ImageIcon(uRL));
            this.launch.setText(null);
        }
        GameModule.getGameModule().getFrame().addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                GameModule.getGameModule().getFrame().removeComponentListener(this);
                IconConfigurer iconConfigurer = new IconConfigurer("serverControlsIcon", "Server controls button icon", "/images/connect.gif");
                iconConfigurer.setValue("/images/connect.gif");
                GlobalOptions.getInstance().addOption(iconConfigurer);
                iconConfigurer.addPropertyChangeListener(new PropertyChangeListener(this, iconConfigurer){
                    private final /* synthetic */ IconConfigurer val$iconConfig;
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$iconConfig = iconConfigurer;
                    }

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        3.access$000(this.this$1).launch.setIcon(this.val$iconConfig.getIconValue());
                    }
                });
                iconConfigurer.fireUpdate();
                HotKeyConfigurer hotKeyConfigurer = new HotKeyConfigurer("serverControlsHotKey", "Server controls hotkey", keyStrokeListener.getKeyStroke());
                GlobalOptions.getInstance().addOption(hotKeyConfigurer);
                hotKeyConfigurer.addPropertyChangeListener(new PropertyChangeListener(this, hotKeyConfigurer){
                    private final /* synthetic */ HotKeyConfigurer val$keyConfig;
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$keyConfig = hotKeyConfigurer;
                    }

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        3.access$100(this.this$1).setKeyStroke((KeyStroke)this.val$keyConfig.getValue());
                        3.access$000(this.this$1).launch.setToolTipText("Show/Hide the server controls [" + HotKeyConfigurer.getString(3.access$100(this.this$1).getKeyStroke()) + "]");
                    }
                });
                hotKeyConfigurer.fireUpdate();
            }

            static /* synthetic */ ChatServerControls access$000(3 var0) {
                return var0.ChatServerControls.this;
            }

            static /* synthetic */ KeyStrokeListener access$100(3 var0) {
                return var0.keyStrokeListener;
            }
        });
        gameModule.addKeyStrokeListener(keyStrokeListener);
        gameModule.getToolBar().add(this.launch);
    }

    protected void toggleVisible() {
        if (this.controlPanel.getTopLevelAncestor() == null) {
            if (GlobalOptions.getInstance().isUseSingleWindow()) {
                this.splitter = new ComponentSplitter().splitRight(GameModule.getGameModule().getControlPanel(), this.controlPanel, false);
                this.splitter.revalidate();
                Runnable runnable = new Runnable(){

                    public void run() {
                        ChatServerControls.this.splitter.showComponent();
                    }
                };
                SwingUtilities.invokeLater(runnable);
            } else {
                JFrame jFrame = new JFrame("Server");
                jFrame.setDefaultCloseOperation(1);
                jFrame.getContentPane().add(this.controlPanel);
                String string = "BoundsOfClientWindow";
                VisibilityOption visibilityOption = new VisibilityOption(string, jFrame);
                GameModule.getGameModule().getPrefs().addOption(visibilityOption);
                ((Component)jFrame).setVisible(true);
            }
        } else if (this.splitter != null) {
            this.splitter.toggleVisibility();
        } else {
            this.controlPanel.getTopLevelAncestor().setVisible(!this.controlPanel.getTopLevelAncestor().isVisible());
        }
    }

    public JPanel getControls() {
        return this.controlPanel;
    }

    public void setClient(ChatServerConnection chatServerConnection) {
        this.client = chatServerConnection;
        if (chatServerConnection instanceof ChatControlsInitializer) {
            if (this.basicControls != null) {
                this.basicControls.uninitializeControls(this);
            }
            if (this.oldClient != null) {
                this.oldClient.uninitializeControls(this);
            }
            this.basicControls = new BasicChatControlsInitializer(chatServerConnection);
            this.basicControls.initializeControls(this);
            ((ChatControlsInitializer)((Object)chatServerConnection)).initializeControls(this);
            this.oldClient = (ChatControlsInitializer)((Object)chatServerConnection);
        }
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Runnable runnable = new Runnable(this, propertyChangeEvent){
                    private final /* synthetic */ PropertyChangeEvent val$evt;
                    private final /* synthetic */ 7 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$evt = propertyChangeEvent;
                    }

                    public void run() {
                        7.access$200(this.this$1).roomTree.setRooms((Room[])this.val$evt.getNewValue());
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }

            static /* synthetic */ ChatServerControls access$200(7 var0) {
                return var0.ChatServerControls.this;
            }
        };
        this.client.addPropertyChangeListener("AvailableRooms", propertyChangeListener);
        PropertyChangeListener propertyChangeListener2 = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Runnable runnable = new Runnable(this, propertyChangeEvent){
                    private final /* synthetic */ PropertyChangeEvent val$evt;
                    private final /* synthetic */ 9 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$evt = propertyChangeEvent;
                    }

                    public void run() {
                        if (this.val$evt.getNewValue() == null) {
                            9.access$300(this.this$1).currentRoom.setRooms(new Room[0]);
                        } else {
                            9.access$300(this.this$1).currentRoom.setRooms(new Room[]{(Room)this.val$evt.getNewValue()});
                            Object object = 9.access$300(this.this$1).currentRoom.getModel().getRoot();
                            Object object2 = 9.access$300(this.this$1).currentRoom.getModel().getChild(object, 0);
                            9.access$300(this.this$1).currentRoom.expandPath(new TreePath(new Object[]{object, object2}));
                        }
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }

            static /* synthetic */ ChatServerControls access$300(9 var0) {
                return var0.ChatServerControls.this;
            }
        };
        this.client.addPropertyChangeListener("Room", propertyChangeListener2);
    }

    public ChatServerConnection getSvrConnection() {
        return this.client;
    }

    public ServerConnection getClient() {
        return this.client;
    }

    public String[] getAttributeNames() {
        return new String[0];
    }

    public void setAttribute(String string, Object object) {
    }

    public String getAttributeValueString(String string) {
        return null;
    }

    public JToolBar getToolbar() {
        return this.toolbar;
    }

    public RoomTree getCurrentRoom() {
        return this.currentRoom;
    }

    public JTextField getNewRoom() {
        return this.newRoom;
    }

    public RoomTree getRoomTree() {
        return this.roomTree;
    }
}

