/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.ui;

import VASSAL.chat.HybridClient;
import VASSAL.chat.LockableRoom;
import VASSAL.chat.Room;
import VASSAL.chat.node.NodeClient;
import VASSAL.chat.node.NodeRoom;
import VASSAL.chat.ui.JoinRoomAction;
import VASSAL.chat.ui.RoomInteractionControlsInitializer;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import javax.swing.JTree;

public class LockableRoomControls
extends RoomInteractionControlsInitializer {
    public LockableRoomControls(NodeClient nodeClient) {
        super(nodeClient);
    }

    public void doubleClickRoom(Room room, JTree jTree) {
        if (!(room instanceof LockableRoom) || !((LockableRoom)((Object)room)).isLocked()) {
            super.doubleClickRoom(room, jTree);
        }
    }

    public JPopupMenu buildPopupForRoom(Room room, JTree jTree) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JoinRoomAction joinRoomAction = new JoinRoomAction(room, this.client);
        jPopupMenu.add(joinRoomAction);
        NodeClient nodeClient = this.getNodeClient();
        if (nodeClient != null) {
            LockableRoom lockableRoom;
            if (room instanceof LockableRoom && (lockableRoom = (LockableRoom)((Object)room)).isLocked()) {
                joinRoomAction.setEnabled(false);
            }
            jPopupMenu.add(new LockRoomAction((NodeRoom)room, nodeClient));
        }
        return jPopupMenu;
    }

    private NodeClient getNodeClient() {
        NodeClient nodeClient = null;
        if (this.client instanceof NodeClient) {
            nodeClient = (NodeClient)this.client;
        } else if (this.client instanceof HybridClient && ((HybridClient)this.client).getDelegate() instanceof NodeClient) {
            nodeClient = (NodeClient)((HybridClient)this.client).getDelegate();
        }
        return nodeClient;
    }

    protected void createRoom(String string) {
        Room room = null;
        Room[] roomArray = this.client.getAvailableRooms();
        for (int i = 0; room == null && i < roomArray.length; ++i) {
            if (!roomArray[i].getName().equals(string)) continue;
            room = roomArray[i];
        }
        NodeClient nodeClient = this.getNodeClient();
        if (room instanceof NodeRoom) {
            if (!((NodeRoom)room).isLocked()) {
                this.client.setRoom(room);
            }
        } else if (room == null && nodeClient != null) {
            NodeRoom nodeRoom = new NodeRoom(string);
            nodeRoom.setOwner(nodeClient.getMyInfo().getId());
            this.client.setRoom(nodeRoom);
            nodeClient.sendRoomInfo(nodeRoom);
        } else {
            super.createRoom(string);
        }
    }

    public static class LockRoomAction
    extends AbstractAction {
        private NodeClient client;
        private NodeRoom target;

        public LockRoomAction(NodeRoom nodeRoom, NodeClient nodeClient) {
            super("Lock Room");
            this.setEnabled(nodeClient.getMyInfo().getId().equals(nodeRoom.getOwner()));
            this.target = nodeRoom;
            this.client = nodeClient;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.client.lockRoom(this.target);
        }
    }
}

