/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.ui;

import VASSAL.chat.ChatServerConnection;
import VASSAL.chat.Player;
import VASSAL.chat.PrivateChatManager;
import VASSAL.chat.PrivateChatter;
import VASSAL.chat.ui.PlayerActionFactory;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JTree;

public class PrivateMessageAction
extends AbstractAction {
    private Player p;
    private PrivateChatManager mgr;

    public PrivateMessageAction(Player player, ChatServerConnection chatServerConnection, PrivateChatManager privateChatManager) {
        super("Private Msg");
        this.p = player;
        this.mgr = privateChatManager;
        this.setEnabled(player != null && chatServerConnection != null && privateChatManager != null && !player.equals(chatServerConnection.getUserInfo()));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        PrivateChatter privateChatter = this.mgr.getChatterFor(this.p);
        Window window = (Window)privateChatter.getTopLevelAncestor();
        ((Component)window).setVisible(true);
        window.toFront();
    }

    public static PlayerActionFactory factory(final ChatServerConnection chatServerConnection, final PrivateChatManager privateChatManager) {
        return new PlayerActionFactory(){

            public Action getAction(Player player, JTree jTree) {
                return new PrivateMessageAction(player, chatServerConnection, privateChatManager);
            }
        };
    }
}

