/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.ui;

import VASSAL.chat.ChatServerConnection;
import VASSAL.chat.Player;
import VASSAL.chat.Room;
import VASSAL.chat.SimpleRoom;
import VASSAL.chat.ui.ChatControlsInitializer;
import VASSAL.chat.ui.ChatServerControls;
import VASSAL.chat.ui.JoinRoomAction;
import VASSAL.chat.ui.PlayerActionFactory;
import VASSAL.chat.ui.RoomActionFactory;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class RoomInteractionControlsInitializer
implements ChatControlsInitializer {
    public static final Font POPUP_MENU_FONT = new Font("Dialog", 0, 10);
    private List playerActionFactories = new ArrayList();
    private List roomActionFactories = new ArrayList();
    protected ChatServerConnection client;
    private MouseAdapter currentRoomPopupBuilder;
    private MouseAdapter roomPopupBuilder;
    private ActionListener roomCreator;

    public RoomInteractionControlsInitializer(ChatServerConnection chatServerConnection) {
        this.client = chatServerConnection;
    }

    public void initializeControls(final ChatServerControls chatServerControls) {
        this.currentRoomPopupBuilder = new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                JPopupMenu jPopupMenu;
                Object object;
                TreePath treePath;
                JTree jTree = (JTree)mouseEvent.getSource();
                if (mouseEvent.isMetaDown() && (treePath = jTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY())) != null && (object = ((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject()) instanceof Player && (jPopupMenu = RoomInteractionControlsInitializer.this.buildPopupForPlayer((Player)object, jTree)) != null) {
                    int n = jPopupMenu.getComponentCount();
                    for (int i = 0; i < n; ++i) {
                        jPopupMenu.getComponent(i).setFont(POPUP_MENU_FONT);
                    }
                    jPopupMenu.show(jTree, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        };
        chatServerControls.getCurrentRoom().addMouseListener(this.currentRoomPopupBuilder);
        this.roomPopupBuilder = new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                JTree jTree = (JTree)mouseEvent.getSource();
                TreePath treePath = jTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (treePath != null) {
                    Object object = ((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
                    if (object instanceof Player) {
                        if (mouseEvent.isMetaDown()) {
                            JPopupMenu jPopupMenu = RoomInteractionControlsInitializer.this.buildPopupForPlayer((Player)object, jTree);
                            int n = jPopupMenu.getComponentCount();
                            for (int i = 0; i < n; ++i) {
                                jPopupMenu.getComponent(i).setFont(POPUP_MENU_FONT);
                            }
                            jPopupMenu.show(jTree, mouseEvent.getX(), mouseEvent.getY());
                        }
                    } else if (object instanceof SimpleRoom) {
                        if (mouseEvent.isMetaDown()) {
                            JPopupMenu jPopupMenu = RoomInteractionControlsInitializer.this.buildPopupForRoom((Room)object, jTree);
                            if (jPopupMenu != null) {
                                int n = jPopupMenu.getComponentCount();
                                for (int i = 0; i < n; ++i) {
                                    jPopupMenu.getComponent(i).setFont(POPUP_MENU_FONT);
                                }
                                jPopupMenu.show(jTree, mouseEvent.getX(), mouseEvent.getY());
                            }
                        } else if (mouseEvent.getClickCount() == 2) {
                            int n = jTree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                            if (jTree.isCollapsed(n)) {
                                jTree.expandRow(n);
                            } else {
                                jTree.collapseRow(n);
                            }
                            RoomInteractionControlsInitializer.this.doubleClickRoom((Room)object, jTree);
                        }
                    }
                }
            }
        };
        chatServerControls.getRoomTree().addMouseListener(this.roomPopupBuilder);
        this.roomCreator = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RoomInteractionControlsInitializer.this.createRoom(chatServerControls.getNewRoom().getText());
                chatServerControls.getNewRoom().setText("");
            }
        };
        chatServerControls.getNewRoom().addActionListener(this.roomCreator);
    }

    protected void createRoom(String string) {
        this.client.setRoom(new SimpleRoom(string));
    }

    public JPopupMenu buildPopupForRoom(Room room, JTree jTree) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        Iterator iterator = this.roomActionFactories.iterator();
        while (iterator.hasNext()) {
            RoomActionFactory roomActionFactory = (RoomActionFactory)iterator.next();
            jPopupMenu.add(roomActionFactory.getAction(room, jTree));
        }
        return jPopupMenu.getComponentCount() == 0 ? null : jPopupMenu;
    }

    public void doubleClickRoom(Room room, JTree jTree) {
        if (!room.equals(this.client.getRoom())) {
            new JoinRoomAction(room, this.client).actionPerformed(null);
        }
    }

    public void addPlayerActionFactory(PlayerActionFactory playerActionFactory) {
        this.playerActionFactories.add(playerActionFactory);
    }

    public void addRoomActionFactory(RoomActionFactory roomActionFactory) {
        this.roomActionFactories.add(roomActionFactory);
    }

    public JPopupMenu buildPopupForPlayer(Player player, JTree jTree) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        Iterator iterator = this.playerActionFactories.iterator();
        while (iterator.hasNext()) {
            PlayerActionFactory playerActionFactory = (PlayerActionFactory)iterator.next();
            jPopupMenu.add(playerActionFactory.getAction(player, jTree));
        }
        return jPopupMenu.getComponentCount() == 0 ? null : jPopupMenu;
    }

    public void uninitializeControls(ChatServerControls chatServerControls) {
        chatServerControls.getRoomTree().removeMouseListener(this.roomPopupBuilder);
        chatServerControls.getCurrentRoom().removeMouseListener(this.currentRoomPopupBuilder);
        chatServerControls.getNewRoom().removeActionListener(this.roomCreator);
    }
}

