/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.ui;

import VASSAL.chat.Player;
import VASSAL.chat.Room;
import VASSAL.chat.ServerStatus;
import VASSAL.chat.SimpleRoom;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

public class ServerStatusView
extends JTabbedPane
implements ChangeListener,
TreeSelectionListener {
    public static final String SELECTION_PROPERTY = "ServerStatusView.selection";
    private ServerStatus status;
    private DefaultTreeModel model;
    private DefaultTreeModel[] historicalModels;
    private JTree treeCurrent;
    private JTree[] historicalTrees;

    public ServerStatusView(ServerStatus serverStatus) {
        this.status = serverStatus;
        this.initComponents();
    }

    private void initComponents() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        JButton jButton = new JButton("Refresh");
        jButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                ServerStatusView.this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    ServerStatusView.this.refresh();
                }
                finally {
                    ServerStatusView.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        jToolBar.add(jButton);
        jPanel.add((Component)jToolBar, "North");
        this.treeCurrent = this.createTree();
        jPanel.add((Component)new JScrollPane(this.treeCurrent), "Center");
        this.model = (DefaultTreeModel)this.treeCurrent.getModel();
        this.addTab("Current", jPanel);
        this.addChangeListener(this);
        this.setBorder(new TitledBorder("Server Connections"));
        this.setStatusServer(this.status);
    }

    private void buildHistoricalTabs() {
        while (this.getTabCount() > 1) {
            this.removeTabAt(this.getTabCount() - 1);
        }
        if (this.status != null) {
            String[] stringArray = this.status.getSupportedTimeRanges();
            this.historicalTrees = new JTree[stringArray.length];
            this.historicalModels = new DefaultTreeModel[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.historicalTrees[i] = this.createTree();
                this.historicalModels[i] = (DefaultTreeModel)this.historicalTrees[i].getModel();
                this.addTab(stringArray[i], new JScrollPane(this.historicalTrees[i]));
            }
        }
    }

    private JTree createTree() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("VASSAL");
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(defaultMutableTreeNode, true);
        JTree jTree = new JTree(defaultTreeModel);
        jTree.getSelectionModel().setSelectionMode(1);
        jTree.setCellRenderer(new Render());
        jTree.expandRow(0);
        jTree.addTreeSelectionListener(this);
        jTree.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                JComponent jComponent = (JComponent)treeExpansionEvent.getSource();
                jComponent.setSize(jComponent.getPreferredSize());
                jComponent.revalidate();
            }

            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            }
        });
        return jTree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void stateChanged(ChangeEvent var1_1) {
        if (this.status == null) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            var2_2 = this.getSelectedIndex();
            switch (var2_2) {
                case 0: {
                    this.refresh();
                    ** break;
lbl10:
                    // 1 sources

                    break;
                }
                default: {
                    this.refresh(this.historicalModels[var2_2 - 1], this.status.getHistory(this.getTitleAt(var2_2)));
                    break;
                }
            }
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        this.fireSelectionChanged();
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.fireSelectionChanged();
    }

    private void fireSelectionChanged() {
        Object object = null;
        TreePath treePath = null;
        int n = this.getSelectedIndex();
        switch (n) {
            case 0: {
                treePath = this.treeCurrent.getSelectionPath();
                break;
            }
            default: {
                treePath = this.historicalTrees[n - 1].getSelectionPath();
            }
        }
        if (treePath != null) {
            object = treePath.getLastPathComponent();
        }
        if (object instanceof DefaultMutableTreeNode) {
            object = ((DefaultMutableTreeNode)object).getUserObject();
        }
        this.firePropertyChange(SELECTION_PROPERTY, null, object);
    }

    public void refresh() {
        this.refresh(this.model, this.status.getStatus());
    }

    private void refresh(DefaultTreeModel defaultTreeModel, ServerStatus.ModuleSummary[] moduleSummaryArray) {
        MutableTreeNode mutableTreeNode = (MutableTreeNode)defaultTreeModel.getRoot();
        while (mutableTreeNode.getChildCount() > 0) {
            defaultTreeModel.removeNodeFromParent((MutableTreeNode)mutableTreeNode.getChildAt(0));
        }
        if (moduleSummaryArray.length == 0) {
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("No connections");
            defaultMutableTreeNode.setAllowsChildren(false);
        } else {
            for (int i = 0; i < moduleSummaryArray.length; ++i) {
                defaultTreeModel.insertNodeInto(this.createNode(moduleSummaryArray[i]), mutableTreeNode, mutableTreeNode.getChildCount());
            }
        }
    }

    private DefaultMutableTreeNode createNode(Object object) {
        Object object2;
        Object[] objectArray = null;
        if (object instanceof ServerStatus.ModuleSummary) {
            objectArray = ((ServerStatus.ModuleSummary)object).getRooms();
        } else if (object instanceof SimpleRoom) {
            object2 = ((Room)object).getPlayerList();
            objectArray = object2.toArray(new Player[object2.size()]);
        }
        object2 = new DefaultMutableTreeNode(object);
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                ((DefaultMutableTreeNode)object2).add(this.createNode(objectArray[i]));
            }
        }
        ((DefaultMutableTreeNode)object2).setAllowsChildren(objectArray != null);
        return object2;
    }

    public void setStatusServer(ServerStatus serverStatus) {
        this.status = serverStatus;
        this.buildHistoricalTabs();
        this.setEnabled(serverStatus != null);
    }

    public static class Render
    extends DefaultTreeCellRenderer {
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (bl3) {
                this.setIcon(null);
            }
            return this;
        }
    }
}

