/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.ui;

import VASSAL.build.GameModule;
import VASSAL.chat.ChatServerConnection;
import VASSAL.chat.HttpMessageServer;
import VASSAL.chat.ServerStatus;
import VASSAL.chat.messageboard.MessageBoardControls;
import VASSAL.chat.peer2peer.PeerPoolInfo;
import VASSAL.chat.ui.ServerStatusView;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JToolBar;

public class ShowServerStatusAction
extends AbstractAction {
    private static Window frame;

    public ShowServerStatusAction(ServerStatus serverStatus, URL uRL) {
        if (frame == null) {
            frame = new Window(serverStatus);
        }
        if (uRL == null) {
            this.putValue("Name", "Server Status");
        } else {
            this.putValue("SmallIcon", new ImageIcon(uRL));
        }
        this.putValue("ShortDescription", "Display server connections for all modules");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        frame.refresh();
    }

    private static class Window
    extends JFrame
    implements PropertyChangeListener {
        private ServerStatusView view;
        private MessageBoardControls messageMgr;

        public Window(ServerStatus serverStatus) {
            super("Server Status");
            this.view = new ServerStatusView(serverStatus);
            this.view.addPropertyChangeListener("ServerStatusView.selection", this);
            this.getContentPane().add(this.view);
            this.messageMgr = new MessageBoardControls();
            JToolBar jToolBar = new JToolBar();
            jToolBar.setFloatable(false);
            jToolBar.add(this.messageMgr.getCheckMessagesAction());
            jToolBar.add(this.messageMgr.getPostMessageAction());
            this.getContentPane().add((Component)jToolBar, "North");
            this.pack();
            ((Component)this).setSize(Math.max(this.getSize().width, 400), Math.max(this.getSize().height, 300));
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            ((Component)this).setLocation(dimension.width / 2 - this.getSize().width / 2, dimension.height / 2 - this.getSize().height / 2);
        }

        public void refresh() {
            if (!this.isVisible()) {
                ((Component)this).setVisible(true);
            } else {
                this.toFront();
            }
            this.view.refresh();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            HttpMessageServer httpMessageServer = null;
            String string = null;
            if (propertyChangeEvent.getNewValue() instanceof ServerStatus.ModuleSummary) {
                String string2 = ((ServerStatus.ModuleSummary)propertyChangeEvent.getNewValue()).getModuleName();
                httpMessageServer = new HttpMessageServer(new PeerPoolInfo(this, string2){
                    private final /* synthetic */ String val$moduleName;
                    private final /* synthetic */ Window this$0;
                    {
                        this.this$0 = window;
                        this.val$moduleName = string;
                    }

                    public String getModuleName() {
                        return this.val$moduleName;
                    }

                    public String getUserName() {
                        return ((ChatServerConnection)GameModule.getGameModule().getServer()).getUserInfo().getName();
                    }
                });
            }
            this.messageMgr.setServer(httpMessageServer, string);
        }
    }
}

