/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.ui;

import VASSAL.chat.ChatServerConnection;
import VASSAL.chat.Player;
import VASSAL.chat.SimplePlayer;
import VASSAL.chat.SimpleStatus;
import VASSAL.chat.ui.ChatControlsInitializer;
import VASSAL.chat.ui.ChatServerControls;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;

public class SimpleStatusControlsInitializer
implements ChatControlsInitializer {
    private ChatServerConnection client;
    private JButton lookingBox;
    private JButton awayButton;

    public SimpleStatusControlsInitializer(ChatServerConnection chatServerConnection) {
        this.client = chatServerConnection;
    }

    public void initializeControls(final ChatServerControls chatServerControls) {
        this.lookingBox = new JButton("Looking for game");
        this.lookingBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SimpleStatusControlsInitializer.this.client != null) {
                    Player player = SimpleStatusControlsInitializer.this.client.getUserInfo();
                    SimpleStatus simpleStatus = (SimpleStatus)player.getStatus();
                    simpleStatus = new SimpleStatus(!simpleStatus.isLooking(), simpleStatus.isAway(), simpleStatus.getProfile());
                    SimpleStatusControlsInitializer.this.client.setUserInfo(new SimplePlayer(player.getId(), player.getName(), simpleStatus));
                }
            }
        });
        this.lookingBox.setSize(this.lookingBox.getMinimumSize());
        URL uRL = this.getClass().getResource("/images/playerLooking.gif");
        if (uRL != null) {
            this.lookingBox.setToolTipText(this.lookingBox.getText());
            this.lookingBox.setText("");
            this.lookingBox.setIcon(new ImageIcon(uRL));
        }
        this.awayButton = new JButton("Away from keyboard");
        this.awayButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SimpleStatusControlsInitializer.this.client != null) {
                    Player player = SimpleStatusControlsInitializer.this.client.getUserInfo();
                    SimpleStatus simpleStatus = (SimpleStatus)player.getStatus();
                    simpleStatus = new SimpleStatus(simpleStatus.isLooking(), true, simpleStatus.getProfile());
                    SimpleStatusControlsInitializer.this.client.setUserInfo(new SimplePlayer(player.getId(), player.getName(), simpleStatus));
                    JOptionPane.showMessageDialog(chatServerControls.getRoomTree(), "I'm back", "Away from keyboard", -1);
                    simpleStatus = (SimpleStatus)player.getStatus();
                    simpleStatus = new SimpleStatus(simpleStatus.isLooking(), false, simpleStatus.getProfile());
                    SimpleStatusControlsInitializer.this.client.setUserInfo(new SimplePlayer(player.getId(), player.getName(), simpleStatus));
                }
            }
        });
        uRL = this.getClass().getResource("/images/playerAway.gif");
        if (uRL != null) {
            this.awayButton.setToolTipText(this.awayButton.getText());
            this.awayButton.setText("");
            this.awayButton.setIcon(new ImageIcon(uRL));
        }
        chatServerControls.getToolbar().add(this.lookingBox);
        chatServerControls.getToolbar().add(this.awayButton);
    }

    public void uninitializeControls(ChatServerControls chatServerControls) {
        chatServerControls.getToolbar().remove(this.lookingBox);
        chatServerControls.getToolbar().remove(this.awayButton);
    }
}

