/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.command;

import VASSAL.build.GameModule;
import VASSAL.command.NullCommand;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;

public abstract class Command {
    private LinkedList seq = new LinkedList();
    private Command undo;

    public Command[] getSubCommands() {
        Command[] commandArray = new Command[this.seq.size()];
        return this.seq.toArray(commandArray);
    }

    public void execute() {
        Object object;
        try {
            this.executeCommand();
        }
        catch (Exception exception) {
            object = this.seq;
            this.stripSubCommands();
            this.reportException(this, exception);
            this.seq = object;
        }
        Iterator iterator = this.seq.iterator();
        while (iterator.hasNext()) {
            object = (Command)iterator.next();
            try {
                ((Command)object).execute();
            }
            catch (Exception exception) {
                this.reportException((Command)object, exception);
            }
        }
    }

    private void reportException(Command command, Exception exception) {
        String string = GameModule.getGameModule() == null ? command.toString() : GameModule.getGameModule().encode(command);
        System.err.println("Unable to execute " + string);
        exception.printStackTrace();
    }

    protected abstract void executeCommand();

    protected abstract Command myUndoCommand();

    public void stripSubCommands() {
        this.seq = new LinkedList();
    }

    public boolean isNull() {
        return false;
    }

    public boolean isLoggable() {
        return !this.isNull();
    }

    protected boolean hasNullSubcommands() {
        return this.isAtomic();
    }

    protected boolean isAtomic() {
        Iterator iterator = this.seq.iterator();
        while (iterator.hasNext()) {
            if (((Command)iterator.next()).isNull()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        String string = this.getClass().getName();
        string = string.substring(string.lastIndexOf(".") + 1);
        String string2 = this.getDetails();
        if (string2 != null) {
            string = string + "[" + string2 + "]";
        }
        Iterator iterator = this.seq.iterator();
        while (iterator.hasNext()) {
            string = string + "+" + iterator.next().toString();
        }
        return string;
    }

    public String getDetails() {
        return null;
    }

    public Command append(Command command) {
        Command command2 = this;
        if (command != null && !command.isNull()) {
            if (this.isNull()) {
                command2 = command;
            }
            this.seq.add(command);
        }
        return command2;
    }

    public Command getUndoCommand() {
        if (this.undo == null) {
            this.undo = new NullCommand();
            ListIterator listIterator = this.seq.listIterator(this.seq.size());
            while (listIterator.hasPrevious()) {
                this.undo = this.undo.append(((Command)listIterator.previous()).getUndoCommand());
            }
            this.undo = this.undo.append(this.myUndoCommand());
        }
        return this.undo;
    }
}

