/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.command;

import VASSAL.build.GameModule;
import VASSAL.build.module.Map;
import VASSAL.build.module.map.HighlightLastMoved;
import VASSAL.command.AddPiece;
import VASSAL.command.ChangePiece;
import VASSAL.command.Command;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyBuffer;
import VASSAL.counters.Stack;
import java.awt.Rectangle;

public class RemovePiece
extends Command {
    private Command undo = null;
    private GamePiece target;
    private String id;

    public RemovePiece(GamePiece gamePiece) {
        this.target = gamePiece;
    }

    public RemovePiece(String string) {
        this.id = string;
    }

    protected void executeCommand() {
        if (this.target == null) {
            this.target = GameModule.getGameModule().getGameState().getPieceForId(this.id);
        }
        if (this.target != null) {
            this.undo = new AddPiece(this.target, this.target.getState());
            Rectangle rectangle = null;
            Map map = this.target.getMap();
            Stack stack = this.target.getParent();
            map.getIdentifier();
            HighlightLastMoved.setLastMoved(this.target);
            if (map != null) {
                rectangle = stack == null ? map.boundingBoxOf(this.target) : map.boundingBoxOf(stack);
                this.target.getMap().removePiece(this.target);
                this.target.setMap(null);
            }
            if (stack != null) {
                String string = stack.getState();
                stack.remove(this.target);
                this.undo = this.undo.append(new ChangePiece(stack.getId(), stack.getState(), string));
                this.target.setParent(null);
            }
            if (map != null) {
                map.repaint(rectangle);
            }
            GameModule.getGameModule().getGameState().removePiece(this.target.getId());
            KeyBuffer.getBuffer().remove(this.target);
        }
    }

    protected Command myUndoCommand() {
        if (this.undo == null && this.target != null) {
            this.undo = new AddPiece(this.target);
        }
        return this.undo;
    }

    public GamePiece getTarget() {
        return this.target;
    }

    public String getId() {
        return this.target == null ? this.id : this.target.getId();
    }
}

