/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.AutoConfigurable;
import VASSAL.build.GameModule;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.DoubleConfigurer;
import VASSAL.configure.FileConfigurer;
import VASSAL.configure.HotKeyConfigurer;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.ImageConfigurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.configure.StringEnum;
import VASSAL.configure.StringEnumConfigurer;
import VASSAL.configure.VisibilityCondition;
import java.awt.Component;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public class AutoConfigurer
extends Configurer
implements PropertyChangeListener {
    private JPanel p;
    private AutoConfigurable target;
    private Vector configurers = new Vector();
    private Hashtable conditions;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$awt$Image;
    static /* synthetic */ Class class$java$awt$Color;
    static /* synthetic */ Class class$javax$swing$KeyStroke;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$javax$swing$Icon;
    static /* synthetic */ Class class$VASSAL$configure$StringEnum;
    static /* synthetic */ Class class$VASSAL$configure$ConfigurerFactory;

    public AutoConfigurer(AutoConfigurable autoConfigurable) {
        super(null, autoConfigurable.getConfigureName());
        this.target = autoConfigurable;
        this.setValue(this.target);
        this.target.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("name".equals(propertyChangeEvent.getPropertyName())) {
                    AutoConfigurer.this.setName((String)propertyChangeEvent.getNewValue());
                }
            }
        });
        this.p = new JPanel();
        this.p.setLayout(new BoxLayout(this.p, 1));
        String[] stringArray = autoConfigurable.getAttributeNames();
        String[] stringArray2 = autoConfigurable.getAttributeDescriptions();
        Class[] classArray = autoConfigurable.getAttributeTypes();
        int n = Math.min(stringArray.length, Math.min(stringArray2.length, classArray.length));
        for (int i = 0; i < n; ++i) {
            if (classArray[i] == null) continue;
            Configurer configurer = AutoConfigurer.createConfigurer(classArray[i], stringArray[i], stringArray2[i], this.target);
            if (configurer != null) {
                configurer.addPropertyChangeListener(this);
                configurer.setValue(this.target.getAttributeValueString(stringArray[i]));
                Box box = Box.createHorizontalBox();
                box.add(configurer.getControls());
                box.add(Box.createHorizontalGlue());
                this.p.add(box);
                this.configurers.addElement(configurer);
            }
            this.setVisibility(stringArray[i], autoConfigurable.getAttributeVisibility(stringArray[i]));
        }
    }

    public static Configurer createConfigurer(Class clazz, String string, String string2, AutoConfigurable autoConfigurable) {
        Configurer configurer;
        if ((class$java$lang$String == null ? (class$java$lang$String = AutoConfigurer.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(clazz)) {
            configurer = new StringConfigurer(string, string2);
        } else if ((class$java$lang$Integer == null ? (class$java$lang$Integer = AutoConfigurer.class$("java.lang.Integer")) : class$java$lang$Integer).isAssignableFrom(clazz)) {
            configurer = new IntConfigurer(string, string2);
        } else if ((class$java$lang$Double == null ? (class$java$lang$Double = AutoConfigurer.class$("java.lang.Double")) : class$java$lang$Double).isAssignableFrom(clazz)) {
            configurer = new DoubleConfigurer(string, string2);
        } else if ((class$java$lang$Boolean == null ? (class$java$lang$Boolean = AutoConfigurer.class$("java.lang.Boolean")) : class$java$lang$Boolean).isAssignableFrom(clazz)) {
            configurer = new BooleanConfigurer(string, string2);
        } else if ((class$java$awt$Image == null ? (class$java$awt$Image = AutoConfigurer.class$("java.awt.Image")) : class$java$awt$Image).isAssignableFrom(clazz)) {
            configurer = new ImageConfigurer(string, string2, GameModule.getGameModule().getArchiveWriter());
        } else if ((class$java$awt$Color == null ? (class$java$awt$Color = AutoConfigurer.class$("java.awt.Color")) : class$java$awt$Color).isAssignableFrom(clazz)) {
            configurer = new ColorConfigurer(string, string2);
        } else if ((class$javax$swing$KeyStroke == null ? (class$javax$swing$KeyStroke = AutoConfigurer.class$("javax.swing.KeyStroke")) : class$javax$swing$KeyStroke).isAssignableFrom(clazz)) {
            configurer = new HotKeyConfigurer(string, string2);
        } else if ((class$java$io$File == null ? (class$java$io$File = AutoConfigurer.class$("java.io.File")) : class$java$io$File).isAssignableFrom(clazz)) {
            configurer = new FileConfigurer(string, string2, GameModule.getGameModule().getArchiveWriter());
        } else if ((array$Ljava$lang$String == null ? (array$Ljava$lang$String = AutoConfigurer.class$("[Ljava.lang.String;")) : array$Ljava$lang$String).isAssignableFrom(clazz)) {
            configurer = new StringArrayConfigurer(string, string2);
        } else if ((class$javax$swing$Icon == null ? (class$javax$swing$Icon = AutoConfigurer.class$("javax.swing.Icon")) : class$javax$swing$Icon).isAssignableFrom(clazz)) {
            configurer = new IconConfigurer(string, string2, null);
        } else if ((class$VASSAL$configure$StringEnum == null ? (class$VASSAL$configure$StringEnum = AutoConfigurer.class$("VASSAL.configure.StringEnum")) : class$VASSAL$configure$StringEnum).isAssignableFrom(clazz)) {
            try {
                String[] stringArray = ((StringEnum)clazz.newInstance()).getValidValues(autoConfigurable);
                configurer = new StringEnumConfigurer(string, string2, stringArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                configurer = new StringConfigurer(string, string2);
            }
        } else if ((class$VASSAL$configure$ConfigurerFactory == null ? (class$VASSAL$configure$ConfigurerFactory = AutoConfigurer.class$("VASSAL.configure.ConfigurerFactory")) : class$VASSAL$configure$ConfigurerFactory).isAssignableFrom(clazz)) {
            try {
                ConfigurerFactory configurerFactory = (ConfigurerFactory)clazz.newInstance();
                configurer = configurerFactory.getConfigurer(autoConfigurable, string, string2);
            }
            catch (InstantiationException instantiationException) {
                throw new IllegalArgumentException("Invalid class " + clazz.getName());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalArgumentException("Invalid class " + clazz.getName());
            }
        } else {
            throw new IllegalArgumentException("Invalid class " + clazz.getName());
        }
        return configurer;
    }

    public void reset() {
        String[] stringArray = this.target.getAttributeNames();
        for (int i = 0; i < stringArray.length; ++i) {
            Configurer configurer = this.getConfigurer(stringArray[i]);
            if (configurer == null) continue;
            configurer.setValue(this.target.getAttributeValueString(stringArray[i]));
        }
    }

    public String getValueString() {
        return this.target.getConfigureName();
    }

    public void setValue(String string) {
        throw new RuntimeException("Can't set Configurable from String");
    }

    public Component getControls() {
        return this.p;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.target.setAttribute(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getNewValue());
        this.checkVisibility();
    }

    public void setVisibility(String string, VisibilityCondition visibilityCondition) {
        if (visibilityCondition != null) {
            if (this.conditions == null) {
                this.conditions = new Hashtable();
            }
            this.conditions.put(string, visibilityCondition);
            this.checkVisibility();
        }
    }

    protected void checkVisibility() {
        boolean bl = false;
        if (this.conditions != null) {
            Enumeration enumeration = this.configurers.elements();
            while (enumeration.hasMoreElements()) {
                Configurer configurer = (Configurer)enumeration.nextElement();
                VisibilityCondition visibilityCondition = (VisibilityCondition)this.conditions.get(configurer.getKey());
                if (visibilityCondition == null || configurer.getControls().isVisible() == visibilityCondition.shouldBeVisible()) continue;
                bl = true;
                configurer.getControls().setVisible(visibilityCondition.shouldBeVisible());
            }
            if (bl && this.p.getTopLevelAncestor() instanceof Window) {
                ((Window)this.p.getTopLevelAncestor()).pack();
            }
        }
    }

    public Configurer getConfigurer(String string) {
        Enumeration enumeration = this.configurers.elements();
        while (enumeration.hasMoreElements()) {
            Configurer configurer = (Configurer)enumeration.nextElement();
            if (!string.equals(configurer.getKey())) continue;
            return configurer;
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

