/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.configure.Configurer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ColorConfigurer
extends Configurer {
    private static Font FONT = new Font("Dialog", 0, 10);
    private JPanel p;
    private Panel cp;

    public ColorConfigurer(String string, String string2) {
        this(string, string2, Color.black);
    }

    public ColorConfigurer(String string, String string2, Color color) {
        super(string, string2, color);
    }

    public String getValueString() {
        return this.value == null ? "" : ColorConfigurer.colorToString(this.colorValue());
    }

    public void setValue(Object object) {
        super.setValue(object);
        if (this.cp != null) {
            this.cp.repaint();
        }
    }

    public void setValue(String string) {
        this.setValue(ColorConfigurer.stringToColor(string));
    }

    public Component getControls() {
        if (this.p == null) {
            this.p = new JPanel();
            this.p.setLayout(new BoxLayout(this.p, 0));
            this.p.add(new JLabel(this.getName()));
            this.cp = new Panel();
            this.cp.setMaximumSize(new Dimension(40, 40));
            this.cp.setMinimumSize(new Dimension(40, 40));
            this.cp.setSize(new Dimension(40, 40));
            this.p.add(this.cp);
            JButton jButton = new JButton("Select");
            this.p.add(jButton);
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ColorConfigurer.this.setValue(JColorChooser.showDialog(null, ColorConfigurer.this.getName(), ColorConfigurer.this.colorValue()));
                }
            });
        }
        return this.p;
    }

    private Color colorValue() {
        return (Color)this.value;
    }

    public static String colorToString(Color color) {
        return color == null ? null : color.getRed() + "," + color.getGreen() + "," + color.getBlue();
    }

    public static Color stringToColor(String string) {
        if (string == null || "null".equals(string)) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        try {
            return new Color(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
        }
        catch (Exception exception) {
            return null;
        }
    }

    private class Panel
    extends JPanel {
        private Panel() {
        }

        public void paint(Graphics graphics) {
            if (ColorConfigurer.this.colorValue() != null) {
                graphics.setColor(ColorConfigurer.this.colorValue());
                graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
            } else {
                graphics.clearRect(0, 0, this.getSize().width, this.getSize().height);
                graphics.setFont(FONT);
                graphics.drawString(" nil ", this.getSize().width / 2 - graphics.getFontMetrics(graphics.getFont()).stringWidth(" nil ") / 2, this.getSize().height / 2);
            }
        }
    }
}

