/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.Buildable;
import VASSAL.build.Builder;
import VASSAL.build.Configurable;
import VASSAL.build.GameModule;
import VASSAL.build.IllegalBuildException;
import VASSAL.build.module.documentation.HelpWindow;
import VASSAL.configure.EditContainedPiecesAction;
import VASSAL.configure.EditPropertiesAction;
import VASSAL.configure.PropertiesWindow;
import VASSAL.configure.ShowHelpAction;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ConfigureTree
extends JTree
implements PropertyChangeListener,
MouseListener,
MouseMotionListener {
    private Hashtable nodes = new Hashtable();
    protected DefaultMutableTreeNode copyData;
    protected DefaultMutableTreeNode cutData;
    protected HelpWindow helpWindow;
    public static Font POPUP_MENU_FONT = new Font("Dialog", 0, 11);
    static /* synthetic */ Class class$java$awt$Frame;
    static /* synthetic */ Class class$VASSAL$build$widget$PieceSlot;

    public ConfigureTree(Configurable configurable, HelpWindow helpWindow) {
        this.toggleClickCount = 3;
        this.helpWindow = helpWindow;
        this.setShowsRootHandles(true);
        this.setModel(new DefaultTreeModel(this.buildTreeNode(configurable)));
        this.setCellRenderer(this.buildRenderer());
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    protected Renderer buildRenderer() {
        return new Renderer();
    }

    protected Configurable getTarget(int n, int n2) {
        TreePath treePath = this.getPathForLocation(n, n2);
        Configurable configurable = null;
        if (treePath != null) {
            configurable = (Configurable)((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
        }
        return configurable;
    }

    protected DefaultMutableTreeNode buildTreeNode(Configurable configurable) {
        configurable.addPropertyChangeListener(this);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(configurable);
        Configurable[] configurableArray = configurable.getConfigureComponents();
        for (int i = 0; i < configurableArray.length; ++i) {
            defaultMutableTreeNode.add(this.buildTreeNode(configurableArray[i]));
        }
        this.nodes.put(configurable, defaultMutableTreeNode);
        return defaultMutableTreeNode;
    }

    protected void addAction(JPopupMenu jPopupMenu, Action action) {
        if (action != null) {
            jPopupMenu.add(action).setFont(POPUP_MENU_FONT);
        }
    }

    private void addActionGroup(JPopupMenu jPopupMenu, Vector vector) {
        boolean bl = true;
        for (int i = 0; i < vector.size(); ++i) {
            if (vector.elementAt(i) == null) continue;
            jPopupMenu.add((Action)vector.elementAt(i)).setFont(POPUP_MENU_FONT);
            bl = false;
        }
        if (!bl) {
            jPopupMenu.addSeparator();
        }
        vector.removeAllElements();
    }

    protected JPopupMenu buildPopupMenu(Configurable configurable) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        Vector<Action> vector = new Vector<Action>();
        vector.addElement(this.buildEditAction(configurable));
        vector.addElement(this.buildEditPiecesAction(configurable));
        this.addActionGroup(jPopupMenu, vector);
        vector.addElement(this.buildHelpAction(configurable));
        this.addActionGroup(jPopupMenu, vector);
        vector.addElement(this.buildDeleteAction(configurable));
        vector.addElement(this.buildCutAction(configurable));
        vector.addElement(this.buildCopyAction(configurable));
        vector.addElement(this.buildPasteAction(configurable));
        vector.addElement(this.buildMoveAction(configurable));
        this.addActionGroup(jPopupMenu, vector);
        Enumeration enumeration = this.buildAddActions(configurable);
        while (enumeration.hasMoreElements()) {
            this.addAction(jPopupMenu, (Action)enumeration.nextElement());
        }
        this.addAction(jPopupMenu, this.buildImportAction(configurable));
        return jPopupMenu;
    }

    protected Action buildMoveAction(final Configurable configurable) {
        AbstractAction abstractAction = null;
        if (this.getTreeNode(configurable).getParent() != null) {
            abstractAction = new AbstractAction("Move"){

                public void actionPerformed(ActionEvent actionEvent) {
                    Object object;
                    JDialog jDialog = new JDialog((Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame == null ? (class$java$awt$Frame = ConfigureTree.class$("java.awt.Frame")) : class$java$awt$Frame, ConfigureTree.this), true);
                    jDialog.setTitle(configurable.getConfigureName() == null ? "Move" : "Move " + configurable.getConfigureName());
                    jDialog.getContentPane().setLayout(new BoxLayout(jDialog.getContentPane(), 1));
                    Box box = Box.createHorizontalBox();
                    box.add(new JLabel("Move to position"));
                    box.add(Box.createHorizontalStrut(10));
                    JComboBox<String> jComboBox = new JComboBox<String>();
                    TreeNode treeNode = ConfigureTree.this.getTreeNode(configurable).getParent();
                    for (int i = 0; i < treeNode.getChildCount(); ++i) {
                        Configurable configurable2 = (Configurable)((DefaultMutableTreeNode)treeNode.getChildAt(i)).getUserObject();
                        object = (configurable2.getConfigureName() != null ? configurable2.getConfigureName() : "") + " [" + ConfigureTree.getConfigureName(configurable2.getClass()) + "]";
                        jComboBox.addItem(i + 1 + ":  " + (String)object);
                    }
                    DefaultMutableTreeNode defaultMutableTreeNode = ConfigureTree.this.getTreeNode(configurable);
                    int n = defaultMutableTreeNode.getParent().getIndex(defaultMutableTreeNode);
                    jComboBox.setSelectedIndex(n);
                    box.add(jComboBox);
                    object = new JButton("Ok");
                    ((AbstractButton)object).addActionListener(new ActionListener(this, jComboBox, n, defaultMutableTreeNode, jDialog){
                        private final /* synthetic */ JComboBox val$select;
                        private final /* synthetic */ int val$currentIndex;
                        private final /* synthetic */ DefaultMutableTreeNode val$targetNode;
                        private final /* synthetic */ JDialog val$d;
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                            this.val$select = jComboBox;
                            this.val$currentIndex = n;
                            this.val$targetNode = defaultMutableTreeNode;
                            this.val$d = jDialog;
                        }

                        public void actionPerformed(ActionEvent actionEvent) {
                            int n = this.val$select.getSelectedIndex();
                            if (this.val$currentIndex != n) {
                                Configurable configurable = 1.access$000(this.this$1).getParent(this.val$targetNode);
                                if (1.access$000(this.this$1).remove(configurable, 1.access$100(this.this$1))) {
                                    1.access$000(this.this$1).insert(configurable, 1.access$100(this.this$1), n);
                                }
                            }
                            this.val$d.dispose();
                        }
                    });
                    jDialog.getContentPane().add(box);
                    jDialog.getContentPane().add((Component)object);
                    jDialog.pack();
                    jDialog.setLocationRelativeTo(jDialog.getParent());
                    ((Component)jDialog).setVisible(true);
                }

                static /* synthetic */ ConfigureTree access$000(1 var0) {
                    return var0.ConfigureTree.this;
                }

                static /* synthetic */ Configurable access$100(1 var0) {
                    return var0.configurable;
                }
            };
        }
        return abstractAction;
    }

    protected Action buildCutAction(final Configurable configurable) {
        AbstractAction abstractAction = null;
        if (this.getTreeNode(configurable).getParent() != null) {
            abstractAction = new AbstractAction("Cut"){

                public void actionPerformed(ActionEvent actionEvent) {
                    ConfigureTree.this.cutData = ConfigureTree.this.getTreeNode(configurable);
                    ConfigureTree.this.copyData = null;
                }
            };
        }
        return abstractAction;
    }

    protected Action buildCopyAction(final Configurable configurable) {
        AbstractAction abstractAction = null;
        if (this.getTreeNode(configurable).getParent() != null) {
            abstractAction = new AbstractAction("Copy"){

                public void actionPerformed(ActionEvent actionEvent) {
                    ConfigureTree.this.copyData = ConfigureTree.this.getTreeNode(configurable);
                    ConfigureTree.this.cutData = null;
                }
            };
        }
        return abstractAction;
    }

    protected Action buildPasteAction(final Configurable configurable) {
        AbstractAction abstractAction = new AbstractAction("Paste"){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ConfigureTree.this.cutData != null) {
                    DefaultMutableTreeNode defaultMutableTreeNode = ConfigureTree.this.getTreeNode(configurable);
                    if (ConfigureTree.this.remove(ConfigureTree.this.getParent(ConfigureTree.this.cutData), (Configurable)ConfigureTree.this.cutData.getUserObject())) {
                        ConfigureTree.this.insert(configurable, (Configurable)ConfigureTree.this.cutData.getUserObject(), defaultMutableTreeNode.getChildCount());
                    }
                } else if (ConfigureTree.this.copyData != null) {
                    try {
                        Configurable configurable3 = (Configurable)ConfigureTree.this.copyData.getUserObject();
                        Configurable configurable2 = (Configurable)configurable3.getClass().newInstance();
                        configurable2.build(configurable3.getBuildElement(Builder.createNewDocument()));
                        ConfigureTree.this.insert(configurable, configurable2, ConfigureTree.this.getTreeNode(configurable).getChildCount());
                    }
                    catch (InstantiationException instantiationException) {
                        instantiationException.printStackTrace();
                        JOptionPane.showMessageDialog(ConfigureTree.this.getTopLevelAncestor(), "Cannot copy " + ConfigureTree.getConfigureName(configurable), "Copy failed", 0);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        illegalAccessException.printStackTrace();
                        JOptionPane.showMessageDialog(ConfigureTree.this.getTopLevelAncestor(), "Cannot copy " + ConfigureTree.getConfigureName(configurable), "Copy failed", 0);
                    }
                }
                ConfigureTree.this.cutData = null;
            }
        };
        abstractAction.setEnabled(this.cutData != null && this.isValidParent(configurable, (Configurable)this.cutData.getUserObject()) || this.copyData != null && this.isValidParent(configurable, (Configurable)this.copyData.getUserObject()));
        return abstractAction;
    }

    protected Action buildImportAction(final Configurable configurable) {
        AbstractAction abstractAction = new AbstractAction("Add Imported Class"){

            public void actionPerformed(ActionEvent actionEvent) {
                Configurable configurable3 = ConfigureTree.this.importConfigurable();
                if (configurable3 != null) {
                    try {
                        configurable3.build(null);
                        Configurable configurable2 = configurable;
                        if (configurable3.getConfigurer() != null) {
                            PropertiesWindow propertiesWindow = new PropertiesWindow(this, (Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame == null ? (class$java$awt$Frame = ConfigureTree.class$("java.awt.Frame")) : class$java$awt$Frame, ConfigureTree.this), false, configurable3, ConfigureTree.this.helpWindow, configurable2, configurable3){
                                private final /* synthetic */ Configurable val$c;
                                private final /* synthetic */ Configurable val$child;
                                private final /* synthetic */ 6 this$1;
                                {
                                    this.this$1 = var1_1;
                                    this.val$c = configurable2;
                                    this.val$child = configurable3;
                                }

                                public void save() {
                                    super.save();
                                    6.access$200(this.this$1).insert(this.val$c, this.val$child, 6.access$200(this.this$1).getTreeNode(this.val$c).getChildCount());
                                }

                                public void cancel() {
                                    this.dispose();
                                }
                            };
                            ((Component)propertiesWindow).setVisible(true);
                        } else {
                            ConfigureTree.this.insert(configurable2, configurable3, ConfigureTree.this.getTreeNode(configurable2).getChildCount());
                        }
                    }
                    catch (Exception exception) {
                        JOptionPane.showMessageDialog(ConfigureTree.this.getTopLevelAncestor(), "Error adding " + ConfigureTree.getConfigureName(configurable3) + " to " + ConfigureTree.getConfigureName(configurable) + "\n" + exception.getMessage(), "Illegal configuration", 0);
                    }
                }
            }

            static /* synthetic */ ConfigureTree access$200(6 var0) {
                return var0.ConfigureTree.this;
            }
        };
        return abstractAction;
    }

    protected Enumeration buildAddActions(Configurable configurable) {
        Vector<Action> vector = new Vector<Action>();
        Class[] classArray = configurable.getAllowableConfigureComponents();
        for (int i = 0; i < classArray.length; ++i) {
            Class clazz = classArray[i];
            Action action = this.buildAddAction(configurable, clazz);
            vector.addElement(action);
        }
        return vector.elements();
    }

    protected Action buildAddAction(final Configurable configurable, final Class clazz) {
        AbstractAction abstractAction = new AbstractAction("Add " + ConfigureTree.getConfigureName(clazz)){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Configurable configurable3 = (Configurable)clazz.newInstance();
                    configurable3.build(null);
                    Configurable configurable2 = configurable;
                    if (configurable3.getConfigurer() != null) {
                        if (ConfigureTree.this.insert(configurable, configurable3, ConfigureTree.this.getTreeNode(configurable).getChildCount())) {
                            PropertiesWindow propertiesWindow = new PropertiesWindow(this, (Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame == null ? (class$java$awt$Frame = ConfigureTree.class$("java.awt.Frame")) : class$java$awt$Frame, ConfigureTree.this), false, configurable3, ConfigureTree.this.helpWindow, configurable2, configurable3){
                                private final /* synthetic */ Configurable val$c;
                                private final /* synthetic */ Configurable val$child;
                                private final /* synthetic */ 8 this$1;
                                {
                                    this.this$1 = var1_1;
                                    this.val$c = configurable2;
                                    this.val$child = configurable3;
                                }

                                public void save() {
                                    super.save();
                                }

                                public void cancel() {
                                    8.access$300(this.this$1).remove(this.val$c, this.val$child);
                                    this.dispose();
                                }
                            };
                            ((Component)propertiesWindow).setVisible(true);
                        }
                    } else {
                        ConfigureTree.this.insert(configurable2, configurable3, ConfigureTree.this.getTreeNode(configurable2).getChildCount());
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }

            static /* synthetic */ ConfigureTree access$300(8 var0) {
                return var0.ConfigureTree.this;
            }
        };
        return abstractAction;
    }

    protected Action buildHelpAction(Configurable configurable) {
        ShowHelpAction showHelpAction = new ShowHelpAction(this.helpWindow, configurable.getHelpFile(), null);
        return showHelpAction;
    }

    protected Action buildCloneAction(final Configurable configurable) {
        final DefaultMutableTreeNode defaultMutableTreeNode = this.getTreeNode(configurable);
        if (defaultMutableTreeNode.getParent() != null) {
            return new AbstractAction("Clone"){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        Configurable configurable2 = (Configurable)configurable.getClass().newInstance();
                        configurable2.build(configurable.getBuildElement(Builder.createNewDocument()));
                        ConfigureTree.this.insert(ConfigureTree.this.getParent(defaultMutableTreeNode), configurable2, defaultMutableTreeNode.getParent().getIndex(defaultMutableTreeNode) + 1);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        JOptionPane.showMessageDialog(ConfigureTree.this.getTopLevelAncestor(), "Cannot clone " + ConfigureTree.getConfigureName(configurable), "Clone failed", 0);
                    }
                }
            };
        }
        return null;
    }

    protected Configurable getParent(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
        return defaultMutableTreeNode2 == null ? null : (Configurable)defaultMutableTreeNode2.getUserObject();
    }

    protected Action buildDeleteAction(final Configurable configurable) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getTreeNode(configurable);
        final Configurable configurable2 = this.getParent(defaultMutableTreeNode);
        if (defaultMutableTreeNode.getParent() != null) {
            return new AbstractAction("Delete"){

                public void actionPerformed(ActionEvent actionEvent) {
                    ConfigureTree.this.remove(configurable2, configurable);
                }
            };
        }
        return null;
    }

    protected Action buildEditPiecesAction(Configurable configurable) {
        if (this.canContainGamePiece(configurable)) {
            return new EditContainedPiecesAction(configurable, this.helpWindow);
        }
        return null;
    }

    protected Action buildEditAction(Configurable configurable) {
        return new EditPropertiesAction(configurable, this.helpWindow, (Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame == null ? (class$java$awt$Frame = ConfigureTree.class$("java.awt.Frame")) : class$java$awt$Frame, this));
    }

    public boolean canContainGamePiece(Configurable configurable) {
        boolean bl = false;
        Class[] classArray = configurable.getAllowableConfigureComponents();
        for (int i = 0; i < classArray.length; ++i) {
            if (!(class$VASSAL$build$widget$PieceSlot == null ? ConfigureTree.class$("VASSAL.build.widget.PieceSlot") : class$VASSAL$build$widget$PieceSlot).isAssignableFrom(classArray[i])) continue;
            bl = true;
            break;
        }
        return bl;
    }

    protected boolean remove(Configurable configurable, Configurable configurable2) {
        try {
            configurable2.removeFrom(configurable);
            configurable.remove(configurable2);
            ((DefaultTreeModel)this.getModel()).removeNodeFromParent(this.getTreeNode(configurable2));
            return true;
        }
        catch (IllegalBuildException illegalBuildException) {
            JOptionPane.showMessageDialog(this.getTopLevelAncestor(), "Cannot delete " + ConfigureTree.getConfigureName(configurable2) + " from " + ConfigureTree.getConfigureName(configurable) + "\n" + illegalBuildException.getMessage(), "Illegal configuration", 0);
            return false;
        }
    }

    protected boolean insert(Configurable configurable, Configurable configurable2, int n) {
        Object object;
        DefaultMutableTreeNode defaultMutableTreeNode = this.buildTreeNode(configurable2);
        DefaultMutableTreeNode defaultMutableTreeNode2 = this.getTreeNode(configurable);
        Configurable[] configurableArray = configurable.getConfigureComponents();
        boolean bl = true;
        Vector<Configurable> vector = new Vector<Configurable>();
        for (int i = n; i < configurableArray.length; ++i) {
            try {
                configurableArray[i].removeFrom(configurable);
                configurable.remove(configurableArray[i]);
            }
            catch (IllegalBuildException illegalBuildException) {
                JOptionPane.showMessageDialog(this.getTopLevelAncestor(), "Can't insert " + ConfigureTree.getConfigureName(configurable2) + " before " + ConfigureTree.getConfigureName(configurableArray[i]), "Illegal configuration", 0);
                for (int j = n; j < i; ++j) {
                    configurable.add(configurableArray[j]);
                    configurableArray[j].addTo(configurable);
                }
                return false;
            }
            vector.addElement(configurableArray[i]);
        }
        try {
            configurable2.addTo(configurable);
            configurable.add(configurable2);
            defaultMutableTreeNode2.insert(defaultMutableTreeNode, n);
            object = new int[]{n};
            ((DefaultTreeModel)this.getModel()).nodesWereInserted(defaultMutableTreeNode2, (int[])object);
        }
        catch (IllegalBuildException illegalBuildException) {
            JOptionPane.showMessageDialog(this.getTopLevelAncestor(), "Can't add " + ConfigureTree.getConfigureName(configurable2) + "\n" + illegalBuildException.getMessage(), "Illegal configuration", 0);
            bl = false;
        }
        while (vector.size() > 0) {
            object = (Configurable)vector.firstElement();
            configurable.add((Buildable)object);
            object.addTo(configurable);
            vector.removeElementAt(0);
        }
        return bl;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getTreeNode((Configurable)propertyChangeEvent.getSource());
        ((DefaultTreeModel)this.getModel()).nodeChanged(defaultMutableTreeNode);
    }

    public static String getConfigureName(Class clazz) {
        try {
            return (String)clazz.getMethod("getConfigureTypeName", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            return clazz.getName().substring(clazz.getName().lastIndexOf(".") + 1);
        }
    }

    public static String getConfigureName(Configurable configurable) {
        if (configurable.getConfigureName() != null && configurable.getConfigureName().length() > 0) {
            return configurable.getConfigureName();
        }
        return ConfigureTree.getConfigureName(configurable.getClass());
    }

    protected Configurable importConfigurable() {
        String string = JOptionPane.showInputDialog(this.getTopLevelAncestor(), (Object)"Enter fully-qualified name of Java class to import");
        Configurable configurable = null;
        if (string != null) {
            configurable = null;
            try {
                Class<?> clazz = GameModule.getGameModule().getDataArchive().loadClass(string);
                Object obj = clazz.newInstance();
                if (obj instanceof Configurable) {
                    configurable = (Configurable)obj;
                } else {
                    JOptionPane.showMessageDialog(this.getTopLevelAncestor(), "Class must implement the Configurable interface.", "Class error", 0);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                JOptionPane.showMessageDialog(this.getTopLevelAncestor(), "Couldn't find class.\nClass file must exist in module zipfile with correct package structure.", "Class not found", 0);
            }
            catch (InstantiationException instantiationException) {
                JOptionPane.showMessageDialog(this.getTopLevelAncestor(), "Couldn't instantiate class.\nClass must have a no-argument constructor.", "Class not initialized", 0);
            }
            catch (IllegalAccessException illegalAccessException) {
                JOptionPane.showMessageDialog(this.getTopLevelAncestor(), "Error accessing class", "Access error", 0);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                JOptionPane.showMessageDialog(this.getTopLevelAncestor(), "Couldn't instantiate class.\nClass must have a no-argument constructor.", "Class not initialized", 0);
            }
        }
        return configurable;
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        Configurable configurable = this.getTarget(mouseEvent.getX(), mouseEvent.getY());
        if (configurable != null) {
            if (mouseEvent.getClickCount() == 2 && !mouseEvent.isMetaDown()) {
                Action action;
                if (configurable.getConfigurer() != null && (action = this.buildEditAction(configurable)) != null) {
                    action.actionPerformed(new ActionEvent(mouseEvent.getSource(), 1001, "Edit"));
                }
            } else if (mouseEvent.isMetaDown()) {
                JPopupMenu jPopupMenu = this.buildPopupMenu(configurable);
                jPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
                jPopupMenu.addPopupMenuListener(new PopupMenuListener(){

                    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                        ConfigureTree.this.repaint();
                    }

                    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                        ConfigureTree.this.repaint();
                    }

                    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                    }
                });
            }
        }
    }

    public DefaultMutableTreeNode getTreeNode(Configurable configurable) {
        return (DefaultMutableTreeNode)this.nodes.get(configurable);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    protected boolean isValidParent(Configurable configurable, Configurable configurable2) {
        if (configurable != null && configurable2 != null) {
            Class[] classArray = configurable.getAllowableConfigureComponents();
            for (int i = 0; i < classArray.length; ++i) {
                if (classArray[i] != configurable2.getClass()) continue;
                return true;
            }
        }
        return false;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class Renderer
    extends DefaultTreeCellRenderer {
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Configurable configurable = null;
            if (object instanceof DefaultMutableTreeNode) {
                configurable = (Configurable)((DefaultMutableTreeNode)object).getUserObject();
                bl3 = configurable.getAllowableConfigureComponents().length == 0;
            }
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (configurable != null) {
                this.setText((configurable.getConfigureName() != null ? configurable.getConfigureName() : "") + " [" + ConfigureTree.getConfigureName(configurable.getClass()) + "]");
            }
            return this;
        }
    }
}

