/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.GameModule;
import VASSAL.build.module.ModuleExtension;
import VASSAL.configure.ExtensionTree;
import VASSAL.configure.ModuleEditWindow;
import VASSAL.configure.ValidationReport;
import VASSAL.configure.ValidationReportDialog;
import VASSAL.tools.ScrollPane;
import java.awt.Component;
import java.io.IOException;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class ExtensionEditWindow
extends ModuleEditWindow {
    private ModuleExtension extension;

    public ExtensionEditWindow(ModuleExtension moduleExtension) {
        this.extension = moduleExtension;
        this.initExtensionComponents();
    }

    protected void initComponents(Component component) {
    }

    private void initExtensionComponents() {
        super.initComponents(new ScrollPane(new ExtensionTree(GameModule.getGameModule(), this.helpWindow, this.extension)));
        this.toolbar.addSeparator();
        this.toolbar.add(this.extension.getEditAction(new JDialog(this)));
    }

    protected void refreshTitle() {
        if (this.extension != null) {
            this.setTitle("Edit " + this.extension.getName());
        } else {
            this.setTitle("Edit Extension");
        }
    }

    protected JMenu createUpdateMenu() {
        JMenu jMenu = super.createUpdateMenu();
        ((JMenuItem)jMenu.getMenuComponent(0)).setText("Create extension updater");
        jMenu.remove(1);
        return jMenu;
    }

    protected void save() {
        ValidationReport validationReport = new ValidationReport();
        GameModule.getGameModule().validate(GameModule.getGameModule(), validationReport);
        if (validationReport.getWarnings().size() == 0) {
            try {
                this.extension.save();
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, iOException.getMessage(), "Save Failed", 0);
            }
        } else {
            ((Component)new ValidationReportDialog(validationReport, new ValidationReportDialog.CallBack(){

                public void ok() {
                    try {
                        ExtensionEditWindow.this.extension.save();
                        ExtensionEditWindow.this.refreshTitle();
                    }
                    catch (IOException iOException) {
                        JOptionPane.showMessageDialog(ExtensionEditWindow.this, iOException.getMessage(), "Save Failed", 0);
                    }
                }

                public void cancel() {
                }
            })).setVisible(true);
        }
    }

    protected void saveAs() {
        ValidationReport validationReport = new ValidationReport();
        GameModule.getGameModule().validate(GameModule.getGameModule(), validationReport);
        if (validationReport.getWarnings().size() == 0) {
            try {
                this.extension.save();
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, iOException.getMessage(), "Save Failed", 0);
            }
        } else {
            ((Component)new ValidationReportDialog(validationReport, new ValidationReportDialog.CallBack(){

                public void ok() {
                    try {
                        ExtensionEditWindow.this.extension.saveAs();
                        ExtensionEditWindow.this.refreshTitle();
                    }
                    catch (IOException iOException) {
                        JOptionPane.showMessageDialog(ExtensionEditWindow.this, iOException.getMessage(), "Save Failed", 0);
                    }
                }

                public void cancel() {
                }
            })).setVisible(true);
        }
    }
}

