/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.module.Documentation;
import VASSAL.configure.Configurer;
import VASSAL.configure.ImageConfigurer;
import VASSAL.tools.ArchiveWriter;
import VASSAL.tools.FileChooser;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class FileConfigurer
extends Configurer {
    private FileChooser globalFileChooser;
    protected ArchiveWriter archive;
    protected JPanel p;
    protected JTextField tf;
    protected FileChooser fc;
    protected boolean editable;

    public FileConfigurer(String string, String string2) {
        super(string, string2);
        this.setValue(null);
        this.fc = this.initFileChooser();
        this.editable = true;
    }

    protected FileChooser initFileChooser() {
        if (this.globalFileChooser == null) {
            this.globalFileChooser = FileChooser.createFileChooser(null);
            this.globalFileChooser.setCurrentDirectory(Documentation.getDocumentationBaseDir());
        }
        return this.globalFileChooser;
    }

    public FileConfigurer(String string, String string2, ArchiveWriter archiveWriter) {
        this(string, string2);
        this.archive = archiveWriter;
    }

    public String getValueString() {
        if (this.archive == null) {
            return this.fileValue() == null ? "null" : this.fileValue().getPath();
        }
        return this.fileValue() == null ? "null" : this.fileValue().getName();
    }

    public void setValue(Object object) {
        File file = (File)object;
        if (file != null && file.exists() && this.archive != null) {
            this.addToArchive(file);
        }
        super.setValue(file);
        if (this.tf != null && !this.noUpdate) {
            this.tf.setText(this.getValueString());
        }
    }

    protected void addToArchive(File file) {
        this.archive.addFile(file.getPath(), file.getName());
    }

    public void setValue(String string) {
        if (string == null) {
            this.setValue((Object)null);
        } else {
            this.setValue(new File(string));
        }
    }

    public Component getControls() {
        if (this.p == null) {
            this.p = new JPanel();
            this.p.setLayout(new BoxLayout(this.p, 0));
            this.p.add(new JLabel(this.getName()));
            JButton jButton = new JButton("Select");
            this.p.add(jButton);
            this.tf = new JTextField(this.getValueString());
            this.tf.setEditable(this.editable);
            this.tf.setMaximumSize(new Dimension(this.tf.getMaximumSize().width, this.tf.getPreferredSize().height));
            this.tf.getDocument().addDocumentListener(new DocumentListener(){

                public void changedUpdate(DocumentEvent documentEvent) {
                    this.update();
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    this.update();
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.update();
                }

                public void update() {
                    String string = FileConfigurer.this.tf.getText();
                    File file = string != null && string.length() > 0 && !"null".equals(string) ? new File(string) : null;
                    FileConfigurer.this.noUpdate = true;
                    FileConfigurer.this.setValue(file);
                    FileConfigurer.this.noUpdate = false;
                }
            });
            this.p.add(this.tf);
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    FileConfigurer.this.chooseNewValue();
                }
            });
        }
        return this.p;
    }

    public void chooseNewValue() {
        if (this.fc.showOpenDialog(this.getControls()) != 0) {
            this.setValue((Object)null);
        } else {
            this.setValue(this.fc.getSelectedFile().exists() ? this.fc.getSelectedFile() : (Object)null);
        }
    }

    protected File fileValue() {
        return (File)this.value;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        ImageConfigurer imageConfigurer = new ImageConfigurer(null, "Test file", new ArchiveWriter("testArchive"));
        imageConfigurer.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                System.err.println("" + propertyChangeEvent.getNewValue());
            }
        });
        jFrame.getContentPane().add(imageConfigurer.getControls());
        jFrame.pack();
        ((Component)jFrame).setVisible(true);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
        if (this.tf != null) {
            this.tf.setEditable(bl);
        }
    }
}

