/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.configure.Configurer;
import VASSAL.configure.HotKeyConfigurer;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class KeyStrokeArrayConfigurer
extends Configurer {
    private List configs = new ArrayList();
    private Box controls;

    public KeyStrokeArrayConfigurer(String string, String string2) {
        super(string, string2);
    }

    public KeyStrokeArrayConfigurer(String string, String string2, KeyStroke[] keyStrokeArray) {
        super(string, string2, keyStrokeArray);
    }

    public Component getControls() {
        if (this.controls == null) {
            this.controls = Box.createVerticalBox();
            Box box = Box.createHorizontalBox();
            this.controls.add(box);
            JLabel jLabel = new JLabel(this.getName());
            box.add(jLabel);
            JButton jButton = new JButton("Add");
            box.add(jButton);
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    KeyStrokeArrayConfigurer.this.addKey(null);
                }
            });
            KeyStroke[] keyStrokeArray = (KeyStroke[])this.value;
            if (keyStrokeArray != null) {
                for (int i = 0; i < keyStrokeArray.length; ++i) {
                    this.addKey(keyStrokeArray[i]);
                }
            }
            this.addKey(null);
        }
        return this.controls;
    }

    private void addKey(KeyStroke keyStroke) {
        HotKeyConfigurer hotKeyConfigurer = new HotKeyConfigurer(null, null, keyStroke);
        this.configs.add(hotKeyConfigurer);
        this.controls.add(hotKeyConfigurer.getControls());
        Window window = SwingUtilities.getWindowAncestor(this.controls);
        if (window != null) {
            window.pack();
        }
    }

    public String getValueString() {
        return KeyStrokeArrayConfigurer.encode(this.getKeyStrokes());
    }

    public void setValue(String string) {
        this.setValue(KeyStrokeArrayConfigurer.decode(string));
    }

    public void setValue(Object object) {
        super.setValue(object);
        if (this.controls != null) {
            int n;
            KeyStroke[] keyStrokeArray = (KeyStroke[])object;
            if (keyStrokeArray == null) {
                keyStrokeArray = new KeyStroke[]{};
            }
            for (n = 0; n < keyStrokeArray.length; ++n) {
                if (n > this.configs.size()) {
                    this.addKey(keyStrokeArray[n]);
                    continue;
                }
                ((HotKeyConfigurer)this.configs.get(n)).setValue(keyStrokeArray[n]);
            }
            for (n = keyStrokeArray.length; n < this.configs.size(); ++n) {
                ((HotKeyConfigurer)this.configs.get(n)).setValue(null);
            }
        }
    }

    public KeyStroke[] getKeyStrokes() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = this.configs.iterator();
        while (iterator.hasNext()) {
            HotKeyConfigurer hotKeyConfigurer = (HotKeyConfigurer)iterator.next();
            Object object = hotKeyConfigurer.getValue();
            if (object == null) continue;
            arrayList.add(object);
        }
        return arrayList.toArray(new KeyStroke[arrayList.size()]);
    }

    public static KeyStroke[] decode(String string) {
        if (string == null) {
            return null;
        }
        ArrayList<KeyStroke> arrayList = new ArrayList<KeyStroke>();
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ',');
        while (decoder.hasMoreTokens()) {
            arrayList.add(HotKeyConfigurer.decode(decoder.nextToken()));
        }
        return arrayList.toArray(new KeyStroke[arrayList.size()]);
    }

    public static String encode(KeyStroke[] keyStrokeArray) {
        if (keyStrokeArray == null) {
            return null;
        }
        SequenceEncoder sequenceEncoder = new SequenceEncoder(',');
        for (int i = 0; i < keyStrokeArray.length; ++i) {
            KeyStroke keyStroke = keyStrokeArray[i];
            sequenceEncoder.append(HotKeyConfigurer.encode(keyStroke));
        }
        return sequenceEncoder.getValue() != null ? sequenceEncoder.getValue() : "";
    }
}

