/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.configure.Configurer;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.SwingUtilities;

public abstract class ListConfigurer
extends Configurer
implements PropertyChangeListener {
    protected Box controls;
    protected Box configControls;
    protected List configurers = new ArrayList();

    public ListConfigurer(String string, String string2) {
        super(string, string2, new ArrayList());
    }

    public ListConfigurer(String string, String string2, List list) {
        super(string, string2, list);
    }

    public String getValueString() {
        if (this.getListValue().isEmpty()) {
            return "";
        }
        Configurer configurer = this.buildChildConfigurer();
        SequenceEncoder sequenceEncoder = new SequenceEncoder(',');
        Iterator iterator = this.getListValue().iterator();
        while (iterator.hasNext()) {
            configurer.setValue(iterator.next());
            sequenceEncoder.append(configurer.getValueString());
        }
        return sequenceEncoder.getValue();
    }

    public void setValue(String string) {
        this.getListValue().clear();
        if (string.length() > 0) {
            Configurer configurer = this.buildChildConfigurer();
            SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ',');
            while (decoder.hasMoreTokens()) {
                configurer.setValue(decoder.nextToken());
                this.getListValue().add(configurer.getValue());
            }
        }
        this.updateControls();
    }

    protected void updateValue() {
        this.noUpdate = true;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = this.configurers.iterator();
        while (iterator.hasNext()) {
            Configurer configurer = (Configurer)iterator.next();
            arrayList.add(configurer.getValue());
        }
        this.setValue(arrayList);
        this.noUpdate = false;
    }

    public void setValue(Object arrayList) {
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        super.setValue(arrayList);
        if (!this.noUpdate) {
            this.updateControls();
        }
    }

    public Component getControls() {
        if (this.controls == null) {
            this.controls = Box.createVerticalBox();
            this.controls.setBorder(BorderFactory.createTitledBorder(this.getName()));
            this.configControls = Box.createVerticalBox();
            this.controls.add(this.configControls);
            JButton jButton = new JButton("New");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Configurer configurer = ListConfigurer.this.buildChildConfigurer();
                    ListConfigurer.this.getListValue().add(configurer.getValue());
                    ListConfigurer.this.updateControls();
                }
            });
            this.controls.add(jButton);
            this.updateControls();
        }
        return this.controls;
    }

    public List getListValue() {
        return (List)this.getValue();
    }

    protected abstract Configurer buildChildConfigurer();

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.updateValue();
    }

    protected void updateControls() {
        if (this.controls != null) {
            Configurer configurer;
            Iterator iterator = this.configurers.iterator();
            while (iterator.hasNext()) {
                configurer = (Configurer)iterator.next();
                configurer.removePropertyChangeListener(this);
            }
            this.configurers.clear();
            this.configControls.removeAll();
            iterator = this.getListValue().iterator();
            while (iterator.hasNext()) {
                configurer = iterator.next();
                final Configurer configurer2 = this.buildChildConfigurer();
                configurer2.addPropertyChangeListener(this);
                configurer2.setValue(configurer);
                this.configurers.add(configurer2);
                Box box = Box.createHorizontalBox();
                JButton jButton = new JButton("Remove");
                jButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ListConfigurer.this.getListValue().remove(configurer2.getValue());
                        ListConfigurer.this.updateControls();
                        ListConfigurer.this.repack();
                    }
                });
                box.add(jButton);
                box.add(configurer2.getControls());
                this.configControls.add(box);
            }
            this.repack();
        }
    }

    public void repack() {
        Window window = SwingUtilities.getWindowAncestor(this.controls);
        if (window != null) {
            window.pack();
        }
    }
}

