/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.GameModule;
import VASSAL.build.module.Documentation;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.documentation.HelpWindow;
import VASSAL.configure.ConfigureTree;
import VASSAL.configure.ModuleUpdaterDialog;
import VASSAL.configure.SaveAction;
import VASSAL.configure.SaveAsAction;
import VASSAL.configure.SavedGameUpdaterDialog;
import VASSAL.configure.ShowHelpAction;
import VASSAL.configure.ValidationReport;
import VASSAL.configure.ValidationReportDialog;
import VASSAL.tools.ScrollPane;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;

public class ModuleEditWindow
extends JFrame
implements WindowListener {
    protected HelpWindow helpWindow = new HelpWindow("Reference Manual", null);
    protected JToolBar toolbar;

    public ModuleEditWindow() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
        this.refreshTitle();
        GameModule.getGameModule().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("name".equals(propertyChangeEvent.getPropertyName())) {
                    ModuleEditWindow.this.refreshTitle();
                }
            }
        });
        this.initComponents(new ScrollPane(new ConfigureTree(GameModule.getGameModule(), this.helpWindow)));
    }

    protected void initComponents(Component component) {
        Serializable serializable;
        this.getContentPane().add(component);
        this.toolbar = new JToolBar();
        this.toolbar.setFloatable(false);
        SaveAction saveAction = new SaveAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ModuleEditWindow.this.save();
            }
        };
        this.toolbar.add(saveAction);
        SaveAsAction saveAsAction = new SaveAsAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ModuleEditWindow.this.saveAs();
            }
        };
        this.toolbar.add(saveAsAction);
        ShowHelpAction showHelpAction = null;
        try {
            serializable = Documentation.getDocumentationBaseDir();
            serializable = new File((File)serializable, "ReferenceManual");
            showHelpAction = new ShowHelpAction(this.helpWindow, HelpFile.toURL(new File((File)serializable, "index.htm")), this.helpWindow.getClass().getResource("/images/Help16.gif"));
            showHelpAction.putValue("ShortDescription", "Reference Manual");
            this.toolbar.add(showHelpAction);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        this.getContentPane().add((Component)this.toolbar, "North");
        serializable = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        JMenuItem jMenuItem = new JMenuItem("Save");
        jMenuItem.addActionListener(saveAction);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Save as ...");
        jMenuItem.addActionListener(saveAsAction);
        jMenu.add(jMenuItem);
        ((JMenuBar)serializable).add(jMenu);
        if (showHelpAction != null) {
            JMenu jMenu2 = new JMenu("Help");
            jMenuItem = new JMenuItem("Reference Manual");
            jMenuItem.addActionListener(showHelpAction);
            jMenu2.add(jMenuItem);
            ((JMenuBar)serializable).add(jMenu2);
        }
        ((JMenuBar)serializable).add(this.createUpdateMenu());
        this.setJMenuBar((JMenuBar)serializable);
        this.pack();
    }

    protected JMenu createUpdateMenu() {
        JMenu jMenu = new JMenu("Updaters");
        JMenuItem jMenuItem = new JMenuItem("Create module updater");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((Component)new ModuleUpdaterDialog((Frame)ModuleEditWindow.this, ModuleEditWindow.this.helpWindow)).setVisible(true);
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Update saved games");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((Component)new SavedGameUpdaterDialog((Frame)ModuleEditWindow.this, ModuleEditWindow.this.helpWindow)).setVisible(true);
            }
        });
        jMenu.add(jMenuItem);
        return jMenu;
    }

    protected void saveAs() {
        ValidationReport validationReport = new ValidationReport();
        GameModule.getGameModule().validate(GameModule.getGameModule(), validationReport);
        if (validationReport.getWarnings().size() == 0) {
            GameModule.getGameModule().saveAs();
        } else {
            ((Component)new ValidationReportDialog(validationReport, new ValidationReportDialog.CallBack(){

                public void ok() {
                    GameModule.getGameModule().saveAs();
                }

                public void cancel() {
                }
            })).setVisible(true);
        }
    }

    protected void save() {
        ValidationReport validationReport = new ValidationReport();
        GameModule.getGameModule().validate(GameModule.getGameModule(), validationReport);
        if (validationReport.getWarnings().size() == 0) {
            GameModule.getGameModule().save();
        } else {
            ((Component)new ValidationReportDialog(validationReport, new ValidationReportDialog.CallBack(){

                public void ok() {
                    GameModule.getGameModule().save();
                }

                public void cancel() {
                }
            })).setVisible(true);
        }
    }

    protected void refreshTitle() {
        String string = GameModule.getGameModule().getConfigureName();
        if (string == null) {
            string = "Module";
        }
        this.setTitle("Edit " + string);
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        GameModule.getGameModule().quit();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

