/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.GameModule;
import VASSAL.build.module.Documentation;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.documentation.HelpWindow;
import VASSAL.configure.FileConfigurer;
import VASSAL.configure.ShowHelpAction;
import VASSAL.tools.FileChooser;
import VASSAL.tools.ZipUpdater;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class ModuleUpdaterDialog
extends JDialog {
    private HelpWindow helpWindow;

    public ModuleUpdaterDialog(Frame frame, HelpWindow helpWindow) throws HeadlessException {
        super(frame, false);
        this.helpWindow = helpWindow;
        this.setTitle("Module Updater");
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        final FileConfigurer fileConfigurer = new FileConfigurer(null, "File containing older version:  ");
        this.getContentPane().add(fileConfigurer.getControls());
        Box box = Box.createHorizontalBox();
        final JButton jButton = new JButton("Create Updater");
        jButton.setEnabled(false);
        fileConfigurer.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                jButton.setEnabled(fileConfigurer.getValue() != null);
            }
        });
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FileChooser fileChooser = GameModule.getGameModule().getFileChooser();
                if (fileChooser.showSaveDialog(ModuleUpdaterDialog.this.getOwner()) != 0) {
                    return;
                }
                File file = fileChooser.getSelectedFile();
                ZipUpdater zipUpdater = null;
                try {
                    zipUpdater = new ZipUpdater((File)fileConfigurer.getValue());
                    zipUpdater.createUpdater(new File(GameModule.getGameModule().getArchiveWriter().getArchive().getName()), file);
                }
                catch (IOException iOException) {
                    String string = iOException.getMessage();
                    if (string == null) {
                        string = "Unable to create updater.";
                    }
                    JOptionPane.showMessageDialog(ModuleUpdaterDialog.this, string, "Error writing updater", 0);
                }
            }
        });
        JButton jButton2 = new JButton("Close");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ModuleUpdaterDialog.this.dispose();
            }
        });
        JButton jButton3 = new JButton("Help");
        this.getContentPane().add(box);
        HelpFile helpFile = null;
        try {
            helpFile = new HelpFile(null, new File(new File(Documentation.getDocumentationBaseDir(), "ReferenceManual"), "ModuleUpdater.htm"));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        jButton3.addActionListener(new ShowHelpAction(this.helpWindow, helpFile, null));
        box.add(jButton);
        box.add(jButton3);
        box.add(jButton2);
        this.getContentPane().add(box);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }
}

