/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.configure.Configurer;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.counters.PieceAccess;
import VASSAL.counters.PlayerAccess;
import VASSAL.counters.SideAccess;
import VASSAL.counters.SpecifiedSideAccess;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PieceAccessConfigurer
extends Configurer {
    protected static String PLAYER = "player:";
    protected static String SIDE = "side:";
    protected static String SIDES = "sides:";
    protected JPanel controls;
    protected String[] prompts = new String[]{"Any player", "Any side", "Any of the specified sides"};
    protected JComboBox selectType;
    protected StringArrayConfigurer sideConfig;

    public PieceAccessConfigurer(String string, String string2, PieceAccess pieceAccess) {
        super(string, string2, pieceAccess);
    }

    public void setValue(Object object) {
        super.setValue(object);
        this.updateControls();
    }

    public String getValueString() {
        return PieceAccessConfigurer.encode(this.getPieceAccess());
    }

    public void setValue(String string) {
        this.setValue(PieceAccessConfigurer.decode(string));
    }

    public Component getControls() {
        if (this.controls == null) {
            this.controls = new JPanel();
            this.controls.setLayout(new BoxLayout(this.controls, 1));
            Box box = Box.createHorizontalBox();
            box.add(new JLabel(this.getName()));
            this.selectType = new JComboBox<String>(this.getPrompts());
            this.selectType.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    PieceAccessConfigurer.this.updateValue();
                    PieceAccessConfigurer.this.sideConfig.getControls().setVisible(PieceAccessConfigurer.this.getValue() instanceof SpecifiedSideAccess);
                    if (PieceAccessConfigurer.this.controls.getTopLevelAncestor() instanceof Window) {
                        ((Window)PieceAccessConfigurer.this.controls.getTopLevelAncestor()).pack();
                    }
                }
            });
            box.add(this.selectType);
            this.controls.add(box);
            this.sideConfig = new StringArrayConfigurer(null, null);
            this.sideConfig.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    PieceAccessConfigurer.this.updateValue();
                }
            });
            this.controls.add(this.sideConfig.getControls());
            this.updateControls();
        }
        return this.controls;
    }

    protected void updateValue() {
        this.noUpdate = true;
        if (this.prompts[1].equals(this.selectType.getSelectedItem())) {
            this.setValue(SideAccess.getInstance());
        } else if (this.prompts[2].equals(this.selectType.getSelectedItem())) {
            this.setValue(new SpecifiedSideAccess(Arrays.asList(this.sideConfig.getStringArray())));
        } else {
            this.setValue(PlayerAccess.getInstance());
        }
        this.noUpdate = false;
    }

    protected void updateControls() {
        if (!this.noUpdate && this.controls != null) {
            this.sideConfig.getControls().setVisible(this.getValue() instanceof SpecifiedSideAccess);
            if (this.getValue() instanceof SideAccess) {
                this.selectType.setSelectedIndex(1);
            } else if (this.getValue() instanceof SpecifiedSideAccess) {
                this.sideConfig.setValue(((SpecifiedSideAccess)this.getPieceAccess()).getSides().toArray(new String[0]));
                this.selectType.setSelectedIndex(2);
            } else {
                this.selectType.setSelectedIndex(0);
            }
        }
    }

    public String[] getPrompts() {
        return this.prompts;
    }

    public PieceAccess getPieceAccess() {
        return (PieceAccess)this.getValue();
    }

    public static PieceAccess decode(String string) {
        if (SIDE.equals(string)) {
            return SideAccess.getInstance();
        }
        if (string != null && string.startsWith(SIDES)) {
            SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string.substring(SIDES.length()), ':');
            ArrayList<String> arrayList = new ArrayList<String>();
            while (decoder.hasMoreTokens()) {
                arrayList.add(decoder.nextToken());
            }
            return new SpecifiedSideAccess(arrayList);
        }
        return PlayerAccess.getInstance();
    }

    public static String encode(PieceAccess pieceAccess) {
        String string = null;
        if (pieceAccess instanceof SideAccess) {
            string = SIDE;
        } else if (pieceAccess instanceof SpecifiedSideAccess) {
            SequenceEncoder sequenceEncoder = new SequenceEncoder(':');
            Iterator iterator = ((SpecifiedSideAccess)pieceAccess).getSides().iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                sequenceEncoder.append(string2);
            }
            string = sequenceEncoder.getValue() == null ? SIDES : SIDES + sequenceEncoder.getValue();
        } else if (pieceAccess instanceof PlayerAccess) {
            string = PLAYER;
        }
        return string;
    }

    public void setPrompts(String[] stringArray) {
        this.prompts = stringArray;
        if (this.selectType == null) {
            this.selectType.setModel(new DefaultComboBoxModel<String>(stringArray));
        }
    }
}

