/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.Builder;
import VASSAL.build.Configurable;
import VASSAL.build.module.documentation.HelpWindow;
import VASSAL.build.module.documentation.HelpWindowExtension;
import VASSAL.configure.ConfigureTree;
import VASSAL.configure.Configurer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PropertiesWindow
extends JDialog {
    private Configurer configurer;
    private Configurable target;
    private Element originalState;

    public PropertiesWindow(Frame frame, boolean bl, Configurable configurable, HelpWindow helpWindow) {
        super(frame, bl);
        this.initialize(configurable, helpWindow);
    }

    protected void initialize(Configurable configurable, HelpWindow helpWindow) {
        Object object;
        this.target = configurable;
        this.originalState = configurable.getBuildElement(Builder.createNewDocument());
        Node node = this.originalState.getFirstChild();
        while (node != null) {
            object = node.getNextSibling();
            if (1 == node.getNodeType()) {
                try {
                    Class.forName(((Element)node).getTagName());
                    this.originalState.removeChild(node);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            node = object;
        }
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.configurer = configurable.getConfigurer();
        if (helpWindow != null && this.configurer instanceof HelpWindowExtension) {
            ((HelpWindowExtension)((Object)this.configurer)).setBaseWindow(helpWindow);
        }
        configurable.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("name".equals(propertyChangeEvent.getPropertyName())) {
                    PropertiesWindow.this.setTitle((String)propertyChangeEvent.getNewValue());
                }
            }
        });
        this.getContentPane().add(this.configurer.getControls());
        this.setTitle(ConfigureTree.getConfigureName(configurable));
        object = Box.createHorizontalBox();
        JButton jButton = new JButton("Ok");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertiesWindow.this.save();
            }
        });
        ((Container)object).add(jButton);
        JButton jButton2 = new JButton("Cancel");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertiesWindow.this.cancel();
            }
        });
        ((Container)object).add(jButton2);
        this.getContentPane().add((Component)object);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PropertiesWindow.this.cancel();
            }
        });
    }

    public void cancel() {
        this.target.build(this.originalState);
        this.dispose();
    }

    public void save() {
        this.configurer.getValue();
        this.dispose();
    }
}

