/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.GameModule;
import VASSAL.build.module.Documentation;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.documentation.HelpWindow;
import VASSAL.configure.ShowHelpAction;
import VASSAL.tools.SavedGameUpdater;
import VASSAL.tools.ScrollPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class SavedGameUpdaterDialog
extends JDialog {
    private HelpWindow helpWindow;
    private DefaultListModel savedGamesModel;
    private SavedGameUpdater updater = new SavedGameUpdater();
    private Properties oldPieceInfo;
    private JFileChooser fc;
    private static final String VERSION_KEY = "moduleVerion";
    private static final String MODULE_NAME_KEY = "moduleName";
    private JButton updateButton;
    private JTextField versionField;

    public SavedGameUpdaterDialog(Frame frame, HelpWindow helpWindow) throws HeadlessException {
        super(frame, false);
        this.helpWindow = helpWindow;
        this.setTitle("Update Saved Games");
        this.initComponents();
        this.fc = new JFileChooser();
        this.fc.setCurrentDirectory(GameModule.getGameModule().getFileChooser().getCurrentDirectory());
    }

    private void initComponents() {
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        Box box = Box.createHorizontalBox();
        box.add(new JLabel("Module version of saved games:  "));
        this.versionField = new JTextField(8);
        this.versionField.setEditable(false);
        this.versionField.setMaximumSize(new Dimension(this.versionField.getMaximumSize().width, this.versionField.getPreferredSize().height));
        box.add(this.versionField);
        JButton jButton = new JButton("Import GamePiece info");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SavedGameUpdaterDialog.this.importPieceInfo();
            }
        });
        box.add(jButton);
        this.getContentPane().add(box);
        JButton jButton2 = new JButton("Export GamePiece info");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SavedGameUpdaterDialog.this.exportPieceInfo();
            }
        });
        Box box2 = Box.createHorizontalBox();
        box2.add(jButton);
        box2.add(jButton2);
        this.getContentPane().add(box2);
        Box box3 = Box.createHorizontalBox();
        Box box4 = Box.createVerticalBox();
        box4.add(new JLabel("Saved Games:"));
        JButton jButton3 = new JButton("Choose");
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SavedGameUpdaterDialog.this.chooseSavedGames();
            }
        });
        box4.add(jButton3);
        box3.add(box4);
        this.savedGamesModel = new DefaultListModel();
        JList<Object> jList = new JList<Object>(this.savedGamesModel);
        jList.setVisibleRowCount(5);
        jList.setCellRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                this.setText(((File)object).getName());
                return this;
            }
        });
        box3.add(new ScrollPane(jList));
        this.getContentPane().add(box3);
        Box box5 = Box.createHorizontalBox();
        this.updateButton = new JButton("Update games");
        this.updateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SavedGameUpdaterDialog.this.updateGames();
            }
        });
        this.updateButton.setEnabled(false);
        box5.add(this.updateButton);
        JButton jButton4 = new JButton("Help");
        HelpFile helpFile = null;
        try {
            helpFile = new HelpFile(null, new File(new File(Documentation.getDocumentationBaseDir(), "ReferenceManual"), "SavedGameUpdater.htm"));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        jButton4.addActionListener(new ShowHelpAction(this.helpWindow, helpFile, null));
        box5.add(jButton4);
        JButton jButton5 = new JButton("Close");
        jButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SavedGameUpdaterDialog.this.dispose();
            }
        });
        box5.add(jButton5);
        this.getContentPane().add(box5);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    private void updateGames() {
        this.updateButton.setEnabled(false);
        Runnable runnable = new Runnable(){

            public void run() {
                int n = SavedGameUpdaterDialog.this.savedGamesModel.size();
                for (int i = 0; i < n; ++i) {
                    try {
                        File file = (File)SavedGameUpdaterDialog.this.savedGamesModel.getElementAt(i);
                        SavedGameUpdaterDialog.this.updater.updateSavedGame(SavedGameUpdaterDialog.this.oldPieceInfo, file);
                        GameModule.getGameModule().warn("Updated " + file.getName() + " from version " + SavedGameUpdaterDialog.this.versionField.getText() + " to " + GameModule.getGameModule().getGameVersion());
                        continue;
                    }
                    catch (IOException iOException) {
                        Runnable runnable = new Runnable(this, iOException){
                            private final /* synthetic */ IOException val$e;
                            private final /* synthetic */ 7 this$1;
                            {
                                this.this$1 = var1_1;
                                this.val$e = iOException;
                            }

                            public void run() {
                                SavedGameUpdaterDialog.access$900(7.access$800(this.this$1), this.val$e, "Update failed", "Unable to save file");
                            }
                        };
                        try {
                            SwingUtilities.invokeAndWait(runnable);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            // empty catch block
                        }
                    }
                }
                SavedGameUpdaterDialog.this.updateButton.setEnabled(true);
            }

            static /* synthetic */ SavedGameUpdaterDialog access$800(7 var0) {
                return var0.SavedGameUpdaterDialog.this;
            }
        };
        new Thread(runnable).start();
    }

    private void chooseSavedGames() {
        File[] fileArray;
        this.fc.setMultiSelectionEnabled(true);
        if (1 != this.fc.showOpenDialog(this) && (fileArray = this.fc.getSelectedFiles()) != null) {
            this.savedGamesModel.clear();
            for (int i = 0; i < fileArray.length; ++i) {
                this.savedGamesModel.addElement(fileArray[i]);
            }
        }
    }

    private void exportPieceInfo() {
        this.fc.setMultiSelectionEnabled(false);
        if (1 != this.fc.showOpenDialog(this)) {
            Properties properties = this.updater.getPieceSlotsMap();
            ((Hashtable)properties).put(MODULE_NAME_KEY, GameModule.getGameModule().getGameName());
            ((Hashtable)properties).put(VERSION_KEY, GameModule.getGameModule().getGameVersion());
            try {
                properties.store(new FileOutputStream(this.fc.getSelectedFile()), null);
            }
            catch (IOException iOException) {
                this.showErrorMessage(iOException, "Export failed", "Unable to write info");
            }
        }
    }

    private void importPieceInfo() {
        this.fc.setMultiSelectionEnabled(false);
        if (1 != this.fc.showOpenDialog(this)) {
            this.oldPieceInfo = new Properties();
            try {
                this.oldPieceInfo.load(new FileInputStream(this.fc.getSelectedFile()));
                String string = this.oldPieceInfo.getProperty(VERSION_KEY);
                String string2 = this.oldPieceInfo.getProperty(MODULE_NAME_KEY);
                if (!GameModule.getGameModule().getGameName().equals(string2)) {
                    this.showErrorMessage(null, "Import failed", "Imported info is from the wrong module:  " + string2);
                    this.oldPieceInfo = null;
                    this.versionField.setText(null);
                } else if (GameModule.getGameModule().getGameVersion().equals(string)) {
                    this.showErrorMessage(null, "Import failed", "Imported info is from the current version, " + string + ".\nLoad the older version in the editor and export the GamePiece info,\nThen load this module again and import the older version's info");
                    this.oldPieceInfo = null;
                    this.versionField.setText(null);
                } else {
                    this.versionField.setText(string);
                }
            }
            catch (IOException iOException) {
                this.showErrorMessage(iOException, "Import failed", "Unable to import info");
                this.oldPieceInfo = null;
            }
        }
        this.updateButton.setEnabled(this.oldPieceInfo != null);
    }

    private void showErrorMessage(Exception exception, String string, String string2) {
        String string3;
        String string4 = string3 = exception == null ? null : exception.getMessage();
        if (string3 == null) {
            string3 = string2;
        }
        JOptionPane.showMessageDialog(this, string3, string, 0);
    }

    static /* synthetic */ void access$900(SavedGameUpdaterDialog savedGameUpdaterDialog, Exception exception, String string, String string2) {
        savedGameUpdaterDialog.showErrorMessage(exception, string, string2);
    }
}

