/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.GameModule;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.configure.Configurer;
import VASSAL.tools.AudioFileFilter;
import VASSAL.tools.FileChooser;
import java.applet.AudioClip;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SoundConfigurer
extends Configurer {
    public static final String DEFAULT = "default";
    private String defaultResource;
    private String clipName;
    private JPanel controls;
    private JTextField textField;
    private Method clipFactory;
    private final String NO_VALUE = "<disabled>";
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$java$applet$Applet;

    public SoundConfigurer(String string, String string2, String string3) {
        super(string, string2);
        this.defaultResource = string3;
        try {
            this.clipFactory = (class$java$applet$Applet == null ? (class$java$applet$Applet = SoundConfigurer.class$("java.applet.Applet")) : class$java$applet$Applet).getMethod("newAudioClip", class$java$net$URL == null ? (class$java$net$URL = SoundConfigurer.class$("java.net.URL")) : class$java$net$URL);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.setValue(DEFAULT);
    }

    public Component getControls() {
        if (this.controls == null) {
            if (this.clipFactory == null) {
                this.controls = new JPanel();
                this.controls.add(new JLabel("Sound not supported on this platform"));
            } else {
                this.controls = new JPanel();
                this.controls.setLayout(new BoxLayout(this.controls, 0));
                this.controls.add(new JLabel(this.name));
                JButton jButton = new JButton("Play");
                jButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        SoundConfigurer.this.play();
                    }
                });
                this.controls.add(jButton);
                jButton = new JButton("Default");
                jButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        SoundConfigurer.this.setValue(SoundConfigurer.DEFAULT);
                    }
                });
                this.controls.add(jButton);
                jButton = new JButton("Select");
                jButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        SoundConfigurer.this.chooseClip();
                    }
                });
                this.controls.add(jButton);
                this.textField = new JTextField();
                this.textField.setMaximumSize(new Dimension(this.textField.getMaximumSize().width, this.textField.getPreferredSize().height));
                this.textField.setEditable(false);
                this.textField.setText(DEFAULT.equals(this.clipName) ? this.defaultResource : this.clipName);
                this.controls.add(this.textField);
            }
        }
        return this.controls;
    }

    public String getValueString() {
        String string = "<disabled>";
        if (this.clipName != null) {
            string = this.clipName;
        }
        return string;
    }

    public void setValue(String string) {
        if (this.clipFactory == null) {
            return;
        }
        URL uRL = null;
        if (DEFAULT.equals(string)) {
            uRL = this.getClass().getResource("/images/" + this.defaultResource);
            this.clipName = string;
        } else if ("<disabled>".equals(string)) {
            this.clipName = string;
        } else if (string != null) {
            try {
                uRL = HelpFile.toURL(new File(string));
                this.clipName = string;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.clipName = null;
            }
        }
        if (this.textField != null) {
            this.textField.setText(DEFAULT.equals(this.clipName) ? this.defaultResource : this.clipName);
        }
        if (uRL != null) {
            try {
                this.setValue(this.clipFactory.invoke(null, uRL));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            if (this.textField != null) {
                this.textField.setText(null);
            }
            this.setValue((Object)null);
        }
    }

    public void play() {
        AudioClip audioClip = (AudioClip)this.getValue();
        if (audioClip != null) {
            audioClip.play();
        }
    }

    public void chooseClip() {
        FileChooser fileChooser = GameModule.getGameModule().getFileChooser();
        fileChooser.setFileFilter(new AudioFileFilter());
        if (fileChooser.showOpenDialog(this.getControls()) != 0) {
            this.setValue("<disabled>");
        } else {
            File file = fileChooser.getSelectedFile();
            this.setValue(file.getName());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

