/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.configure.AutoConfigurer;
import VASSAL.configure.Configurer;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class TableConfigurer
extends Configurer
implements ActionListener {
    public static final String ADD_ACTION = "Add";
    public static final String DEL_ACTION = "Remove";
    public static final String INS_ACTION = "Insert";
    protected Box controls;
    protected JPanel contents = null;
    protected Column[] columns = new Column[0];
    protected char rowDelimiter = (char)44;
    protected char colDelimiter = (char)124;

    public TableConfigurer(String string, String string2, String[] stringArray, Class[] classArray) {
        this(string, string2);
        this.columns = new Column[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.columns[i] = new Column(stringArray[i], classArray[i]);
        }
    }

    public TableConfigurer(String string, String string2) {
        super(string, string2);
    }

    public String getValueString() {
        return null;
    }

    public void setValue(String string) {
    }

    public void setRowDelimiter(char c) {
        this.rowDelimiter = c;
    }

    public void setColDelimiter(char c) {
        this.colDelimiter = c;
    }

    public int getColumnCount() {
        return this.columns.length;
    }

    public Component getControls() {
        if (this.controls == null) {
            this.buildControls();
        }
        return this.controls;
    }

    protected void buildControls() {
        this.controls = Box.createVerticalBox();
        this.controls.setBorder(BorderFactory.createEtchedBorder());
        this.controls.add(new JLabel(this.getName()));
        this.updateContents();
        Box box = Box.createHorizontalBox();
        JButton jButton = new JButton(ADD_ACTION);
        jButton.addActionListener(this);
        box.add(jButton);
        JButton jButton2 = new JButton(DEL_ACTION);
        jButton2.addActionListener(this);
        box.add(jButton2);
        JButton jButton3 = new JButton(INS_ACTION);
        jButton3.addActionListener(this);
        box.add(jButton3);
        this.controls.add(box);
        this.repack();
    }

    protected void repack() {
        Window window = SwingUtilities.getWindowAncestor(this.controls);
        if (window != null) {
            window.pack();
        }
    }

    protected void updateContents() {
        int n;
        if (this.contents != null) {
            this.controls.remove(this.contents);
            this.contents = null;
        }
        this.contents = new JPanel();
        this.contents.setBorder(BorderFactory.createEtchedBorder());
        this.contents.setLayout(new GridLayout(0, 5));
        for (n = 0; n < this.columns.length; ++n) {
            this.contents.add(new JLabel(this.columns[n].getName()));
        }
        if (this.columns[0].getRowCount() > 0) {
            for (n = 0; n < this.columns[0].getRowCount(); ++n) {
                for (int i = 0; i < this.columns.length; ++i) {
                    this.contents.add(this.columns[i].getControls(n));
                }
            }
        }
        this.controls.add(this.contents);
        this.repack();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(ADD_ACTION)) {
            for (int i = 0; i < this.getColumnCount(); ++i) {
                this.columns[i].addRow();
            }
            this.updateContents();
        } else if (string.equals(DEL_ACTION) || string.equals(INS_ACTION)) {
            // empty if block
        }
    }

    protected class Column {
        protected Class type;
        protected String name;
        protected ArrayList configurers = new ArrayList(0);
        protected Box controls;
        protected JPanel contents;

        public Column(String string, Class clazz) {
            this.name = string;
            this.type = clazz;
        }

        public Component getControls(int n) {
            if (n >= 0 && n < this.getRowCount()) {
                return ((Configurer)this.configurers.get(n)).getControls();
            }
            return null;
        }

        public String getName() {
            return this.name;
        }

        public void addRow() {
            Configurer configurer = AutoConfigurer.createConfigurer(this.type, null, "", null);
            this.configurers.add(configurer);
        }

        public int getRowCount() {
            return this.configurers.size();
        }
    }
}

