/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.configure.HotKeyConfigurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.EditablePiece;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceCloner;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.PieceFinder;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Box;
import javax.swing.KeyStroke;

public class ActionButton
extends Decorator
implements EditablePiece {
    public static final String ID = "button;";
    protected KeyStroke stroke;
    protected Rectangle bounds = new Rectangle();
    protected ButtonPusher pusher;
    protected String description = "";
    protected static ButtonPusher globalPusher = new ButtonPusher();

    public ActionButton() {
        this(ID, null);
    }

    public ActionButton(String string, GamePiece gamePiece) {
        this.mySetType(string);
        this.setInner(gamePiece);
        this.pusher = globalPusher;
    }

    public void mySetState(String string) {
    }

    public String myGetState() {
        return "";
    }

    public String myGetType() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
        sequenceEncoder.append(this.stroke).append(this.bounds.x).append(this.bounds.y).append(this.bounds.width).append(this.bounds.height).append(this.description);
        return ID + sequenceEncoder.getValue();
    }

    protected KeyCommand[] myGetKeyCommands() {
        return null;
    }

    public Command myKeyEvent(KeyStroke keyStroke) {
        return null;
    }

    public void draw(Graphics graphics, int n, int n2, Component component, double d) {
        this.piece.draw(graphics, n, n2, component, d);
        if (this.getMap() != null) {
            this.pusher.register(this.getMap());
        } else {
            this.pusher.register(component, Decorator.getOutermost(this), n, n2);
        }
    }

    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    public Shape getShape() {
        return this.piece.getShape();
    }

    public String getName() {
        return this.piece.getName();
    }

    public String getDescription() {
        return this.description.length() == 0 ? "Action Button" : "Action Button - " + this.description;
    }

    public void mySetType(String string) {
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        decoder.nextToken();
        this.stroke = decoder.nextKeyStroke('A');
        this.bounds.x = decoder.nextInt(-20);
        this.bounds.y = decoder.nextInt(-20);
        this.bounds.width = decoder.nextInt(40);
        this.bounds.height = decoder.nextInt(40);
        this.description = decoder.nextToken("");
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("ActionButton.htm");
    }

    public PieceEditor getEditor() {
        return new Ed(this);
    }

    protected static class ButtonPusher {
        private Set maps = new HashSet();
        private java.util.Map components = new HashMap();

        protected ButtonPusher() {
        }

        public void register(Map map) {
            if (map != null && !this.maps.contains(map)) {
                map.addLocalMouseListener(new MapMouseListener(map));
                this.maps.add(map);
            }
        }

        public void register(Component component, GamePiece gamePiece, int n, int n2) {
            if (component != null) {
                ComponentMouseListener componentMouseListener = (ComponentMouseListener)this.components.get(component);
                if (componentMouseListener == null) {
                    componentMouseListener = new ComponentMouseListener(gamePiece, n, n2);
                    component.addMouseListener(componentMouseListener);
                    this.components.put(component, componentMouseListener);
                } else {
                    componentMouseListener.xOffset = n;
                    componentMouseListener.yOffset = n2;
                    componentMouseListener.target = gamePiece;
                }
            }
        }

        public void doClick(GamePiece gamePiece, Point point) {
            GamePiece gamePiece2 = gamePiece;
            while (gamePiece2 instanceof Decorator) {
                if (gamePiece2 instanceof ActionButton) {
                    ActionButton actionButton = (ActionButton)gamePiece2;
                    if (actionButton.bounds.contains(point)) {
                        gamePiece.setProperty("snapshot", PieceCloner.getInstance().clonePiece(gamePiece));
                        Command command = gamePiece.keyEvent(actionButton.stroke);
                        GameModule.getGameModule().sendAndLog(command);
                    }
                }
                gamePiece2 = ((Decorator)gamePiece2).getInner();
            }
        }

        protected class ComponentMouseListener
        extends MouseAdapter {
            private GamePiece target;
            private int xOffset;
            private int yOffset;

            public ComponentMouseListener(GamePiece gamePiece, int n, int n2) {
                this.target = gamePiece;
                this.xOffset = n;
                this.yOffset = n2;
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                point.translate(-this.xOffset, -this.yOffset);
                ButtonPusher.this.doClick(this.target, point);
                mouseEvent.getComponent().repaint();
            }
        }

        protected class MapMouseListener
        extends MouseAdapter {
            private Map map;

            public MapMouseListener(Map map) {
                this.map = map;
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                GamePiece gamePiece = this.map.findPiece(point, PieceFinder.PIECE_IN_STACK);
                if (gamePiece != null) {
                    Point point2 = this.map.positionOf(gamePiece);
                    point.translate(-point2.x, -point2.y);
                    ButtonPusher.this.doClick(gamePiece, point);
                }
            }
        }
    }

    public static class Ed
    implements PieceEditor {
        private Box box = Box.createVerticalBox();
        private IntConfigurer xConfig;
        private IntConfigurer yConfig;
        private IntConfigurer widthConfig;
        private IntConfigurer heightConfig;
        private HotKeyConfigurer strokeConfig;
        protected StringConfigurer descConfig;

        public Ed(ActionButton actionButton) {
            this.descConfig = new StringConfigurer(null, "Description:  ", actionButton.description);
            this.box.add(this.descConfig.getControls());
            this.strokeConfig = new HotKeyConfigurer(null, "Invoke Key Command:  ", actionButton.stroke);
            this.box.add(this.strokeConfig.getControls());
            this.xConfig = new IntConfigurer(null, "Button X-offset:  ", new Integer(actionButton.bounds.x));
            this.box.add(this.xConfig.getControls());
            this.yConfig = new IntConfigurer(null, "Button Y-offset:  ", new Integer(actionButton.bounds.y));
            this.box.add(this.yConfig.getControls());
            this.widthConfig = new IntConfigurer(null, "Button Width:  ", new Integer(actionButton.bounds.width));
            this.box.add(this.widthConfig.getControls());
            this.heightConfig = new IntConfigurer(null, "Button Height:  ", new Integer(actionButton.bounds.height));
            this.box.add(this.heightConfig.getControls());
        }

        public Component getControls() {
            return this.box;
        }

        public String getType() {
            SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
            sequenceEncoder.append(this.strokeConfig.getValueString()).append(this.xConfig.getValueString()).append(this.yConfig.getValueString()).append(this.widthConfig.getValueString()).append(this.heightConfig.getValueString()).append(this.descConfig.getValueString());
            return ActionButton.ID + sequenceEncoder.getValue();
        }

        public String getState() {
            return "";
        }
    }
}

