/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.MapShader;
import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.build.module.map.boardPicker.board.GeometricGrid;
import VASSAL.build.module.map.boardPicker.board.MapGrid;
import VASSAL.command.ChangeTracker;
import VASSAL.command.Command;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.ChooseComponentDialog;
import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.HotKeyConfigurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.EditablePiece;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.tools.SequenceEncoder;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class AreaOfEffect
extends Decorator
implements EditablePiece,
MapShader.ShadedPiece {
    public static final String ID = "AreaOfEffect;";
    protected static final Color defaultTransparencyColor = Color.GRAY;
    protected static final float defaultTransparencyLevel = 0.3f;
    protected static final int defaultRadius = 1;
    protected Color transparencyColor;
    protected float transparencyLevel;
    protected int radius;
    protected boolean alwaysActive;
    protected boolean active;
    protected String activateCommand;
    protected KeyStroke activateKey;
    protected KeyCommand[] commands;
    protected String mapShaderName;
    protected MapShader shader;
    protected KeyCommand keyCommand;
    protected boolean fixedRadius = true;
    protected String radiusMarker = "";
    protected String description = "";
    static /* synthetic */ Class class$VASSAL$build$module$map$MapShader$ShadedPiece;
    static /* synthetic */ Class class$java$awt$Frame;
    static /* synthetic */ Class class$VASSAL$build$module$map$MapShader;

    public AreaOfEffect() {
        this(ID + ColorConfigurer.colorToString(defaultTransparencyColor), null);
    }

    public AreaOfEffect(String string, GamePiece gamePiece) {
        this.mySetType(string);
        this.setInner(gamePiece);
    }

    public String getDescription() {
        String string = "Area Of Effect";
        if (this.description.length() > 0) {
            string = string + " - " + this.description;
        }
        return string;
    }

    public String myGetType() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
        sequenceEncoder.append(this.transparencyColor);
        sequenceEncoder.append((int)(this.transparencyLevel * 100.0f));
        sequenceEncoder.append(this.radius);
        sequenceEncoder.append(this.alwaysActive);
        sequenceEncoder.append(this.activateCommand);
        sequenceEncoder.append(this.activateKey);
        sequenceEncoder.append(this.mapShaderName == null ? "" : this.mapShaderName);
        sequenceEncoder.append(this.fixedRadius);
        sequenceEncoder.append(this.radiusMarker);
        sequenceEncoder.append(this.description);
        return ID + sequenceEncoder.getValue();
    }

    public void mySetType(String string) {
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        decoder.nextToken();
        this.transparencyColor = decoder.nextColor(defaultTransparencyColor);
        this.transparencyLevel = (float)decoder.nextInt(30) / 100.0f;
        this.radius = decoder.nextInt(1);
        this.alwaysActive = decoder.nextBoolean(true);
        this.activateCommand = decoder.nextToken("Show Area");
        this.activateKey = decoder.nextKeyStroke(null);
        this.keyCommand = new KeyCommand(this.activateCommand, this.activateKey, Decorator.getOutermost(this));
        this.mapShaderName = decoder.nextToken("");
        if (this.mapShaderName.length() == 0) {
            this.mapShaderName = null;
        }
        this.fixedRadius = decoder.nextBoolean(true);
        this.radiusMarker = decoder.nextToken("");
        this.description = decoder.nextToken("");
        this.shader = null;
        this.commands = null;
    }

    public String myGetState() {
        return this.alwaysActive ? "" : String.valueOf(this.active);
    }

    public void mySetState(String string) {
        if (!this.alwaysActive) {
            this.active = "true".equals(string);
        }
    }

    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    public Shape getShape() {
        return this.piece.getShape();
    }

    public String getName() {
        return this.piece.getName();
    }

    public void draw(Graphics graphics, int n, int n2, Component component, double d) {
        if ((this.alwaysActive || this.active) && this.mapShaderName == null && component instanceof Map.View && graphics instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Color color = graphics2D.getColor();
            graphics2D.setColor(this.transparencyColor);
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, this.transparencyLevel));
            Area area = this.getArea();
            if (d != 1.0) {
                area = new Area(AffineTransform.getScaleInstance(d, d).createTransformedShape(area));
            }
            graphics2D.fill(area);
            graphics2D.setColor(color);
            graphics2D.setComposite(composite);
        }
        this.piece.draw(graphics, n, n2, component, d);
    }

    protected Area getArea() {
        Area area;
        Point point;
        Map map = this.getMap();
        Board board = map.findBoard(point = this.getPosition());
        MapGrid mapGrid = board == null ? null : board.getGrid();
        int n = this.getRadius();
        if (mapGrid instanceof GeometricGrid) {
            GeometricGrid geometricGrid = (GeometricGrid)mapGrid;
            area = geometricGrid.getGridShape(point, n);
        } else {
            area = new Area(new Ellipse2D.Double(point.x - n, point.y - n, n * 2, n * 2));
        }
        return area;
    }

    protected int getRadius() {
        if (this.fixedRadius) {
            return this.radius;
        }
        try {
            String string = (String)Decorator.getOutermost(this).getProperty(this.radiusMarker);
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    protected KeyCommand[] myGetKeyCommands() {
        if (this.commands == null) {
            this.commands = this.alwaysActive || this.activateCommand.length() == 0 ? new KeyCommand[0] : new KeyCommand[]{this.keyCommand};
        }
        return this.commands;
    }

    public Command myKeyEvent(KeyStroke keyStroke) {
        Command command = null;
        this.myGetKeyCommands();
        if (!this.alwaysActive && this.keyCommand.matches(keyStroke)) {
            ChangeTracker changeTracker = new ChangeTracker(this);
            this.active = !this.active;
            command = changeTracker.getChangeCommand();
        }
        return command;
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("AreaOfEffect.htm");
    }

    public PieceEditor getEditor() {
        return new TraitEditor(this);
    }

    public Area getArea(MapShader mapShader) {
        Area area = null;
        MapShader.ShadedPiece shadedPiece = (MapShader.ShadedPiece)((Object)Decorator.getDecorator(this.piece, class$VASSAL$build$module$map$MapShader$ShadedPiece == null ? (class$VASSAL$build$module$map$MapShader$ShadedPiece = AreaOfEffect.class$("VASSAL.build.module.map.MapShader$ShadedPiece")) : class$VASSAL$build$module$map$MapShader$ShadedPiece));
        if (shadedPiece != null) {
            area = shadedPiece.getArea(mapShader);
        }
        if ((this.alwaysActive || this.active) && mapShader.getConfigureName().equals(this.mapShaderName)) {
            Area area2 = this.getArea();
            if (area == null) {
                area = area2;
            } else {
                area.add(area2);
            }
        }
        return area;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static class TraitEditor
    implements PieceEditor {
        protected JPanel panel = new JPanel();
        protected ColorConfigurer transparencyColorValue;
        protected IntConfigurer transparencyValue;
        protected IntConfigurer radiusValue;
        protected BooleanConfigurer alwaysActive;
        protected StringConfigurer activateCommand;
        protected HotKeyConfigurer activateKey;
        protected BooleanConfigurer useMapShader;
        protected BooleanConfigurer fixedRadius;
        protected StringConfigurer radiusMarker;
        protected StringConfigurer descConfig;
        protected Box selectShader;
        protected String mapShaderId;

        protected TraitEditor(AreaOfEffect areaOfEffect) {
            this.panel.setLayout(new BoxLayout(this.panel, 1));
            this.panel.add(new JLabel("Contributed by Scott Giese (sgiese@sprintmail.com)", 0));
            this.panel.add(new JSeparator());
            this.panel.add(new JLabel(" "));
            this.descConfig = new StringConfigurer(null, "Description:  ", areaOfEffect.description);
            this.panel.add(this.descConfig.getControls());
            this.useMapShader = new BooleanConfigurer(null, "Use Map Shading", areaOfEffect.mapShaderName != null);
            this.mapShaderId = areaOfEffect.mapShaderName;
            this.panel.add(this.useMapShader.getControls());
            this.selectShader = Box.createHorizontalBox();
            this.panel.add(this.selectShader);
            JLabel jLabel = new JLabel("Map Shading:  ");
            this.selectShader.add(jLabel);
            JTextField jTextField = new JTextField(12);
            jTextField.setEditable(false);
            this.selectShader.add(jTextField);
            jTextField.setText(areaOfEffect.mapShaderName);
            JButton jButton = new JButton("Select");
            this.selectShader.add(jButton);
            jButton.addActionListener(new ActionListener(this, jTextField){
                private final /* synthetic */ JTextField val$tf;
                private final /* synthetic */ TraitEditor this$0;
                {
                    this.this$0 = traitEditor;
                    this.val$tf = jTextField;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    ChooseComponentDialog chooseComponentDialog = new ChooseComponentDialog((Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame == null ? (class$java$awt$Frame = AreaOfEffect.class$("java.awt.Frame")) : class$java$awt$Frame, this.this$0.panel), class$VASSAL$build$module$map$MapShader == null ? (class$VASSAL$build$module$map$MapShader = AreaOfEffect.class$("VASSAL.build.module.map.MapShader")) : class$VASSAL$build$module$map$MapShader);
                    ((Component)chooseComponentDialog).setVisible(true);
                    if (chooseComponentDialog.getTarget() != null) {
                        this.this$0.mapShaderId = chooseComponentDialog.getTarget().getConfigureName();
                        this.val$tf.setText(this.this$0.mapShaderId);
                    } else {
                        this.this$0.mapShaderId = null;
                        this.val$tf.setText("");
                    }
                }
            });
            this.transparencyColorValue = new ColorConfigurer(null, "Fill Color: ", areaOfEffect.transparencyColor);
            this.panel.add(this.transparencyColorValue.getControls());
            this.transparencyValue = new IntConfigurer(null, "Opacity (%): ", new Integer((int)(areaOfEffect.transparencyLevel * 100.0f)));
            this.panel.add(this.transparencyValue.getControls());
            this.fixedRadius = new BooleanConfigurer(null, "Fixed Radius?", new Boolean(areaOfEffect.fixedRadius));
            this.fixedRadius.addPropertyChangeListener(new PropertyChangeListener(this){
                private final /* synthetic */ TraitEditor this$0;
                {
                    this.this$0 = traitEditor;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    this.this$0.updateRangeVisibility();
                }
            });
            this.panel.add(this.fixedRadius.getControls());
            this.radiusValue = new IntConfigurer(null, "Radius: ", new Integer(areaOfEffect.radius));
            this.panel.add(this.radiusValue.getControls());
            this.radiusMarker = new StringConfigurer(null, "Radius Marker: ", areaOfEffect.radiusMarker);
            this.panel.add(this.radiusMarker.getControls());
            this.alwaysActive = new BooleanConfigurer(null, "Always visible", areaOfEffect.alwaysActive ? Boolean.TRUE : Boolean.FALSE);
            this.activateCommand = new StringConfigurer(null, "Toggle visible command: ", areaOfEffect.activateCommand);
            this.activateKey = new HotKeyConfigurer(null, "Toggle visible keyboard shortcut: ", areaOfEffect.activateKey);
            this.updateRangeVisibility();
            this.alwaysActive.addPropertyChangeListener(new PropertyChangeListener(this){
                private final /* synthetic */ TraitEditor this$0;
                {
                    this.this$0 = traitEditor;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    this.this$0.updateCommandVisibility();
                }
            });
            this.updateCommandVisibility();
            this.useMapShader.addPropertyChangeListener(new PropertyChangeListener(this){
                private final /* synthetic */ TraitEditor this$0;
                {
                    this.this$0 = traitEditor;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    this.this$0.updateFillVisibility();
                }
            });
            this.updateFillVisibility();
            this.panel.add(this.alwaysActive.getControls());
            this.panel.add(this.activateCommand.getControls());
            this.panel.add(this.activateKey.getControls());
        }

        protected void updateFillVisibility() {
            boolean bl = Boolean.TRUE.equals(this.useMapShader.getValue());
            this.transparencyColorValue.getControls().setVisible(!bl);
            this.transparencyValue.getControls().setVisible(!bl);
            this.selectShader.setVisible(bl);
            this.repack();
        }

        protected void updateRangeVisibility() {
            boolean bl = this.fixedRadius.booleanValue();
            this.radiusValue.getControls().setVisible(bl);
            this.radiusMarker.getControls().setVisible(!bl);
            this.repack();
        }

        protected void updateCommandVisibility() {
            boolean bl = Boolean.TRUE.equals(this.alwaysActive.getValue());
            this.activateCommand.getControls().setVisible(!bl);
            this.activateKey.getControls().setVisible(!bl);
            this.repack();
        }

        protected void repack() {
            Window window = SwingUtilities.getWindowAncestor(this.alwaysActive.getControls());
            if (window != null) {
                window.pack();
            }
        }

        public Component getControls() {
            return this.panel;
        }

        public String getState() {
            return "false";
        }

        public String getType() {
            boolean bl = Boolean.TRUE.equals(this.alwaysActive.getValue());
            SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
            sequenceEncoder.append(this.transparencyColorValue.getValueString());
            sequenceEncoder.append(this.transparencyValue.getValueString());
            sequenceEncoder.append(this.radiusValue.getValueString());
            sequenceEncoder.append(bl);
            sequenceEncoder.append(this.activateCommand.getValueString());
            sequenceEncoder.append((KeyStroke)this.activateKey.getValue());
            if (Boolean.TRUE.equals(this.useMapShader.getValue()) && this.mapShaderId != null) {
                sequenceEncoder.append(this.mapShaderId);
            } else {
                sequenceEncoder.append("");
            }
            sequenceEncoder.append(this.fixedRadius.getValueString());
            sequenceEncoder.append(this.radiusMarker.getValueString());
            sequenceEncoder.append(this.descConfig.getValueString());
            return AreaOfEffect.ID + sequenceEncoder.getValue();
        }
    }
}

