/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.counters.GamePiece;
import VASSAL.counters.Highlighter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class ColoredBorder
implements Highlighter {
    protected Color c;
    protected int thickness;
    protected ArrayList highlighters = new ArrayList();

    public ColoredBorder() {
        this(Color.black, 3);
    }

    public ColoredBorder(Color color, int n) {
        this.c = color;
        this.thickness = n;
    }

    public void addHighlighter(Highlighter highlighter) {
        this.highlighters.add(highlighter);
    }

    public void removeHighlighter(Highlighter highlighter) {
        ((AbstractCollection)this.highlighters).remove(highlighter);
    }

    public void draw(GamePiece gamePiece, Graphics graphics, int n, int n2, Component component, double d) {
        Object object;
        Object object2;
        if (this.c != null || this.thickness > 0) {
            if (graphics instanceof Graphics2D) {
                object2 = (Graphics2D)graphics;
                object = ((Graphics2D)object2).getStroke();
                ((Graphics2D)object2).setStroke(new BasicStroke(Math.max(1L, Math.round(d * (double)this.thickness))));
                ((Graphics)object2).setColor(this.c);
                Shape shape = gamePiece.getShape();
                Rectangle rectangle = shape.getBounds();
                double d2 = (rectangle.getWidth() + 1.0) / rectangle.getWidth();
                double d3 = (rectangle.getHeight() + 1.0) / rectangle.getHeight();
                AffineTransform affineTransform = AffineTransform.getTranslateInstance(n, n2);
                affineTransform.scale(d2 * d, d3 * d);
                ((Graphics2D)object2).draw(affineTransform.createTransformedShape(shape));
                ((Graphics2D)object2).setStroke((Stroke)object);
            } else {
                this.highlightSelectionBounds(gamePiece, graphics, n, n2, component, d);
            }
        }
        object2 = ((AbstractList)this.highlighters).iterator();
        while (object2.hasNext()) {
            object = (Highlighter)object2.next();
            object.draw(gamePiece, graphics, n, n2, component, d);
        }
    }

    protected void highlightSelectionBounds(GamePiece gamePiece, Graphics graphics, int n, int n2, Component component, double d) {
        Rectangle rectangle = gamePiece.getShape().getBounds();
        graphics.setColor(this.c);
        for (int i = 1; i < this.thickness; ++i) {
            graphics.drawRect(n + (int)(d * (double)rectangle.x) - i, n2 + (int)(d * (double)rectangle.y) - i, (int)(d * (double)rectangle.width) + 2 * i - 1, (int)(d * (double)rectangle.height) + 2 * i - 1);
        }
    }

    public Rectangle boundingBox(GamePiece gamePiece) {
        Rectangle rectangle = gamePiece.getShape().getBounds();
        rectangle.translate(-this.thickness, -this.thickness);
        rectangle.setSize(rectangle.width + 2 * this.thickness, rectangle.height + 2 * this.thickness);
        Iterator iterator = ((AbstractList)this.highlighters).iterator();
        while (iterator.hasNext()) {
            Highlighter highlighter = (Highlighter)iterator.next();
            rectangle = rectangle.union(highlighter.boundingBox(gamePiece));
        }
        return rectangle;
    }

    public void setColor(Color color) {
        this.c = color;
    }

    public Color getColor() {
        return this.c;
    }

    public int getThickness() {
        return this.thickness;
    }

    public void setThickness(int n) {
        this.thickness = n;
    }
}

