/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.MassKeyCommand;
import VASSAL.command.Command;
import VASSAL.command.NullCommand;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.HotKeyConfigurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.BooleanAndPieceFilter;
import VASSAL.counters.Decorator;
import VASSAL.counters.EditablePiece;
import VASSAL.counters.GamePiece;
import VASSAL.counters.GlobalCommand;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.PieceFilter;
import VASSAL.counters.PropertiesPieceFilter;
import VASSAL.counters.RangeFilter;
import VASSAL.tools.FormattedString;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class CounterGlobalKeyCommand
extends Decorator
implements EditablePiece {
    public static final String ID = "globalkey;";
    protected KeyCommand[] command;
    protected String commandName;
    protected KeyStroke key;
    protected KeyStroke globalKey;
    protected GlobalCommand globalCommand = new GlobalCommand();
    protected String propertiesFilter;
    protected boolean restrictRange;
    protected boolean fixedRange = true;
    protected int range;
    protected String rangeProperty = "";
    private KeyCommand myCommand;
    protected String description;

    public CounterGlobalKeyCommand() {
        this(ID, null);
    }

    public CounterGlobalKeyCommand(String string, GamePiece gamePiece) {
        this.mySetType(string);
        this.setInner(gamePiece);
    }

    public void mySetType(String string) {
        string = string.substring(ID.length());
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        this.commandName = decoder.nextToken("Global Command");
        this.key = decoder.nextKeyStroke('G');
        this.globalKey = decoder.nextKeyStroke('K');
        this.propertiesFilter = decoder.nextToken("");
        this.restrictRange = decoder.nextBoolean(false);
        this.range = decoder.nextInt(1);
        this.globalCommand.setReportSingle(decoder.nextBoolean(true));
        this.globalCommand.setKeyStroke(this.globalKey);
        this.fixedRange = decoder.nextBoolean(true);
        this.rangeProperty = decoder.nextToken("");
        this.description = decoder.nextToken("");
        this.globalCommand.setSelectFromDeck(decoder.nextInt(-1));
        this.command = null;
    }

    public String myGetType() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
        sequenceEncoder.append(this.commandName).append(this.key).append(this.globalKey).append(this.propertiesFilter).append(this.restrictRange).append(this.range).append(this.globalCommand.isReportSingle()).append(this.fixedRange).append(this.rangeProperty).append(this.description).append(this.globalCommand.getSelectFromDeck());
        return ID + sequenceEncoder.getValue();
    }

    protected KeyCommand[] myGetKeyCommands() {
        if (this.command == null) {
            this.myCommand = new KeyCommand(this.commandName, this.key, Decorator.getOutermost(this));
            this.command = this.commandName.length() > 0 && this.key != null ? new KeyCommand[]{this.myCommand} : new KeyCommand[0];
        }
        if (this.command.length > 0) {
            this.command[0].setEnabled(this.restrictRange || this.getMap() != null);
        }
        return this.command;
    }

    public String myGetState() {
        return "";
    }

    public Command myKeyEvent(KeyStroke keyStroke) {
        Command command = null;
        this.myGetKeyCommands();
        if (this.myCommand.matches(keyStroke)) {
            this.apply();
        }
        return command;
    }

    public void mySetState(String string) {
    }

    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    public void draw(Graphics graphics, int n, int n2, Component component, double d) {
        this.piece.draw(graphics, n, n2, component, d);
    }

    public String getName() {
        return this.piece.getName();
    }

    public Shape getShape() {
        return this.piece.getShape();
    }

    public PieceEditor getEditor() {
        return new Ed(this);
    }

    public String getDescription() {
        String string = "Global Key Command";
        if (this.description.length() > 0) {
            string = string + " - " + this.description;
        }
        return string;
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GlobalKeyCommand.htm");
    }

    public void apply() {
        PieceFilter pieceFilter = PropertiesPieceFilter.parse(new FormattedString(this.propertiesFilter).getText(Decorator.getOutermost(this)));
        Command command = new NullCommand();
        if (this.restrictRange) {
            int n = this.range;
            if (!this.fixedRange) {
                try {
                    n = Integer.parseInt((String)Decorator.getOutermost(this).getProperty(this.rangeProperty));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            pieceFilter = new BooleanAndPieceFilter(pieceFilter, new RangeFilter(this.getMap(), this.getPosition(), n));
        }
        Iterator iterator = Map.getAllMaps();
        while (iterator.hasNext()) {
            Map map = (Map)iterator.next();
            command = command.append(this.globalCommand.apply(map, pieceFilter));
        }
        GameModule.getGameModule().sendAndLog(command);
    }

    public static class Ed
    implements PieceEditor {
        protected StringConfigurer nameInput;
        protected HotKeyConfigurer keyInput;
        protected HotKeyConfigurer globalKey;
        protected StringConfigurer propertyMatch;
        protected MassKeyCommand.DeckPolicyConfig deckPolicy;
        protected BooleanConfigurer suppress;
        protected BooleanConfigurer restrictRange;
        protected BooleanConfigurer fixedRange;
        protected IntConfigurer range;
        protected StringConfigurer rangeProperty;
        protected StringConfigurer descInput;
        protected JPanel controls;

        public Ed(CounterGlobalKeyCommand counterGlobalKeyCommand) {
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(this){
                private final /* synthetic */ Ed this$0;
                {
                    this.this$0 = ed;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    boolean bl = Boolean.TRUE.equals(this.this$0.restrictRange.getValue());
                    boolean bl2 = Boolean.TRUE.equals(this.this$0.fixedRange.getValue());
                    this.this$0.range.getControls().setVisible(bl && bl2);
                    this.this$0.fixedRange.getControls().setVisible(bl);
                    this.this$0.rangeProperty.getControls().setVisible(bl && !bl2);
                    Window window = SwingUtilities.getWindowAncestor(this.this$0.range.getControls());
                    if (window != null) {
                        window.pack();
                    }
                }
            };
            this.controls = new JPanel();
            this.controls.setLayout(new BoxLayout(this.controls, 1));
            this.descInput = new StringConfigurer(null, "Description:  ", counterGlobalKeyCommand.description);
            this.controls.add(this.descInput.getControls());
            this.nameInput = new StringConfigurer(null, "Command name:  ", counterGlobalKeyCommand.commandName);
            this.controls.add(this.nameInput.getControls());
            this.keyInput = new HotKeyConfigurer(null, "Keyboard Command:  ", counterGlobalKeyCommand.key);
            this.controls.add(this.keyInput.getControls());
            this.globalKey = new HotKeyConfigurer(null, "Global Key Command:  ", counterGlobalKeyCommand.globalKey);
            this.controls.add(this.globalKey.getControls());
            this.propertyMatch = new StringConfigurer(null, "Matching Properties:  ", counterGlobalKeyCommand.propertiesFilter);
            this.controls.add(this.propertyMatch.getControls());
            this.deckPolicy = new MassKeyCommand.DeckPolicyConfig();
            this.deckPolicy.setValue(new Integer(counterGlobalKeyCommand.globalCommand.getSelectFromDeck()));
            this.controls.add(this.deckPolicy.getControls());
            this.restrictRange = new BooleanConfigurer(null, "Restrict Range?", counterGlobalKeyCommand.restrictRange);
            this.controls.add(this.restrictRange.getControls());
            this.restrictRange.addPropertyChangeListener(propertyChangeListener);
            this.fixedRange = new BooleanConfigurer(null, "Fixed Range?", counterGlobalKeyCommand.fixedRange);
            this.controls.add(this.fixedRange.getControls());
            this.fixedRange.addPropertyChangeListener(propertyChangeListener);
            this.range = new IntConfigurer(null, "Range:  ", new Integer(counterGlobalKeyCommand.range));
            this.controls.add(this.range.getControls());
            this.rangeProperty = new StringConfigurer(null, "Range Property:  ", counterGlobalKeyCommand.rangeProperty);
            this.controls.add(this.rangeProperty.getControls());
            this.suppress = new BooleanConfigurer(null, "Suppress individual reports", counterGlobalKeyCommand.globalCommand.isReportSingle());
            this.controls.add(this.suppress.getControls());
            propertyChangeListener.propertyChange(null);
        }

        public Component getControls() {
            return this.controls;
        }

        public String getType() {
            SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
            sequenceEncoder.append(this.nameInput.getValueString()).append((KeyStroke)this.keyInput.getValue()).append((KeyStroke)this.globalKey.getValue()).append(this.propertyMatch.getValueString()).append(this.restrictRange.getValueString()).append(this.range.getValueString()).append(this.suppress.booleanValue()).append(this.fixedRange.booleanValue()).append(this.rangeProperty.getValueString()).append(this.descInput.getValueString()).append(this.deckPolicy.getIntValue());
            return CounterGlobalKeyCommand.ID + sequenceEncoder.getValue();
        }

        public String getState() {
            return "";
        }
    }
}

