/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.Map;
import VASSAL.build.module.map.DrawPile;
import VASSAL.command.AddPiece;
import VASSAL.command.ChangeTracker;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.command.NullCommand;
import VASSAL.configure.ColorConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.DragBuffer;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceIterator;
import VASSAL.counters.Stack;
import VASSAL.tools.FileChooser;
import VASSAL.tools.FormattedString;
import VASSAL.tools.KeyStrokeListener;
import VASSAL.tools.ScrollPane;
import VASSAL.tools.SequenceEncoder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class Deck
extends Stack {
    public static final String ID = "deck;";
    public static final String ALWAYS = "Always";
    public static final String NEVER = "Never";
    public static final String USE_MENU = "Via right-click Menu";
    protected static final String NO_USER = "nobody";
    protected boolean drawOutline = true;
    protected Color outlineColor = Color.black;
    protected Dimension size = new Dimension(40, 40);
    protected boolean shuffle = true;
    protected String faceDownOption = "Always";
    protected String shuffleOption = "Always";
    protected boolean allowMultipleDraw = false;
    protected boolean allowSelectDraw = false;
    protected boolean reversible = false;
    protected String reshuffleCommand = "";
    protected String reshuffleTarget;
    protected String reshuffleMsgFormat;
    protected KeyStrokeListener reshuffleListener;
    protected KeyStroke reshuffleKey;
    protected String reverseMsgFormat;
    protected String shuffleMsgFormat;
    protected KeyStrokeListener shuffleListener;
    protected KeyStroke shuffleKey;
    protected String faceDownMsgFormat;
    protected boolean drawFaceUp;
    protected boolean persistable;
    protected String deckName;
    protected boolean faceDown;
    protected int dragCount = 0;
    protected ArrayList nextDraw;
    protected KeyCommand[] commands;
    protected CommandEncoder commandEncoder = new CommandEncoder(){

        public Command decode(String string) {
            LoadDeckCommand loadDeckCommand = null;
            if (string.startsWith("DECK\t")) {
                loadDeckCommand = new LoadDeckCommand(Deck.this);
            }
            return loadDeckCommand;
        }

        public String encode(Command command) {
            String string = null;
            if (command instanceof LoadDeckCommand) {
                string = "DECK\t";
            }
            return string;
        }
    };
    static /* synthetic */ Class class$java$awt$Frame;

    public Deck() {
        this(ID);
    }

    public Deck(String string) {
        this.mySetType(string);
    }

    protected void fireNumCardsProperty() {
        if (this.getMap() != null) {
            this.getMap().getPropertyListener().propertyChange(new PropertyChangeEvent(this, this.deckName + "_numPieces", null, String.valueOf(this.pieceCount)));
        }
    }

    protected void insertPieceAt(GamePiece gamePiece, int n) {
        super.insertPieceAt(gamePiece, n);
        this.fireNumCardsProperty();
    }

    protected void removePieceAt(int n) {
        super.removePieceAt(n);
        this.fireNumCardsProperty();
    }

    public void removeAll() {
        super.removeAll();
        this.fireNumCardsProperty();
    }

    public void setMap(Map map) {
        super.setMap(map);
        this.fireNumCardsProperty();
    }

    protected void mySetType(String string) {
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        decoder.nextToken();
        this.drawOutline = decoder.nextBoolean(true);
        this.outlineColor = ColorConfigurer.stringToColor(decoder.nextToken("0,0,0"));
        this.size.setSize(decoder.nextInt(40), decoder.nextInt(40));
        this.faceDownOption = decoder.nextToken(ALWAYS);
        this.shuffleOption = decoder.nextToken(ALWAYS);
        this.allowMultipleDraw = decoder.nextBoolean(true);
        this.allowSelectDraw = decoder.nextBoolean(true);
        this.reversible = decoder.nextBoolean(true);
        this.reshuffleCommand = decoder.nextToken("");
        this.reshuffleTarget = decoder.nextToken("");
        this.reshuffleMsgFormat = decoder.nextToken("");
        this.deckName = decoder.nextToken("Deck");
        this.shuffleMsgFormat = decoder.nextToken("");
        this.reverseMsgFormat = decoder.nextToken("");
        this.faceDownMsgFormat = decoder.nextToken("");
        this.drawFaceUp = decoder.nextBoolean(false);
        this.persistable = decoder.nextBoolean(false);
        this.shuffleKey = decoder.nextKeyStroke(null);
        this.reshuffleKey = decoder.nextKeyStroke(null);
        if (this.shuffleListener == null) {
            this.shuffleListener = new KeyStrokeListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    GameModule.getGameModule().sendAndLog(Deck.this.shuffle());
                    Deck.this.map.repaint();
                }
            });
            GameModule.getGameModule().addKeyStrokeListener(this.shuffleListener);
        }
        this.shuffleListener.setKeyStroke(this.getShuffleKey());
        if (this.reshuffleListener == null) {
            this.reshuffleListener = new KeyStrokeListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    GameModule.getGameModule().sendAndLog(Deck.this.sendToDeck());
                    Deck.this.map.repaint();
                }
            });
            GameModule.getGameModule().addKeyStrokeListener(this.reshuffleListener);
        }
        this.reshuffleListener.setKeyStroke(this.getReshuffleKey());
    }

    public String getFaceDownOption() {
        return this.faceDownOption;
    }

    public boolean isDrawFaceUp() {
        return this.drawFaceUp;
    }

    public void setDrawFaceUp(boolean bl) {
        this.drawFaceUp = bl;
    }

    public void setFaceDownOption(String string) {
        this.faceDownOption = string;
        this.faceDown = !string.equals(NEVER);
    }

    public Dimension getSize() {
        return this.size;
    }

    public void setSize(Dimension dimension) {
        this.size.setSize(dimension);
    }

    public String getShuffleOption() {
        return this.shuffleOption;
    }

    public void setShuffleOption(String string) {
        this.shuffleOption = string;
    }

    public boolean isShuffle() {
        return this.shuffle;
    }

    public String getFaceDownMsgFormat() {
        return this.faceDownMsgFormat;
    }

    public void setFaceDownMsgFormat(String string) {
        this.faceDownMsgFormat = string;
    }

    public String getReverseMsgFormat() {
        return this.reverseMsgFormat;
    }

    public void setReverseMsgFormat(String string) {
        this.reverseMsgFormat = string;
    }

    public String getShuffleMsgFormat() {
        return this.shuffleMsgFormat;
    }

    public void setShuffleMsgFormat(String string) {
        this.shuffleMsgFormat = string;
    }

    public KeyStroke getShuffleKey() {
        return this.shuffleKey;
    }

    public void setShuffleKey(KeyStroke keyStroke) {
        this.shuffleKey = keyStroke;
    }

    public void setShuffle(boolean bl) {
        this.shuffle = bl;
    }

    public boolean isAllowMultipleDraw() {
        return this.allowMultipleDraw;
    }

    public void setAllowMultipleDraw(boolean bl) {
        this.allowMultipleDraw = bl;
    }

    public boolean isAllowSelectDraw() {
        return this.allowSelectDraw;
    }

    public void setAllowSelectDraw(boolean bl) {
        this.allowSelectDraw = bl;
    }

    public boolean isReversible() {
        return this.reversible;
    }

    public void setReversible(boolean bl) {
        this.reversible = bl;
    }

    public void setDeckName(String string) {
        this.deckName = string;
    }

    public String getDeckName() {
        return this.deckName;
    }

    public String getReshuffleCommand() {
        return this.reshuffleCommand;
    }

    public void setReshuffleCommand(String string) {
        this.reshuffleCommand = string;
    }

    public KeyStroke getReshuffleKey() {
        return this.reshuffleKey;
    }

    public void setReshuffleKey(KeyStroke keyStroke) {
        this.reshuffleKey = keyStroke;
    }

    public String getReshuffleTarget() {
        return this.reshuffleTarget;
    }

    public void setReshuffleTarget(String string) {
        this.reshuffleTarget = string;
    }

    public String getReshuffleMsgFormat() {
        return this.reshuffleMsgFormat;
    }

    public void setReshuffleMsgFormat(String string) {
        this.reshuffleMsgFormat = string;
    }

    public String getType() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
        sequenceEncoder.append(this.drawOutline).append(ColorConfigurer.colorToString(this.outlineColor)).append(String.valueOf(this.size.width)).append(String.valueOf(this.size.height)).append(this.faceDownOption).append(this.shuffleOption).append(String.valueOf(this.allowMultipleDraw)).append(String.valueOf(this.allowSelectDraw)).append(String.valueOf(this.reversible)).append(this.reshuffleCommand).append(this.reshuffleTarget).append(this.reshuffleMsgFormat).append(this.deckName).append(this.shuffleMsgFormat).append(this.reverseMsgFormat).append(this.faceDownMsgFormat).append(this.drawFaceUp).append(this.persistable).append(this.shuffleKey).append(this.reshuffleKey);
        return ID + sequenceEncoder.getValue();
    }

    public Command shuffle() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < this.getPieceCount(); ++i) {
            arrayList.add(new Integer(i));
        }
        ArrayList<GamePiece> arrayList2 = new ArrayList<GamePiece>();
        DragBuffer.getBuffer().clear();
        for (int i = this.getPieceCount(); i > 0; --i) {
            int n = (int)(GameModule.getGameModule().getRNG().nextFloat() * (float)arrayList.size());
            int n2 = (Integer)arrayList.get(n);
            arrayList.remove(n);
            arrayList2.add(this.getPieceAt(n2));
        }
        return this.setContents(((AbstractList)arrayList2).iterator()).append(this.reportCommand(this.shuffleMsgFormat, "Shuffle"));
    }

    public PieceIterator drawCards() {
        Iterator iterator;
        if (this.nextDraw != null) {
            iterator = ((AbstractList)this.nextDraw).iterator();
        } else if (this.getPieceCount() == 0) {
            iterator = Collections.EMPTY_LIST.iterator();
        } else {
            int n = Math.max(this.dragCount, Math.min(1, this.getPieceCount()));
            ArrayList<GamePiece> arrayList = new ArrayList<GamePiece>();
            if (ALWAYS.equals(this.shuffleOption)) {
                int n2;
                ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
                for (n2 = 0; n2 < this.getPieceCount(); ++n2) {
                    arrayList2.add(new Integer(n2));
                }
                while (n-- > 0 && arrayList2.size() > 0) {
                    n2 = GameModule.getGameModule().getRNG().nextInt(arrayList2.size());
                    int n3 = (Integer)arrayList2.get(n2);
                    arrayList2.remove(n2);
                    GamePiece gamePiece = this.getPieceAt(n3);
                    arrayList.add(gamePiece);
                }
            } else {
                Enumeration enumeration = this.getPiecesInReverseOrder();
                while (n-- > 0 && enumeration.hasMoreElements()) {
                    GamePiece gamePiece = (GamePiece)enumeration.nextElement();
                    arrayList.add(gamePiece);
                }
            }
            iterator = ((AbstractList)arrayList).iterator();
        }
        this.dragCount = 0;
        this.nextDraw = null;
        return new PieceIterator(iterator){

            public GamePiece nextPiece() {
                GamePiece gamePiece = super.nextPiece();
                if (Deck.this.faceDown) {
                    gamePiece.setProperty("obs;", Deck.NO_USER);
                }
                return gamePiece;
            }
        };
    }

    protected Command setContents(Iterator iterator) {
        ChangeTracker changeTracker = new ChangeTracker(this);
        this.removeAll();
        while (iterator.hasNext()) {
            GamePiece gamePiece = (GamePiece)iterator.next();
            this.insertChild(gamePiece, this.pieceCount);
        }
        return changeTracker.getChangeCommand();
    }

    public String getState() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
        sequenceEncoder.append(this.getMap() == null ? "null" : this.getMap().getIdentifier()).append(this.getPosition().x).append(this.getPosition().y);
        sequenceEncoder.append(this.faceDown);
        SequenceEncoder sequenceEncoder2 = new SequenceEncoder(',');
        Enumeration enumeration = this.getPieces();
        while (enumeration.hasMoreElements()) {
            GamePiece gamePiece = (GamePiece)enumeration.nextElement();
            sequenceEncoder2.append(gamePiece.getId());
        }
        if (sequenceEncoder2.getValue() != null) {
            sequenceEncoder.append(sequenceEncoder2.getValue());
        }
        return sequenceEncoder.getValue();
    }

    public void setState(String string) {
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        String string2 = decoder.nextToken();
        this.setPosition(new Point(decoder.nextInt(0), decoder.nextInt(0)));
        Map map = null;
        if (!"null".equals(string2) && (map = Map.getMapById(string2)) == null) {
            throw new RuntimeException("Could not find map " + string2);
        }
        if (map != this.getMap()) {
            if (map != null) {
                map.addPiece(this);
            } else {
                this.setMap(null);
            }
        }
        this.faceDown = "true".equals(decoder.nextToken());
        ArrayList<GamePiece> arrayList = new ArrayList<GamePiece>();
        if (decoder.hasMoreTokens()) {
            SequenceEncoder.Decoder decoder2 = new SequenceEncoder.Decoder(decoder.nextToken(), ',');
            while (decoder2.hasMoreTokens()) {
                GamePiece gamePiece = GameModule.getGameModule().getGameState().getPieceForId(decoder2.nextToken());
                if (gamePiece == null) continue;
                arrayList.add(gamePiece);
            }
        }
        this.setContents(((AbstractList)arrayList).iterator());
        this.commands = null;
    }

    public Command setContentsFaceDown(boolean bl) {
        ChangeTracker changeTracker = new ChangeTracker(this);
        NullCommand nullCommand = new NullCommand();
        this.faceDown = bl;
        return changeTracker.getChangeCommand().append(nullCommand).append(this.reportCommand(this.faceDownMsgFormat, bl ? "Face Down" : "Face Up"));
    }

    public Command reverse() {
        ArrayList arrayList = new ArrayList();
        Enumeration enumeration = this.getPiecesInReverseOrder();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        return this.setContents(((AbstractList)arrayList).iterator()).append(this.reportCommand(this.reverseMsgFormat, "Reverse"));
    }

    public boolean isDrawOutline() {
        return this.drawOutline;
    }

    public void setOutlineColor(Color color) {
        this.outlineColor = color;
    }

    public void setDrawOutline(boolean bl) {
        this.drawOutline = bl;
    }

    public Color getOutlineColor() {
        return this.outlineColor;
    }

    public boolean isFaceDown() {
        return this.faceDown;
    }

    public Command pieceAdded(GamePiece gamePiece) {
        return null;
    }

    public Command pieceRemoved(GamePiece gamePiece) {
        ChangeTracker changeTracker = new ChangeTracker(gamePiece);
        gamePiece.setProperty("obs;", this.isFaceDown() && !this.isDrawFaceUp() ? GameModule.getUserId() : null);
        return changeTracker.getChangeCommand();
    }

    public void setFaceDown(boolean bl) {
        this.faceDown = bl;
    }

    public void draw(Graphics graphics, int n, int n2, Component component, double d) {
        GamePiece gamePiece;
        int n3 = Math.min(this.getPieceCount(), 10);
        GamePiece gamePiece2 = gamePiece = this.nextDraw != null ? (GamePiece)this.nextDraw.get(0) : this.topPiece();
        if (gamePiece != null) {
            Object object = gamePiece.getProperty("obs;");
            gamePiece.setProperty("obs;", this.faceDown ? NO_USER : null);
            Color color = this.getBlankColor();
            Rectangle rectangle = gamePiece.getShape().getBounds();
            rectangle.setLocation(n + (int)(d * (double)rectangle.x), n2 + (int)(d * (double)rectangle.y));
            rectangle.setSize((int)(d * (double)rectangle.width), (int)(d * (double)rectangle.height));
            for (int i = 0; i < n3 - 1; ++i) {
                if (color != null) {
                    graphics.setColor(color);
                    graphics.fillRect(rectangle.x + (int)(d * 2.0 * (double)i), rectangle.y - (int)(d * 2.0 * (double)i), rectangle.width, rectangle.height);
                    graphics.setColor(Color.black);
                    graphics.drawRect(rectangle.x + (int)(d * 2.0 * (double)i), rectangle.y - (int)(d * 2.0 * (double)i), rectangle.width, rectangle.height);
                    continue;
                }
                if (this.faceDown) {
                    gamePiece.draw(graphics, n + (int)(d * 2.0 * (double)i), n2 - (int)(d * 2.0 * (double)i), component, d);
                    continue;
                }
                this.getPieceAt(n3 - i - 1).draw(graphics, n + (int)(d * 2.0 * (double)i), n2 - (int)(d * 2.0 * (double)i), component, d);
            }
            gamePiece.draw(graphics, n + (int)(d * 2.0 * (double)(n3 - 1)), n2 - (int)(d * 2.0 * (double)(n3 - 1)), component, d);
            gamePiece.setProperty("obs;", object);
        } else if (this.drawOutline) {
            Rectangle rectangle = this.boundingBox();
            rectangle.setLocation(n + (int)(d * (double)rectangle.x), n2 + (int)(d * (double)rectangle.y));
            rectangle.setSize((int)(d * (double)rectangle.width), (int)(d * (double)rectangle.height));
            graphics.setColor(this.outlineColor);
            graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    protected Color getBlankColor() {
        Color color = Color.white;
        if (this.getMap() != null) {
            color = this.getMap().getStackMetrics().getBlankColor();
        }
        return color;
    }

    public Rectangle boundingBox() {
        GamePiece gamePiece = this.topPiece();
        Dimension dimension = gamePiece == null ? this.size : gamePiece.getShape().getBounds().getSize();
        Rectangle rectangle = new Rectangle(new Point(), dimension);
        rectangle.translate(-rectangle.width / 2, -rectangle.height / 2);
        return rectangle;
    }

    public Shape getShape() {
        return this.boundingBox();
    }

    public Object getProperty(Object object) {
        KeyCommand[] keyCommandArray = null;
        if ("NoStack".equals(object)) {
            keyCommandArray = Boolean.TRUE;
        } else if ("KeyCommands".equals(object)) {
            keyCommandArray = this.getKeyCommands();
        }
        return keyCommandArray;
    }

    protected KeyCommand[] getKeyCommands() {
        if (this.commands == null) {
            ArrayList<KeyCommand> arrayList = new ArrayList<KeyCommand>();
            KeyCommand keyCommand = null;
            if (USE_MENU.equals(this.shuffleOption)) {
                keyCommand = new KeyCommand("Shuffle", this.getShuffleKey(), this){

                    public void actionPerformed(ActionEvent actionEvent) {
                        GameModule.getGameModule().sendAndLog(Deck.this.shuffle());
                        Deck.this.map.repaint();
                    }
                };
                arrayList.add(keyCommand);
            }
            if (this.reshuffleCommand.length() > 0) {
                keyCommand = new KeyCommand(this.reshuffleCommand, this.getReshuffleKey(), this){

                    public void actionPerformed(ActionEvent actionEvent) {
                        GameModule.getGameModule().sendAndLog(Deck.this.sendToDeck());
                        Deck.this.map.repaint();
                    }
                };
                arrayList.add(keyCommand);
            }
            if (USE_MENU.equals(this.faceDownOption)) {
                KeyCommand keyCommand2 = new KeyCommand(this.faceDown ? "Face up" : "Face down", null, this){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Command command = Deck.this.setContentsFaceDown(!Deck.this.faceDown);
                        GameModule.getGameModule().sendAndLog(command);
                        Deck.this.map.repaint();
                    }
                };
                arrayList.add(keyCommand2);
            }
            if (this.reversible) {
                keyCommand = new KeyCommand("Reverse order", null, this){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Command command = Deck.this.reverse();
                        GameModule.getGameModule().sendAndLog(command);
                        Deck.this.map.repaint();
                    }
                };
                arrayList.add(keyCommand);
            }
            if (this.allowMultipleDraw) {
                keyCommand = new KeyCommand("Draw multiple cards", null, this){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Deck.this.promptForDragCount();
                    }
                };
                arrayList.add(keyCommand);
            }
            if (this.allowSelectDraw) {
                keyCommand = new KeyCommand("Draw specific cards", null, this){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Deck.this.promptForNextDraw();
                        Deck.this.map.repaint();
                    }
                };
                arrayList.add(keyCommand);
            }
            if (this.persistable) {
                keyCommand = new KeyCommand("Save", null, this){

                    public void actionPerformed(ActionEvent actionEvent) {
                        GameModule.getGameModule().sendAndLog(Deck.this.saveDeck());
                        Deck.this.map.repaint();
                    }
                };
                arrayList.add(keyCommand);
                keyCommand = new KeyCommand("Load", null, this){

                    public void actionPerformed(ActionEvent actionEvent) {
                        GameModule.getGameModule().sendAndLog(Deck.this.loadDeck());
                        Deck.this.map.repaint();
                    }
                };
                arrayList.add(keyCommand);
            }
            this.commands = arrayList.toArray(new KeyCommand[arrayList.size()]);
        }
        for (int i = 0; i < this.commands.length; ++i) {
            if ("Face up".equals(this.commands[i].getValue("Name")) && !this.faceDown) {
                this.commands[i].putValue("Name", "Face down");
                continue;
            }
            if (!"Face down".equals(this.commands[i].getValue("Name")) || !this.faceDown) continue;
            this.commands[i].putValue("Name", "Face up");
        }
        return this.commands;
    }

    protected Command reportCommand(String string, String string2) {
        Chatter.DisplayText displayText = null;
        FormattedString formattedString = new FormattedString(string);
        formattedString.setProperty("deckName", this.getDeckName());
        formattedString.setProperty("commandName", string2);
        String string3 = formattedString.getText();
        if (string3.length() > 0) {
            displayText = new Chatter.DisplayText(GameModule.getGameModule().getChatter(), "* " + string3);
            displayText.execute();
        }
        return displayText;
    }

    public void promptForDragCount() {
        String string;
        while ((string = JOptionPane.showInputDialog("Enter number to grab.\nThen click and drag to draw that number.")) != null) {
            try {
                this.dragCount = Integer.parseInt(string);
                this.dragCount = Math.min(this.dragCount, this.getPieceCount());
                if (this.dragCount < 0) continue;
                break;
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
    }

    protected void promptForNextDraw() {
        final JDialog jDialog = new JDialog((Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame == null ? (class$java$awt$Frame = Deck.class$("java.awt.Frame")) : class$java$awt$Frame, this.map.getView()), true);
        jDialog.setTitle("Draw");
        jDialog.getContentPane().setLayout(new BoxLayout(jDialog.getContentPane(), 1));
        final String[] stringArray = new String[this.getPieceCount()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[stringArray.length - i - 1] = Decorator.getInnermost(this.getPieceAt(i)).getName();
        }
        final JList<String> jList = new JList<String>(stringArray);
        jList.setSelectionMode(2);
        jDialog.getContentPane().add(new ScrollPane(jList));
        jDialog.getContentPane().add(new JLabel("Select cards to draw"));
        jDialog.getContentPane().add(new JLabel("Then click and drag from the deck."));
        Box box = Box.createHorizontalBox();
        JButton jButton = new JButton("Ok");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = jList.getSelectedIndices();
                if (nArray.length > 0) {
                    Deck.this.nextDraw = new ArrayList();
                    for (int i = 0; i < nArray.length; ++i) {
                        Deck.this.nextDraw.add(Deck.this.getPieceAt(stringArray.length - nArray[i] - 1));
                    }
                } else {
                    Deck.this.nextDraw = null;
                }
                jDialog.dispose();
            }
        });
        box.add(jButton);
        jButton = new JButton("Cancel");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
            }
        });
        box.add(jButton);
        jDialog.getContentPane().add(box);
        jDialog.pack();
        jDialog.setLocationRelativeTo(jDialog.getOwner());
        ((Component)jDialog).setVisible(true);
    }

    public Command sendToDeck() {
        Command command = null;
        DrawPile drawPile = DrawPile.findDrawPile(this.reshuffleTarget);
        if (drawPile != null) {
            int n;
            if (this.reshuffleMsgFormat.length() > 0) {
                command = this.reportCommand(this.reshuffleMsgFormat, this.reshuffleCommand);
                if (command == null) {
                    command = new NullCommand();
                }
            } else {
                command = new NullCommand();
            }
            for (int i = n = this.getPieceCount() - 1; i >= 0; --i) {
                command.append(drawPile.addToContents(this.getPieceAt(i)));
            }
        }
        return command;
    }

    public boolean isExpanded() {
        return false;
    }

    public boolean isPersistable() {
        return this.persistable;
    }

    public void setPersistable(boolean bl) {
        this.persistable = bl;
    }

    private File getSaveFileName() {
        int n;
        Object object;
        FileChooser fileChooser = GameModule.getGameModule().getFileChooser();
        File file = fileChooser.getSelectedFile();
        if (file != null && (object = file.getPath()) != null && (n = ((String)object).lastIndexOf(46)) > 0) {
            object = ((String)object).substring(0, n) + ".sav";
            fileChooser.setSelectedFile(new File((String)object));
        }
        if (fileChooser.showSaveDialog(this.map.getView()) != 0) {
            return null;
        }
        object = fileChooser.getSelectedFile();
        if (object != null && ((File)object).exists() && this.shouldConfirmOverwrite() && 1 == JOptionPane.showConfirmDialog(GameModule.getGameModule().getFrame(), "Overwrite " + ((File)object).getName() + "?", "File Exists", 0)) {
            object = null;
        }
        return object;
    }

    private boolean shouldConfirmOverwrite() {
        return System.getProperty("os.name").trim().equalsIgnoreCase("linux");
    }

    private Command saveDeck() {
        NullCommand nullCommand = new NullCommand();
        GameModule.getGameModule().warn("Saving deck ...");
        try {
            File file = this.getSaveFileName();
            if (file != null) {
                this.saveDeck(file);
                GameModule.getGameModule().warn("deck Saved");
            } else {
                GameModule.getGameModule().warn("Save Canceled");
            }
        }
        catch (IOException iOException) {
            GameModule.getGameModule().warn("Save Failed.  Try again.");
        }
        return nullCommand;
    }

    public void saveDeck(File file) throws IOException {
        Command command = new LoadDeckCommand(null);
        FileWriter fileWriter = new FileWriter(file);
        Enumeration enumeration = this.getPieces();
        while (enumeration.hasMoreElements()) {
            GamePiece gamePiece = (GamePiece)enumeration.nextElement();
            command = command.append(new AddPiece(gamePiece));
        }
        GameModule.getGameModule().addCommandEncoder(this.commandEncoder);
        fileWriter.write(GameModule.getGameModule().encode(command));
        GameModule.getGameModule().removeCommandEncoder(this.commandEncoder);
        fileWriter.close();
    }

    private File getLoadFileName() {
        FileChooser fileChooser = GameModule.getGameModule().getFileChooser();
        fileChooser.selectDotSavFile();
        if (fileChooser.showOpenDialog(this.map.getView()) != 0) {
            return null;
        }
        return fileChooser.getSelectedFile();
    }

    private Command loadDeck() {
        Command command = new NullCommand();
        GameModule.getGameModule().warn("Loading deck ...");
        try {
            File file = this.getLoadFileName();
            if (file != null) {
                command = this.loadDeck(file);
                GameModule.getGameModule().warn("deck Loaded");
            } else {
                GameModule.getGameModule().warn("Load Canceled");
            }
        }
        catch (IOException iOException) {
            GameModule.getGameModule().warn("Load Failed.  Try again.");
        }
        return command;
    }

    public Command loadDeck(File file) throws IOException {
        int n;
        FileReader fileReader = new FileReader(file);
        char[] cArray = new char[10000];
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = fileReader.read(cArray)) > 0) {
            stringBuffer.append(cArray, 0, n);
        }
        fileReader.close();
        GameModule.getGameModule().addCommandEncoder(this.commandEncoder);
        Command command = GameModule.getGameModule().decode(stringBuffer.toString());
        GameModule.getGameModule().removeCommandEncoder(this.commandEncoder);
        if (command instanceof LoadDeckCommand) {
            ChangeTracker changeTracker = new ChangeTracker(this);
            command.execute();
            Command[] commandArray = command.getSubCommands();
            command = new NullCommand();
            for (int i = 0; i < commandArray.length; ++i) {
                command.append(commandArray[i]);
            }
            command.append(changeTracker.getChangeCommand());
        } else {
            GameModule.getGameModule().warn(file.getName() + " is not a saved deck file");
            command = null;
        }
        return command;
    }

    public int getDragCount() {
        return this.dragCount;
    }

    public void setDragCount(int n) {
        this.dragCount = n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static class LoadDeckCommand
    extends Command {
        public static final String PREFIX = "DECK\t";
        private Deck target;

        public LoadDeckCommand(Deck deck) {
            this.target = deck;
        }

        protected void executeCommand() {
            this.target.removeAll();
            Command[] commandArray = this.getSubCommands();
            for (int i = 0; i < commandArray.length; ++i) {
                if (!(commandArray[i] instanceof AddPiece)) continue;
                GamePiece gamePiece = ((AddPiece)commandArray[i]).getTarget();
                gamePiece.setId(null);
                this.target.add(gamePiece);
            }
        }

        public String getTargetId() {
            return this.target == null ? "" : this.target.getId();
        }

        protected Command myUndoCommand() {
            return null;
        }
    }
}

