/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.module.Map;
import VASSAL.counters.GamePiece;
import VASSAL.counters.PieceIterator;
import VASSAL.counters.Stack;
import VASSAL.tools.Sort;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JFrame;

public class DragBuffer {
    private static DragBuffer theBuffer;
    private Vector pieces = new Vector();
    private MouseEvent lastRelease;
    private Component dropTarget;
    private MouseListener dropHandler;
    private Map dragFromMap;

    private DragBuffer() {
    }

    public static void init(DragBuffer dragBuffer) {
        if (theBuffer == null) {
            theBuffer = dragBuffer;
        }
    }

    public static DragBuffer getBuffer() {
        if (theBuffer == null) {
            theBuffer = new DragBuffer();
        }
        return theBuffer;
    }

    public void add(GamePiece gamePiece) {
        if (gamePiece != null && !this.pieces.contains(gamePiece) && !Boolean.TRUE.equals(gamePiece.getProperty("Restricted"))) {
            if (gamePiece instanceof Stack) {
                Enumeration enumeration = ((Stack)gamePiece).getPieces();
                while (enumeration.hasMoreElements()) {
                    if (!Boolean.TRUE.equals(((GamePiece)enumeration.nextElement()).getProperty("Restricted"))) continue;
                    return;
                }
                this.pieces.addElement(gamePiece);
            } else {
                this.pieces.addElement(gamePiece);
            }
            this.dragFromMap = gamePiece.getMap();
        }
    }

    public Map getFromMap() {
        return this.dragFromMap;
    }

    public void clear() {
        this.pieces.removeAllElements();
    }

    public void addDragSource(Component component) {
        component.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                DragBuffer.this.lastRelease = null;
                DragBuffer.this.dropTarget = null;
                DragBuffer.this.dropHandler = null;
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                mouseEvent.getComponent().setCursor(null);
                Component component = (Component)mouseEvent.getSource();
                if (DragBuffer.this.dropTarget == null) {
                    mouseEvent.translatePoint(component.getLocationOnScreen().x, component.getLocationOnScreen().y);
                    DragBuffer.this.lastRelease = mouseEvent;
                } else {
                    mouseEvent.translatePoint(component.getLocationOnScreen().x, component.getLocationOnScreen().y);
                    mouseEvent.translatePoint(-((DragBuffer)DragBuffer.this).dropTarget.getLocationOnScreen().x, -((DragBuffer)DragBuffer.this).dropTarget.getLocationOnScreen().y);
                    DragBuffer.this.dropHandler.mouseReleased(mouseEvent);
                }
            }
        });
    }

    public void addDropTarget(Component component, final MouseListener mouseListener) {
        component.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                Component component = (Component)mouseEvent.getSource();
                if (component.isShowing()) {
                    if (DragBuffer.this.lastRelease != null) {
                        mouseEvent.translatePoint(component.getLocationOnScreen().x, component.getLocationOnScreen().y);
                        if (DragBuffer.this.isCloseEnough(mouseEvent.getPoint(), DragBuffer.this.lastRelease.getPoint())) {
                            mouseEvent.translatePoint(-component.getLocationOnScreen().x, -component.getLocationOnScreen().y);
                            mouseListener.mouseReleased(mouseEvent);
                        }
                    } else {
                        DragBuffer.this.dropTarget = component;
                        DragBuffer.this.dropHandler = mouseListener;
                    }
                }
            }
        });
    }

    private boolean isCloseEnough(Point point, Point point2) {
        return Math.abs(point.x - point2.x) < 3 && Math.abs(point.y - point2.y) < 3;
    }

    public void remove(GamePiece gamePiece) {
        this.pieces.removeElement(gamePiece);
    }

    public boolean contains(GamePiece gamePiece) {
        return this.pieces.contains(gamePiece);
    }

    public PieceIterator getIterator() {
        return new PieceIterator(this.pieces.elements());
    }

    public String contents() {
        String string = "";
        Enumeration enumeration = this.pieces.elements();
        while (enumeration.hasMoreElements()) {
            GamePiece gamePiece = (GamePiece)enumeration.nextElement();
            string = string.concat(gamePiece.getName());
            if (!enumeration.hasMoreElements()) continue;
            string = string.concat(",");
        }
        return string;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        ((Component)jFrame).setSize(200, 200);
        ((Component)jFrame).setVisible(true);
        JFrame jFrame2 = new JFrame();
        ((Component)jFrame2).setSize(200, 200);
        ((Component)jFrame2).setLocation(200, 0);
        ((Component)jFrame2).setVisible(true);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                mouseEvent.translatePoint(((JFrame)mouseEvent.getSource()).getLocationOnScreen().x, ((JFrame)mouseEvent.getSource()).getLocationOnScreen().y);
                System.err.println("Press at " + mouseEvent.getPoint());
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                System.err.println("Release at " + mouseEvent.getPoint());
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                mouseEvent.translatePoint(((JFrame)mouseEvent.getSource()).getLocationOnScreen().x, ((JFrame)mouseEvent.getSource()).getLocationOnScreen().y);
                System.err.println("Enter at " + mouseEvent.getPoint());
            }
        };
        DragBuffer.getBuffer().addDragSource(jFrame);
        DragBuffer.getBuffer().addDropTarget(jFrame2, mouseAdapter);
    }

    public Cursor createDragCursor(Component component) {
        Cursor cursor = null;
        if (this.pieces.size() > 0) {
            cursor = Cursor.getPredefinedCursor(12);
        }
        return cursor;
    }

    public void sort(Comparator comparator) {
        try {
            Collections.sort(this.pieces, comparator);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sort(Sort.Comparator comparator) {
        this.sort((Comparator)((Object)comparator));
    }
}

