/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.properties.PropertyChanger;
import VASSAL.build.module.properties.PropertyChangerConfigurer;
import VASSAL.build.module.properties.PropertyPrompt;
import VASSAL.command.ChangeTracker;
import VASSAL.command.Command;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.HotKeyConfigurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.ListConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.EditablePiece;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.Stack;
import VASSAL.tools.FormattedString;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.Box;
import javax.swing.KeyStroke;

public class DynamicProperty
extends Decorator
implements EditablePiece,
PropertyPrompt.DialogParent,
PropertyChangerConfigurer.Constraints {
    public static final String ID = "PROP;";
    protected String value;
    protected String key;
    protected boolean numeric;
    protected int minValue;
    protected int maxValue;
    protected boolean wrap;
    protected FormattedString format = new FormattedString();
    protected DynamicKeyCommand[] keyCommands;
    protected DynamicKeyCommand[] menuCommands;
    protected ListConfigurer keyCommandListConfig;

    public DynamicProperty() {
        this(ID, null);
    }

    public DynamicProperty(String string, GamePiece gamePiece) {
        this.setInner(gamePiece);
        this.keyCommandListConfig = new ListConfigurer(null, "Commands"){

            protected Configurer buildChildConfigurer() {
                return new DynamicKeyCommandConfigurer(DynamicProperty.this);
            }
        };
        this.mySetType(string);
    }

    public void mySetType(String string) {
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        decoder.nextToken();
        this.key = decoder.nextToken("name");
        this.decodeConstraints(decoder.nextToken(""));
        this.keyCommandListConfig.setValue(decoder.nextToken(""));
        this.keyCommands = this.keyCommandListConfig.getListValue().toArray(new DynamicKeyCommand[this.keyCommandListConfig.getListValue().size()]);
        ArrayList<DynamicKeyCommand> arrayList = new ArrayList<DynamicKeyCommand>();
        for (int i = 0; i < this.keyCommands.length; ++i) {
            if (this.keyCommands[i].getName() == null || this.keyCommands[i].getName().length() <= 0) continue;
            arrayList.add(this.keyCommands[i]);
        }
        this.menuCommands = arrayList.toArray(new DynamicKeyCommand[arrayList.size()]);
    }

    protected void decodeConstraints(String string) {
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ',');
        this.numeric = decoder.nextBoolean(false);
        this.minValue = decoder.nextInt(0);
        this.maxValue = decoder.nextInt(100);
        this.wrap = decoder.nextBoolean(false);
    }

    protected String encodeConstraints() {
        return new SequenceEncoder(',').append(this.numeric).append(this.minValue).append(this.maxValue).append(this.wrap).getValue();
    }

    public void draw(Graphics graphics, int n, int n2, Component component, double d) {
        this.piece.draw(graphics, n, n2, component, d);
    }

    public String getName() {
        return this.piece.getName();
    }

    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    public Shape getShape() {
        return this.piece.getShape();
    }

    public Object getProperty(Object object) {
        if (object.equals(this.getKey())) {
            return this.getValue();
        }
        return super.getProperty(object);
    }

    public void setProperty(Object object, Object object2) {
        if (object.equals(this.getKey())) {
            this.setValue((String)object2);
        } else {
            super.setProperty(object, object2);
        }
    }

    public String myGetState() {
        return this.getValue();
    }

    public Component getComponent() {
        return this.getMap() != null ? this.getMap().getView().getTopLevelAncestor() : GameModule.getGameModule().getFrame();
    }

    public void mySetState(String string) {
        this.setValue(string);
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        Stack stack = this.getParent();
        Map map = this.getMap();
        if (map != null) {
            GamePiece gamePiece = Decorator.getOutermost(this);
            if (stack == null) {
                Point point = this.getPosition();
                map.removePiece(gamePiece);
                this.value = string;
                map.placeOrMerge(gamePiece, point);
            } else {
                GamePiece gamePiece2 = stack.getPieceBeneath(gamePiece);
                if (gamePiece2 == null) {
                    gamePiece2 = stack.getPieceAbove(gamePiece);
                }
                if (gamePiece2 == null) {
                    Point point = stack.getPosition();
                    map.removePiece(stack);
                    this.value = string;
                    map.placeOrMerge(stack, point);
                } else {
                    this.value = string;
                    if (!map.getPieceCollection().canMerge(gamePiece2, gamePiece)) {
                        map.placeOrMerge(gamePiece, stack.getPosition());
                    }
                }
            }
        } else {
            this.value = string;
        }
    }

    public String myGetType() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
        sequenceEncoder.append(this.key);
        sequenceEncoder.append(this.encodeConstraints());
        sequenceEncoder.append(this.keyCommandListConfig.getValueString());
        return ID + sequenceEncoder.getValue();
    }

    protected KeyCommand[] myGetKeyCommands() {
        return this.menuCommands;
    }

    public Command myKeyEvent(KeyStroke keyStroke) {
        ChangeTracker changeTracker = new ChangeTracker(this);
        for (int i = 0; i < this.keyCommands.length; ++i) {
            if (!this.keyCommands[i].matches(keyStroke)) continue;
            String string = this.keyCommands[i].propChanger.getNewValue(this.value);
            this.format.setFormat(string);
            string = this.format.getText(Decorator.getOutermost(this));
            this.setValue(string);
        }
        Command command = changeTracker.getChangeCommand();
        return command;
    }

    public String getDescription() {
        String string = "Dynamic Property";
        if (this.getKey() != null && this.getKey().length() > 0) {
            string = string + " - " + this.getKey();
        }
        return string;
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("DynamicProperty.htm");
    }

    public int getMaximumValue() {
        return this.maxValue;
    }

    public int getMinimumValue() {
        return this.minValue;
    }

    public boolean isNumeric() {
        return this.numeric;
    }

    public boolean isWrap() {
        return this.wrap;
    }

    public PieceEditor getEditor() {
        return new Ed(this);
    }

    protected static class DynamicKeyCommandConfigurer
    extends Configurer {
        protected HotKeyConfigurer keyConfig;
        protected PropertyChangerConfigurer propChangeConfig;
        protected StringConfigurer commandConfig = new StringConfigurer(null, " Menu Command:  ", "Change value");
        protected Box controls = null;
        protected DynamicProperty target;

        public DynamicKeyCommandConfigurer(DynamicProperty dynamicProperty) {
            super(dynamicProperty.getKey(), dynamicProperty.getKey(), new DynamicKeyCommand("Change value", KeyStroke.getKeyStroke(86, 2), (GamePiece)dynamicProperty, new PropertyPrompt(dynamicProperty, "Change value of " + dynamicProperty.getKey())));
            this.keyConfig = new HotKeyConfigurer(null, " Key Command:  ", KeyStroke.getKeyStroke(86, 2));
            this.propChangeConfig = new PropertyChangerConfigurer(null, "Action:  ", dynamicProperty);
            this.propChangeConfig.setValue(new PropertyPrompt(dynamicProperty, " Change value of " + dynamicProperty.getKey()));
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(this){
                private final /* synthetic */ DynamicKeyCommandConfigurer this$0;
                {
                    this.this$0 = dynamicKeyCommandConfigurer;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    this.this$0.updateValue();
                }
            };
            this.commandConfig.addPropertyChangeListener(propertyChangeListener);
            this.keyConfig.addPropertyChangeListener(propertyChangeListener);
            this.propChangeConfig.addPropertyChangeListener(propertyChangeListener);
            this.target = dynamicProperty;
        }

        public String getValueString() {
            SequenceEncoder sequenceEncoder = new SequenceEncoder(':');
            sequenceEncoder.append(this.commandConfig.getValueString()).append(this.keyConfig.getValueString()).append(this.propChangeConfig.getValueString());
            return sequenceEncoder.getValue();
        }

        public void setValue(Object object) {
            if (!this.noUpdate && object instanceof DynamicKeyCommand && this.commandConfig != null) {
                DynamicKeyCommand dynamicKeyCommand = (DynamicKeyCommand)object;
                this.commandConfig.setValue(dynamicKeyCommand.getName());
                this.keyConfig.setValue(dynamicKeyCommand.getKeyStroke());
                this.propChangeConfig.setValue(dynamicKeyCommand.propChanger);
            }
            super.setValue(object);
        }

        public DynamicKeyCommand getKeyCommand() {
            return (DynamicKeyCommand)this.getValue();
        }

        public void setValue(String string) {
            SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string == null ? "" : string, ':');
            this.commandConfig.setValue(decoder.nextToken(""));
            this.keyConfig.setValue(decoder.nextToken(""));
            this.propChangeConfig.setValue(decoder.nextToken(""));
            this.updateValue();
        }

        public Component getControls() {
            if (this.controls == null) {
                this.buildControls();
            }
            return this.controls;
        }

        protected void updateValue() {
            this.noUpdate = true;
            this.setValue(new DynamicKeyCommand(this.commandConfig.getValueString(), (KeyStroke)this.keyConfig.getValue(), (GamePiece)this.target, this.propChangeConfig.getPropertyChanger()));
            this.noUpdate = false;
        }

        protected void buildControls() {
            this.controls = Box.createHorizontalBox();
            this.controls.add(this.commandConfig.getControls());
            this.controls.add(this.keyConfig.getControls());
            this.controls.add(this.propChangeConfig.getControls());
        }
    }

    protected static class DynamicKeyCommand
    extends KeyCommand {
        protected PropertyChanger propChanger = null;

        public DynamicKeyCommand(String string, KeyStroke keyStroke, GamePiece gamePiece, PropertyChanger propertyChanger) {
            super(string, keyStroke, gamePiece);
            this.propChanger = propertyChanger;
        }
    }

    protected static class Ed
    implements PieceEditor {
        protected StringConfigurer nameConfig;
        protected StringConfigurer initialValueConfig;
        protected BooleanConfigurer numericConfig;
        protected IntConfigurer minConfig;
        protected IntConfigurer maxConfig;
        protected BooleanConfigurer wrapConfig;
        protected ListConfigurer keyCommandListConfig;
        protected Box controls;

        public Ed(DynamicProperty dynamicProperty) {
            this.keyCommandListConfig = new ListConfigurer(this, null, "Key Commands", dynamicProperty){
                private final /* synthetic */ DynamicProperty val$m;
                private final /* synthetic */ Ed this$0;
                {
                    this.this$0 = ed;
                    this.val$m = dynamicProperty;
                }

                protected Configurer buildChildConfigurer() {
                    return new DynamicKeyCommandConfigurer(this.val$m);
                }
            };
            this.keyCommandListConfig.setValue(new ArrayList<DynamicKeyCommand>(Arrays.asList(dynamicProperty.keyCommands)));
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(this){
                private final /* synthetic */ Ed this$0;
                {
                    this.this$0 = ed;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    boolean bl = this.this$0.numericConfig.booleanValue();
                    this.this$0.minConfig.getControls().setVisible(bl);
                    this.this$0.maxConfig.getControls().setVisible(bl);
                    this.this$0.wrapConfig.getControls().setVisible(bl);
                    this.this$0.keyCommandListConfig.repack();
                }
            };
            this.controls = Box.createVerticalBox();
            this.nameConfig = new StringConfigurer(null, "Name:  ", dynamicProperty.getKey());
            this.controls.add(this.nameConfig.getControls());
            this.initialValueConfig = new StringConfigurer(null, "Value: ", dynamicProperty.getValue());
            this.controls.add(this.initialValueConfig.getControls());
            this.numericConfig = new BooleanConfigurer(null, "Is numeric: ", dynamicProperty.isNumeric());
            this.controls.add(this.numericConfig.getControls());
            this.minConfig = new IntConfigurer(null, "Minimum value: ", new Integer(dynamicProperty.getMinimumValue()));
            this.controls.add(this.minConfig.getControls());
            this.maxConfig = new IntConfigurer(null, "Maximum value: ", new Integer(dynamicProperty.getMaximumValue()));
            this.controls.add(this.maxConfig.getControls());
            this.wrapConfig = new BooleanConfigurer(null, "Wrap ", dynamicProperty.isWrap());
            this.controls.add(this.wrapConfig.getControls());
            this.controls.add(this.keyCommandListConfig.getControls());
            this.numericConfig.addPropertyChangeListener(propertyChangeListener);
            this.numericConfig.fireUpdate();
        }

        public Component getControls() {
            return this.controls;
        }

        protected String encodeConstraints() {
            return new SequenceEncoder(',').append(this.numericConfig.getValueString()).append(this.minConfig.getValueString()).append(this.maxConfig.getValueString()).append(this.wrapConfig.getValueString()).getValue();
        }

        public String getType() {
            SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
            sequenceEncoder.append(this.nameConfig.getValueString());
            sequenceEncoder.append(this.encodeConstraints());
            sequenceEncoder.append(this.keyCommandListConfig.getValueString());
            return DynamicProperty.ID + sequenceEncoder.getValue();
        }

        public String getState() {
            return this.initialValueConfig.getValueString();
        }
    }
}

