/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.ChangeTracker;
import VASSAL.command.Command;
import VASSAL.configure.HotKeyConfigurer;
import VASSAL.configure.KeyModifiersConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.EditablePiece;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.MultiImagePicker;
import VASSAL.counters.PieceEditor;
import VASSAL.tools.DataArchive;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.geom.Area;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class Embellishment
extends Decorator
implements EditablePiece {
    public static final String OLD_ID = "emb;";
    public static final String ID = "emb2;";
    public static final String IMAGE = "_Image";
    public static final String NAME = "_Name";
    public static final String LEVEL = "_Level";
    public static final String ACTIVE = "_Active";
    protected String activateKey = "";
    protected String upKey;
    protected String downKey;
    protected int activateModifiers;
    protected int upModifiers;
    protected int downModifiers;
    protected String upCommand;
    protected String downCommand;
    protected String activateCommand;
    protected String resetCommand;
    protected int resetLevel;
    protected boolean loopLevels;
    protected KeyStroke resetKey;
    protected KeyStroke rndKey;
    private String rndText = "";
    protected int value = -1;
    protected String activationStatus = "";
    protected int nValues;
    protected int xOff;
    protected int yOff;
    protected String[] imageName;
    protected String[] commonName;
    protected Rectangle[] size;
    protected boolean drawUnderneathWhenSelected = false;
    protected String name = "";
    protected KeyCommand[] commands;
    protected KeyCommand up = null;
    protected KeyCommand down = null;
    static /* synthetic */ Class class$VASSAL$counters$Embellishment;

    public Embellishment() {
        this("emb2;Activate", null);
    }

    public Embellishment(String string, GamePiece gamePiece) {
        this.mySetType(string);
        this.setInner(gamePiece);
    }

    public boolean isActive() {
        return this.value > 0;
    }

    public void setActive(boolean bl) {
        this.value = bl ? Math.abs(this.value) : -Math.abs(this.value);
    }

    public int getValue() {
        return Math.abs(this.value) - 1;
    }

    public void setValue(int n) {
        if (n >= this.nValues) {
            throw new IllegalArgumentException();
        }
        this.value = this.value > 0 ? n + 1 : -n - 1;
    }

    public void mySetType(String string) {
        if (!string.startsWith(ID)) {
            this.originalSetType(string);
        } else {
            string = string.substring(ID.length());
            SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
            this.activateCommand = decoder.nextToken("Activate");
            this.activateModifiers = decoder.nextInt(2);
            this.activateKey = decoder.nextToken("A");
            this.upCommand = decoder.nextToken("Increase");
            this.upModifiers = decoder.nextInt(2);
            this.upKey = decoder.nextToken("]");
            this.downCommand = decoder.nextToken("Decrease");
            this.downModifiers = decoder.nextInt(2);
            this.downKey = decoder.nextToken("[");
            this.resetCommand = decoder.nextToken("Reset");
            this.resetKey = decoder.nextKeyStroke('R');
            this.resetLevel = decoder.nextInt(1);
            this.drawUnderneathWhenSelected = decoder.nextBoolean(false);
            this.xOff = decoder.nextInt(0);
            this.yOff = decoder.nextInt(0);
            this.imageName = decoder.nextStringArray(0);
            this.commonName = decoder.nextStringArray(this.imageName.length);
            this.loopLevels = decoder.nextBoolean(true);
            this.name = decoder.nextToken("");
            this.rndKey = decoder.nextKeyStroke(null);
            this.rndText = decoder.nextToken("");
            this.value = this.activateKey.length() > 0 ? -1 : 1;
            this.nValues = this.imageName.length;
            this.size = new Rectangle[this.imageName.length];
        }
        this.commands = null;
    }

    private void originalSetType(String string) {
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        decoder.nextToken();
        SequenceEncoder.Decoder decoder2 = new SequenceEncoder.Decoder(decoder.nextToken(), ';');
        this.activateKey = decoder2.nextToken().toUpperCase();
        this.activateModifiers = 2;
        if (decoder2.hasMoreTokens()) {
            this.resetCommand = decoder2.nextToken();
            this.resetKey = decoder2.nextKeyStroke(null);
            this.resetLevel = decoder2.nextInt(0);
        } else {
            this.resetKey = null;
            this.resetCommand = "";
            this.resetLevel = 0;
        }
        this.activateCommand = decoder.nextToken();
        this.drawUnderneathWhenSelected = this.activateCommand.startsWith("_");
        if (this.drawUnderneathWhenSelected) {
            this.activateCommand = this.activateCommand.substring(1);
        }
        this.value = this.activateKey.length() > 0 ? -1 : 1;
        this.upKey = decoder.nextToken().toUpperCase();
        this.upCommand = decoder.nextToken();
        this.upModifiers = 2;
        this.downKey = decoder.nextToken().toUpperCase();
        this.downCommand = decoder.nextToken();
        this.downModifiers = 2;
        this.xOff = decoder.nextInt(0);
        this.yOff = decoder.nextInt(0);
        Vector<String> vector = new Vector<String>();
        while (decoder.hasMoreTokens()) {
            vector.addElement(decoder.nextToken());
        }
        this.nValues = vector.size();
        this.imageName = new String[vector.size()];
        this.commonName = new String[vector.size()];
        this.size = new Rectangle[this.imageName.length];
        for (int i = 0; i < this.imageName.length; ++i) {
            String string2 = (String)vector.elementAt(i);
            SequenceEncoder.Decoder decoder3 = new SequenceEncoder.Decoder(string2, ',');
            this.imageName[i] = decoder3.nextToken();
            if (!decoder3.hasMoreTokens()) continue;
            this.commonName[i] = decoder3.nextToken();
        }
        this.loopLevels = true;
    }

    public String getName() {
        String string = null;
        if (this.value > 0 && this.commonName[this.value - 1] != null && this.commonName[this.value - 1].length() > 0) {
            SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(this.commonName[this.value - 1], '+');
            String string2 = decoder.nextToken();
            if (decoder.hasMoreTokens()) {
                String string3 = decoder.nextToken();
                string = string2.length() == 0 ? this.piece.getName() + string3 : string2 + this.piece.getName();
            } else {
                string = string2;
            }
        } else {
            string = this.piece.getName();
        }
        return string;
    }

    public void mySetState(String string) {
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        this.value = decoder.nextInt(1);
        this.activationStatus = decoder.nextToken(this.value < 0 ? "" : this.activateKey);
    }

    public String myGetType() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
        sequenceEncoder.append(this.activateCommand).append(this.activateModifiers).append(this.activateKey).append(this.upCommand).append(this.upModifiers).append(this.upKey).append(this.downCommand).append(this.downModifiers).append(this.downKey).append(this.resetCommand).append(this.resetKey).append(this.resetLevel).append(this.drawUnderneathWhenSelected).append(this.xOff).append(this.yOff).append(this.imageName).append(this.commonName).append(this.loopLevels).append(this.name).append(this.rndKey).append(this.rndText);
        return ID + sequenceEncoder.getValue();
    }

    public String oldGetType() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(null, ';');
        SequenceEncoder sequenceEncoder2 = new SequenceEncoder(this.activateKey, ';');
        sequenceEncoder2.append(this.resetCommand).append(this.resetKey).append(String.valueOf(this.resetLevel));
        sequenceEncoder.append(sequenceEncoder2.getValue()).append(this.drawUnderneathWhenSelected ? "_" + this.activateCommand : this.activateCommand).append(this.upKey).append(this.upCommand).append(this.downKey).append(this.downCommand).append(this.xOff).append(this.yOff);
        for (int i = 0; i < this.nValues; ++i) {
            if (this.commonName[i] != null) {
                SequenceEncoder sequenceEncoder3 = new SequenceEncoder(this.imageName[i], ',');
                sequenceEncoder.append(sequenceEncoder3.append(this.commonName[i]).getValue());
                continue;
            }
            sequenceEncoder.append(this.imageName[i]);
        }
        return ID + sequenceEncoder.getValue();
    }

    public String myGetState() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
        return sequenceEncoder.append(String.valueOf(this.value)).append(this.activationStatus).getValue();
    }

    public void draw(Graphics graphics, int n, int n2, Component component, double d) {
        this.piece.draw(graphics, n, n2, component, d);
        if (this.value <= 0) {
            return;
        }
        try {
            Image image = this.getCurrentImage();
            if (image != null) {
                Rectangle rectangle = this.getCurrentImageBounds();
                if (d == 1.0) {
                    graphics.drawImage(image, n + rectangle.x, n2 + rectangle.y, component);
                } else {
                    Image image2 = GameModule.getGameModule().getDataArchive().getScaledImage(image, d);
                    graphics.drawImage(image2, n + (int)(d * (double)rectangle.x), n2 + (int)(d * (double)rectangle.y), component);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.drawUnderneathWhenSelected && Boolean.TRUE.equals(this.getProperty("Selected"))) {
            this.piece.draw(graphics, n, n2, component, d);
        }
    }

    public KeyCommand[] myGetKeyCommands() {
        if (this.commands == null) {
            ArrayList<KeyCommand> arrayList = new ArrayList<KeyCommand>();
            GamePiece gamePiece = Decorator.getOutermost(this);
            if (this.activateCommand.length() > 0 && this.activateKey.length() > 0) {
                arrayList.add(new KeyCommand(this.activateCommand, KeyStroke.getKeyStroke((int)this.activateKey.charAt(0), this.activateModifiers), gamePiece));
            }
            if (this.upCommand.length() > 0 && this.upKey.length() > 0 && this.nValues > 1) {
                this.up = new KeyCommand(this.upCommand, KeyStroke.getKeyStroke((int)this.upKey.charAt(0), this.upModifiers), gamePiece);
                arrayList.add(this.up);
            }
            if (this.downCommand.length() > 0 && this.downKey.length() > 0 && this.nValues > 1) {
                this.down = new KeyCommand(this.downCommand, KeyStroke.getKeyStroke((int)this.downKey.charAt(0), this.downModifiers), gamePiece);
                arrayList.add(this.down);
            }
            if (this.resetKey != null && this.resetCommand.length() > 0) {
                arrayList.add(new KeyCommand(this.resetCommand, this.resetKey, gamePiece));
            }
            if (this.rndKey != null && this.rndText.length() > 0) {
                arrayList.add(new KeyCommand(this.rndText, this.rndKey, gamePiece));
            }
            this.commands = arrayList.toArray(new KeyCommand[arrayList.size()]);
        }
        if (this.up != null) {
            this.up.setEnabled(this.loopLevels || Math.abs(this.value) < this.imageName.length);
        }
        if (this.down != null) {
            this.down.setEnabled(this.loopLevels || Math.abs(this.value) > 1);
        }
        return this.commands;
    }

    public Command myKeyEvent(KeyStroke keyStroke) {
        int n;
        char c = this.getMatchingActivationChar(keyStroke);
        ChangeTracker changeTracker = null;
        if (c != '\u0000') {
            changeTracker = new ChangeTracker(this);
            n = this.activationStatus.indexOf(c);
            if (n < 0) {
                this.activationStatus = this.activationStatus + c;
            } else {
                String string = this.activationStatus.substring(0, n);
                String string2 = this.activationStatus.substring(n + 1);
                this.activationStatus = string + string2;
            }
            this.value = this.activationStatus.length() == this.activateKey.length() ? Math.abs(this.value) : -Math.abs(this.value);
        }
        for (n = 0; n < this.upKey.length(); ++n) {
            if (!KeyStroke.getKeyStroke((int)this.upKey.charAt(n), this.upModifiers).equals(keyStroke)) continue;
            if (changeTracker == null) {
                changeTracker = new ChangeTracker(this);
            }
            int n2 = Math.abs(this.value);
            if (++n2 > this.nValues) {
                n2 = this.loopLevels ? 1 : this.nValues;
            }
            this.value = this.value > 0 ? n2 : -n2;
            break;
        }
        for (n = 0; n < this.downKey.length(); ++n) {
            if (!KeyStroke.getKeyStroke((int)this.downKey.charAt(n), this.downModifiers).equals(keyStroke)) continue;
            if (changeTracker == null) {
                changeTracker = new ChangeTracker(this);
            }
            int n3 = Math.abs(this.value);
            if (--n3 < 1) {
                n3 = this.loopLevels ? this.nValues : 1;
            }
            this.value = this.value > 0 ? n3 : -n3;
            break;
        }
        if (this.resetKey != null && this.resetKey.equals(keyStroke)) {
            if (changeTracker == null) {
                changeTracker = new ChangeTracker(this);
            }
            this.setValue(Math.abs(this.resetLevel) - 1);
            this.setActive(this.resetLevel > 0);
        }
        if (this.rndKey != null && this.rndKey.equals(keyStroke)) {
            if (changeTracker == null) {
                changeTracker = new ChangeTracker(this);
            }
            n = 0;
            n = GameModule.getGameModule().getRNG().nextInt(this.nValues) + 1;
            this.value = this.value > 0 ? n : -n;
        }
        return changeTracker != null ? changeTracker.getChangeCommand() : null;
    }

    private char getMatchingActivationChar(KeyStroke keyStroke) {
        for (int i = 0; i < this.activateKey.length(); ++i) {
            if (!keyStroke.equals(KeyStroke.getKeyStroke((int)this.activateKey.charAt(i), this.activateModifiers))) continue;
            return this.activateKey.charAt(i);
        }
        return '\u0000';
    }

    protected Image getCurrentImage() throws IOException {
        if (this.value > 0) {
            return GameModule.getGameModule() == null ? null : GameModule.getGameModule().getDataArchive().getCachedImage(this.imageName[this.value - 1]);
        }
        return null;
    }

    public Rectangle boundingBox() {
        if (this.value > 0) {
            return this.getCurrentImageBounds().union(this.piece.boundingBox());
        }
        return this.piece.boundingBox();
    }

    public Rectangle getCurrentImageBounds() {
        if (this.value > 0) {
            if (this.size[this.value - 1] == null) {
                try {
                    Image image = this.getCurrentImage();
                    if (image != null) {
                        this.size[this.value - 1] = DataArchive.getImageBounds(image);
                        this.size[this.value - 1].translate(this.xOff, this.yOff);
                    } else {
                        this.size[this.value - 1] = new Rectangle();
                    }
                }
                catch (IOException iOException) {
                    this.size[this.value - 1] = new Rectangle();
                }
            }
            return this.size[this.value - 1];
        }
        return new Rectangle();
    }

    public Shape getShape() {
        if (this.value > 0 && !this.drawUnderneathWhenSelected) {
            Area area = new Area(this.piece.getShape());
            area.add(new Area(this.getCurrentImageBounds()));
            return area;
        }
        return this.piece.getShape();
    }

    public String getDescription() {
        String string = this.name;
        if ((this.name == null || this.name.length() == 0) && this.imageName.length > 0 && this.imageName[0] != null && this.imageName[0].length() > 0) {
            string = this.imageName[0];
        }
        if (string == null || string.length() == 0) {
            return "Layer";
        }
        return "Layer - " + string;
    }

    public Object getProperty(Object object) {
        if (object.equals(this.name + IMAGE)) {
            if (this.value > 0) {
                return this.imageName[Math.abs(this.value) - 1];
            }
            return "";
        }
        if (object.equals(this.name + NAME)) {
            if (this.value > 0) {
                String string = this.commonName[Math.abs(this.value) - 1];
                if (string.startsWith("+")) {
                    return string.substring(1);
                }
                if (string.endsWith("+")) {
                    return string.substring(0, string.length() - 2);
                }
                return string;
            }
            return "";
        }
        if (object.equals(this.name + LEVEL)) {
            return String.valueOf(this.value);
        }
        if (object.equals(this.name + ACTIVE)) {
            return String.valueOf(this.isActive());
        }
        if (object.equals("visibleState")) {
            String string = String.valueOf(super.getProperty(object));
            if (this.drawUnderneathWhenSelected) {
                string = string + this.getProperty("Selected");
            }
            return string;
        }
        return super.getProperty(object);
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Layer.htm");
    }

    public PieceEditor getEditor() {
        return new Ed(this);
    }

    public static Embellishment getLayerWithMatchingActivateCommand(GamePiece gamePiece, KeyStroke keyStroke, boolean bl) {
        Embellishment embellishment = (Embellishment)Decorator.getDecorator(gamePiece, class$VASSAL$counters$Embellishment == null ? (class$VASSAL$counters$Embellishment = Embellishment.class$("VASSAL.counters.Embellishment")) : class$VASSAL$counters$Embellishment);
        while (embellishment != null) {
            for (int i = 0; i < embellishment.activateKey.length(); ++i) {
                if (!keyStroke.equals(KeyStroke.getKeyStroke((int)embellishment.activateKey.charAt(i), embellishment.activateModifiers))) continue;
                if (bl && embellishment.isActive()) {
                    return embellishment;
                }
                if (bl || embellishment.isActive()) break;
                return embellishment;
            }
            embellishment = (Embellishment)Decorator.getDecorator(embellishment.piece, class$VASSAL$counters$Embellishment == null ? Embellishment.class$("VASSAL.counters.Embellishment") : class$VASSAL$counters$Embellishment);
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class Ed
    implements PieceEditor {
        private MultiImagePicker images;
        private JTextField activateKeyInput = new JTextField("A");
        private JTextField upKeyInput = new JTextField("]");
        private JTextField downKeyInput = new JTextField("[");
        private JTextField activateCommand = new JTextField("Activate");
        private KeyModifiersConfigurer activateModifiers = new KeyModifiersConfigurer(null, "key:  ");
        private JTextField upCommand = new JTextField("Increase");
        private KeyModifiersConfigurer upModifiers = new KeyModifiersConfigurer(null, "key:  ");
        private JTextField downCommand = new JTextField("Decrease");
        private KeyModifiersConfigurer downModifiers = new KeyModifiersConfigurer(null, "key:  ");
        private JTextField rndCommand = new JTextField(8);
        private JTextField xOffInput = new JTextField(2);
        private JTextField yOffInput = new JTextField(2);
        private JTextField levelNameInput = new JTextField(8);
        private JRadioButton prefix = new JRadioButton("is prefix");
        private JRadioButton suffix = new JRadioButton("is suffix");
        private JCheckBox alwaysActive = new JCheckBox("Always active");
        private JCheckBox drawUnderneath = new JCheckBox("Underneath when highlighted");
        private JTextField resetLevel = new JTextField(2);
        private JTextField resetCommand = new JTextField(8);
        private JCheckBox loop = new JCheckBox("Loop through levels");
        private HotKeyConfigurer resetKey = new HotKeyConfigurer(null, "Keyboard:  ");
        private JTextField name = new JTextField(8);
        private JPanel controls = new JPanel();
        private List names;
        private List isPrefix;
        private static final Integer NEITHER = new Integer(0);
        private static final Integer PREFIX = new Integer(1);
        private static final Integer SUFFIX = new Integer(2);
        private HotKeyConfigurer rndKeyConfig;

        public Ed(Embellishment embellishment) {
            this.controls.setLayout(new BoxLayout(this.controls, 1));
            Box box = Box.createHorizontalBox();
            box.add(new JLabel("Name"));
            box.add(this.name);
            this.controls.add(box);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridLayout(5, 3));
            jPanel.add(this.resetKey.getControls());
            this.activateCommand.setMaximumSize(this.activateCommand.getPreferredSize());
            jPanel.add(this.activateCommand);
            jPanel.add(this.activateModifiers.getControls());
            jPanel.add(this.activateKeyInput);
            this.upCommand.setMaximumSize(this.upCommand.getPreferredSize());
            jPanel.add(this.upCommand);
            jPanel.add(this.upModifiers.getControls());
            jPanel.add(this.upKeyInput);
            this.downCommand.setMaximumSize(this.downCommand.getPreferredSize());
            jPanel.add(this.downCommand);
            jPanel.add(this.downModifiers.getControls());
            jPanel.add(this.downKeyInput);
            Box box2 = Box.createHorizontalBox();
            box2.add(new JLabel("Reset to level"));
            box2.add(this.resetLevel);
            jPanel.add(box2);
            box2 = Box.createHorizontalBox();
            box2.add(new JLabel("Command: "));
            box2.add(this.resetCommand);
            jPanel.add(box2);
            jPanel.add(this.resetKey.getControls());
            jPanel.add(new JLabel("Randomize"));
            Box box3 = Box.createHorizontalBox();
            box3.add(new JLabel("Command: "));
            this.rndCommand = new JTextField(12);
            this.rndCommand.setMaximumSize(this.rndCommand.getPreferredSize());
            this.rndCommand.setText(embellishment.rndText);
            box3.add(this.rndCommand);
            jPanel.add(box3);
            this.rndKeyConfig = new HotKeyConfigurer(null, "Keyboard: ", embellishment.rndKey);
            jPanel.add(this.rndKeyConfig.getControls());
            Box box4 = Box.createVerticalBox();
            this.alwaysActive.addItemListener(new ItemListener(this){
                private final /* synthetic */ Ed this$0;
                {
                    this.this$0 = ed;
                }

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (Ed.access$100(this.this$0).isSelected()) {
                        Ed.access$200(this.this$0).setText("");
                        Ed.access$300(this.this$0).setText("");
                        Ed.access$200(this.this$0).setEnabled(false);
                        Ed.access$300(this.this$0).setEnabled(false);
                    } else {
                        Ed.access$200(this.this$0).setText("Activate");
                        Ed.access$300(this.this$0).setText("A");
                        Ed.access$200(this.this$0).setEnabled(true);
                        Ed.access$300(this.this$0).setEnabled(true);
                    }
                }
            });
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new GridLayout(2, 2));
            jPanel2.add(this.alwaysActive);
            jPanel2.add(this.drawUnderneath);
            jPanel2.add(this.loop);
            box4.add(jPanel2);
            box4.add(jPanel);
            Box box5 = Box.createHorizontalBox();
            this.xOffInput.setMaximumSize(this.xOffInput.getPreferredSize());
            this.xOffInput.setText("0");
            this.yOffInput.setMaximumSize(this.xOffInput.getPreferredSize());
            this.yOffInput.setText("0");
            box5.add(new JLabel("Offset: "));
            box5.add(this.xOffInput);
            box5.add(new JLabel(","));
            box5.add(this.yOffInput);
            jPanel2.add(box5);
            this.controls.add(box4);
            this.images = new MultiImagePicker();
            this.controls.add(this.images);
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new GridLayout(2, 2));
            box4 = Box.createHorizontalBox();
            box4.add(new JLabel("Level Name: "));
            this.levelNameInput.setMaximumSize(this.levelNameInput.getPreferredSize());
            this.levelNameInput.addKeyListener(new KeyAdapter(this){
                private final /* synthetic */ Ed this$0;
                {
                    this.this$0 = ed;
                }

                public void keyReleased(KeyEvent keyEvent) {
                    Ed.access$400(this.this$0);
                }
            });
            box4.add(this.levelNameInput);
            jPanel3.add(box4);
            box4 = Box.createHorizontalBox();
            this.prefix.addActionListener(new ActionListener(this){
                private final /* synthetic */ Ed this$0;
                {
                    this.this$0 = ed;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (Ed.access$500(this.this$0).isSelected()) {
                        Ed.access$600(this.this$0).setSelected(false);
                    }
                    Ed.access$400(this.this$0);
                }
            });
            this.suffix.addActionListener(new ActionListener(this){
                private final /* synthetic */ Ed this$0;
                {
                    this.this$0 = ed;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (Ed.access$600(this.this$0).isSelected()) {
                        Ed.access$500(this.this$0).setSelected(false);
                    }
                    Ed.access$400(this.this$0);
                }
            });
            box4.add(this.prefix);
            box4.add(this.suffix);
            jPanel3.add(box4);
            JButton jButton = new JButton("Add Level");
            jButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ Ed this$0;
                {
                    this.this$0 = ed;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    Ed.access$700(this.this$0).add(null);
                    Ed.access$800(this.this$0).add(null);
                    Ed.access$900(this.this$0).addEntry();
                }
            });
            jPanel3.add(jButton);
            jButton = new JButton("Remove Level");
            jButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ Ed this$0;
                {
                    this.this$0 = ed;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = Ed.access$900(this.this$0).getList().getSelectedIndex();
                    if (n >= 0) {
                        Ed.access$700(this.this$0).remove(n);
                        Ed.access$800(this.this$0).remove(n);
                        Ed.access$900(this.this$0).removeEntryAt(n);
                    }
                }
            });
            jPanel3.add(jButton);
            this.controls.add(jPanel3);
            this.images.getList().addListSelectionListener(new ListSelectionListener(this){
                private final /* synthetic */ Ed this$0;
                {
                    this.this$0 = ed;
                }

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    Ed.access$1000(this.this$0);
                }
            });
            this.reset(embellishment);
        }

        private void updateLevelName() {
            int n = this.images.getList().getSelectedIndex();
            if (n < 0) {
                this.levelNameInput.setText(null);
            } else {
                this.levelNameInput.setText((String)this.names.get(n));
                this.prefix.setSelected(PREFIX.equals(this.isPrefix.get(n)));
                this.suffix.setSelected(SUFFIX.equals(this.isPrefix.get(n)));
            }
        }

        private void changeLevelName() {
            int n = this.images.getList().getSelectedIndex();
            if (n >= 0) {
                String string = this.levelNameInput.getText();
                this.names.set(n, string);
                if (this.prefix.isSelected()) {
                    this.isPrefix.set(n, PREFIX);
                } else if (this.suffix.isSelected()) {
                    this.isPrefix.set(n, SUFFIX);
                } else {
                    this.isPrefix.set(n, NEITHER);
                }
            } else {
                this.names.set(n, null);
                this.isPrefix.set(n, NEITHER);
            }
        }

        public String getState() {
            return this.alwaysActive.isSelected() ? "1" : "-1";
        }

        public String getType() {
            SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
            ArrayList arrayList = new ArrayList();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            int n = 0;
            Enumeration enumeration = this.images.getImageNames();
            while (enumeration.hasMoreElements()) {
                arrayList.add(enumeration.nextElement());
                String string = (String)this.names.get(n);
                if (string != null && string.length() > 0) {
                    string = PREFIX.equals(this.isPrefix.get(n)) ? new SequenceEncoder(string, '+').append("").getValue() : (SUFFIX.equals(this.isPrefix.get(n)) ? new SequenceEncoder("", '+').append(string).getValue() : new SequenceEncoder(string, '+').getValue());
                }
                arrayList2.add(string);
                ++n;
            }
            try {
                Integer.parseInt(this.xOffInput.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.xOffInput.setText("0");
            }
            try {
                Integer.parseInt(this.yOffInput.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.yOffInput.setText("0");
            }
            sequenceEncoder.append(this.activateCommand.getText()).append(this.activateModifiers.getValueString()).append(this.activateKeyInput.getText()).append(this.upCommand.getText()).append(this.upModifiers.getValueString()).append(this.upKeyInput.getText()).append(this.downCommand.getText()).append(this.downModifiers.getValueString()).append(this.downKeyInput.getText()).append(this.resetCommand.getText()).append((KeyStroke)this.resetKey.getValue()).append(this.resetLevel.getText()).append(this.drawUnderneath.isSelected()).append(this.xOffInput.getText()).append(this.yOffInput.getText()).append(arrayList.toArray(new String[arrayList.size()])).append(arrayList2.toArray(new String[arrayList2.size()])).append(this.loop.isSelected()).append(this.name.getText()).append((KeyStroke)this.rndKeyConfig.getValue()).append(this.rndCommand.getText() == null ? "" : this.rndCommand.getText().trim());
            return Embellishment.ID + sequenceEncoder.getValue();
        }

        public String oldgetType() {
            Object object;
            Object object2;
            Object object3;
            SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
            int n = 0;
            Object object4 = this.images.getImageNames();
            while (object4.hasMoreElements()) {
                object3 = (String)object4.nextElement();
                object2 = (String)this.names.get(n);
                if (this.names.get(n) != null && object2 != null && ((String)object2).length() > 0) {
                    object = new SequenceEncoder((String)object3, ',');
                    object2 = PREFIX.equals(this.isPrefix.get(n)) ? new SequenceEncoder((String)object2, '+').append("").getValue() : (SUFFIX.equals(this.isPrefix.get(n)) ? new SequenceEncoder("", '+').append((String)object2).getValue() : new SequenceEncoder((String)object2, '+').getValue());
                    sequenceEncoder.append(((SequenceEncoder)object).append((String)object2).getValue());
                } else {
                    sequenceEncoder.append((String)object3);
                }
                ++n;
            }
            try {
                Integer.parseInt(this.xOffInput.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.xOffInput.setText("0");
            }
            try {
                Integer.parseInt(this.yOffInput.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.yOffInput.setText("0");
            }
            object4 = this.activateCommand.getText();
            if (this.drawUnderneath.isSelected()) {
                object4 = "_" + (String)object4;
            }
            object3 = new SequenceEncoder(this.activateKeyInput.getText(), ';');
            ((SequenceEncoder)object3).append(this.resetCommand.getText()).append((KeyStroke)this.resetKey.getValue()).append(this.resetLevel.getText());
            object2 = new SequenceEncoder(null, ';');
            ((SequenceEncoder)object2).append(((SequenceEncoder)object3).getValue()).append((String)object4).append(this.upKeyInput.getText()).append(this.upCommand.getText()).append(this.downKeyInput.getText()).append(this.downCommand.getText()).append(this.xOffInput.getText()).append(this.yOffInput.getText());
            object = Embellishment.ID + ((SequenceEncoder)object2).getValue() + ';' + (sequenceEncoder.getValue() == null ? "" : sequenceEncoder.getValue());
            return object;
        }

        public Component getControls() {
            return this.controls;
        }

        public void reset(Embellishment embellishment) {
            this.name.setText(embellishment.name);
            this.names = new Vector();
            this.isPrefix = new Vector();
            for (int i = 0; i < embellishment.commonName.length; ++i) {
                String string = embellishment.commonName[i];
                Integer n = NEITHER;
                if (string != null && string.length() > 0) {
                    SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, '+');
                    String string2 = decoder.nextToken();
                    if (decoder.hasMoreTokens()) {
                        String string3 = decoder.nextToken();
                        if (string2.length() == 0) {
                            string = string3;
                            n = SUFFIX;
                        } else {
                            string = string2;
                            n = PREFIX;
                        }
                    } else {
                        string = string2;
                    }
                }
                this.names.add(string);
                this.isPrefix.add(n);
            }
            this.alwaysActive.setSelected(embellishment.activateKey.length() == 0);
            this.drawUnderneath.setSelected(embellishment.drawUnderneathWhenSelected);
            this.loop.setSelected(embellishment.loopLevels);
            this.images.clear();
            this.activateKeyInput.setText(embellishment.activateKey);
            this.activateCommand.setText(embellishment.activateCommand);
            this.activateModifiers.setValue(new Integer(embellishment.activateModifiers));
            this.upKeyInput.setText(embellishment.upKey);
            this.upCommand.setText(embellishment.upCommand);
            this.upModifiers.setValue(new Integer(embellishment.upModifiers));
            this.downKeyInput.setText(embellishment.downKey);
            this.downCommand.setText(embellishment.downCommand);
            this.downModifiers.setValue(new Integer(embellishment.downModifiers));
            this.resetKey.setValue(embellishment.resetKey);
            this.resetCommand.setText(embellishment.resetCommand);
            this.resetLevel.setText(String.valueOf(embellishment.resetLevel));
            this.xOffInput.setText("" + embellishment.xOff);
            this.yOffInput.setText("" + embellishment.yOff);
            this.images.setImageList(embellishment.imageName);
            if (!this.images.getImageNames().hasMoreElements()) {
                this.names.add(null);
                this.isPrefix.add(null);
                this.images.addEntry();
            }
            this.updateLevelName();
        }

        static /* synthetic */ JCheckBox access$100(Ed ed) {
            return ed.alwaysActive;
        }

        static /* synthetic */ JTextField access$200(Ed ed) {
            return ed.activateCommand;
        }

        static /* synthetic */ JTextField access$300(Ed ed) {
            return ed.activateKeyInput;
        }

        static /* synthetic */ void access$400(Ed ed) {
            ed.changeLevelName();
        }

        static /* synthetic */ JRadioButton access$500(Ed ed) {
            return ed.prefix;
        }

        static /* synthetic */ JRadioButton access$600(Ed ed) {
            return ed.suffix;
        }

        static /* synthetic */ List access$700(Ed ed) {
            return ed.names;
        }

        static /* synthetic */ List access$800(Ed ed) {
            return ed.isPrefix;
        }

        static /* synthetic */ MultiImagePicker access$900(Ed ed) {
            return ed.images;
        }

        static /* synthetic */ void access$1000(Ed ed) {
            ed.updateLevelName();
        }
    }
}

