/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.Drawable;
import VASSAL.command.ChangeTracker;
import VASSAL.command.Command;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.HotKeyConfigurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.EditablePiece;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.PieceImage;
import VASSAL.tools.RotateFilter;
import VASSAL.tools.SequenceEncoder;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class FreeRotator
extends Decorator
implements EditablePiece,
MouseListener,
MouseMotionListener,
Drawable {
    public static final String ID = "rotate;";
    public static final String FACING = "_Facing";
    public static final String DEGREES = "_Degrees";
    public static final double PI_180 = Math.PI / 180;
    protected KeyCommand setAngleCommand;
    protected KeyCommand rotateCWCommand;
    protected KeyCommand rotateCCWCommand;
    protected KeyCommand[] commands;
    protected KeyStroke setAngleKey;
    protected String setAngleText = "Rotate";
    protected KeyStroke rotateCWKey;
    protected String rotateCWText = "Rotate CW";
    protected KeyStroke rotateCCWKey;
    protected String rotateCCWText = "Rotate CCW";
    protected String name = "Rotate";
    protected KeyCommand rotateRNDCommand;
    protected String rotateRNDText = "";
    protected KeyStroke rotateRNDKey;
    protected boolean useUnrotatedShape;
    protected double[] validAngles = new double[]{0.0};
    protected int angleIndex = 0;
    protected java.util.Map images = new HashMap();
    protected java.util.Map bounds = new HashMap();
    protected PieceImage unrotated;
    protected double tempAngle;
    protected double startAngle;
    protected Point pivot;
    protected boolean drawGhost;

    public FreeRotator() {
        this("rotate;6;];[;Rotate CW;Rotate CCW;;;;", null);
    }

    public FreeRotator(String string, GamePiece gamePiece) {
        this.mySetType(string);
        this.setInner(gamePiece);
    }

    public String getName() {
        return this.piece.getName();
    }

    public void setInner(GamePiece gamePiece) {
        this.unrotated = new PieceImage(gamePiece);
        super.setInner(gamePiece);
    }

    private double centerX() {
        return this.piece.boundingBox().getWidth() % 2.0 / 2.0;
    }

    private double centerY() {
        return this.piece.boundingBox().getHeight() % 2.0 / 2.0;
    }

    public Rectangle boundingBox() {
        if (this.getAngle() == 0.0) {
            return this.piece.boundingBox();
        }
        return AffineTransform.getRotateInstance(-Math.PI / 180 * this.getAngle(), this.centerX(), this.centerY()).createTransformedShape(this.piece.boundingBox()).getBounds();
    }

    public double getAngle() {
        if (this.useUnrotatedShape) {
            return 0.0;
        }
        return this.validAngles[this.angleIndex];
    }

    public void setAngle(double d) {
        if (this.validAngles.length == 1) {
            this.validAngles[this.angleIndex] = d;
        } else {
            int n = this.angleIndex;
            double d2 = Math.abs((this.validAngles[this.angleIndex] - d + 360.0) % 360.0);
            for (int i = 0; i < this.validAngles.length; ++i) {
                if (!(d2 > Math.abs((this.validAngles[i] - d + 360.0) % 360.0))) continue;
                n = i;
                d2 = Math.abs((this.validAngles[i] - d + 360.0) % 360.0);
            }
            this.angleIndex = n;
        }
    }

    public Rectangle getRotatedBounds() {
        Rectangle rectangle = (Rectangle)this.bounds.get(new Double(this.getAngle()));
        if (rectangle == null) {
            rectangle = this.piece.boundingBox();
        }
        return rectangle;
    }

    public Shape getShape() {
        if (this.getAngle() == 0.0) {
            return this.piece.getShape();
        }
        return AffineTransform.getRotateInstance(this.getAngleInRadians(), this.centerX(), this.centerY()).createTransformedShape(this.piece.getShape());
    }

    public double getAngleInRadians() {
        return -Math.PI / 180 * this.getAngle();
    }

    public void mySetType(String string) {
        string = string.substring(ID.length());
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        this.validAngles = new double[Integer.parseInt(decoder.nextToken())];
        for (int i = 0; i < this.validAngles.length; ++i) {
            this.validAngles[i] = (double)(-i) * (360.0 / (double)this.validAngles.length);
        }
        if (this.validAngles.length == 1) {
            this.setAngleKey = decoder.nextKeyStroke(null);
            if (decoder.hasMoreTokens()) {
                this.setAngleText = decoder.nextToken();
            }
        } else {
            this.rotateCWKey = decoder.nextKeyStroke(null);
            this.rotateCCWKey = decoder.nextKeyStroke(null);
            this.rotateCWText = decoder.nextToken("");
            this.rotateCCWText = decoder.nextToken("");
        }
        this.rotateRNDKey = decoder.nextKeyStroke(null);
        this.rotateRNDText = decoder.nextToken("");
        this.name = decoder.nextToken("");
        this.commands = null;
    }

    public void draw(Graphics graphics, int n, int n2, Component component, double d) {
        if (this.getAngle() == 0.0) {
            this.piece.draw(graphics, n, n2, component, d);
        } else {
            Image image = this.getRotatedImage(this.getAngle(), component);
            Rectangle rectangle = this.getRotatedBounds();
            Image image2 = GameModule.getGameModule().getDataArchive().getScaledImage(image, d);
            graphics.drawImage(image2, n + (int)(d * (double)rectangle.x), n2 + (int)(d * (double)rectangle.y), component);
        }
    }

    public void draw(Graphics graphics, Map map) {
        if (this.drawGhost && graphics instanceof Graphics2D) {
            Point point = map.componentCoordinates(this.getGhostPosition());
            Graphics2D graphics2D = (Graphics2D)graphics;
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.transform(AffineTransform.getRotateInstance(-Math.PI / 180 * this.tempAngle, (double)point.x + this.centerX(), (double)point.y + this.centerY()));
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.piece.draw(graphics, point.x, point.y, map.getView(), map.getZoom());
            graphics2D.setTransform(affineTransform);
        }
    }

    public boolean drawAboveCounters() {
        return true;
    }

    private Point getGhostPosition() {
        AffineTransform affineTransform = AffineTransform.getRotateInstance(-Math.PI / 180 * (this.tempAngle - this.getAngle()), (double)this.pivot.x + this.centerX(), (double)this.pivot.y + this.centerY());
        Point2D.Float float_ = new Point2D.Float(this.getPosition().x, this.getPosition().y);
        affineTransform.transform(float_, float_);
        return new Point((int)Math.round(((Point2D)float_).getX()), (int)Math.round(((Point2D)float_).getY()));
    }

    public String myGetType() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
        sequenceEncoder.append(this.validAngles.length);
        if (this.validAngles.length == 1) {
            sequenceEncoder.append(this.setAngleKey);
            sequenceEncoder.append(this.setAngleText);
        } else {
            sequenceEncoder.append(this.rotateCWKey).append(this.rotateCCWKey).append(this.rotateCWText).append(this.rotateCCWText);
        }
        sequenceEncoder.append(this.rotateRNDKey);
        sequenceEncoder.append(this.rotateRNDText);
        sequenceEncoder.append(this.name);
        return ID + sequenceEncoder.getValue();
    }

    public String myGetState() {
        if (this.validAngles.length == 1) {
            return "" + this.validAngles[0];
        }
        return "" + this.angleIndex;
    }

    public void mySetState(String string) {
        if (this.validAngles.length == 1) {
            this.validAngles[0] = Double.valueOf(string);
        } else {
            this.angleIndex = Integer.parseInt(string);
        }
    }

    public KeyCommand[] myGetKeyCommands() {
        if (this.commands == null) {
            ArrayList<KeyCommand> arrayList = new ArrayList<KeyCommand>();
            GamePiece gamePiece = Decorator.getOutermost(this);
            this.setAngleCommand = new KeyCommand(this.setAngleText, this.setAngleKey, gamePiece);
            this.rotateCWCommand = new KeyCommand(this.rotateCWText, this.rotateCWKey, gamePiece);
            this.rotateCCWCommand = new KeyCommand(this.rotateCCWText, this.rotateCCWKey, gamePiece);
            this.rotateRNDCommand = new KeyCommand(this.rotateRNDText, this.rotateRNDKey, gamePiece);
            if (this.validAngles.length == 1) {
                if (this.setAngleText.length() > 0) {
                    arrayList.add(this.setAngleCommand);
                } else {
                    this.setAngleCommand.setEnabled(false);
                }
                this.rotateCWCommand.setEnabled(false);
                this.rotateCCWCommand.setEnabled(false);
            } else {
                if (this.rotateCWText.length() > 0 && this.rotateCCWText.length() > 0) {
                    arrayList.add(this.rotateCWCommand);
                    arrayList.add(this.rotateCCWCommand);
                } else if (this.rotateCWText.length() > 0) {
                    arrayList.add(this.rotateCWCommand);
                    this.rotateCCWCommand.setEnabled(this.rotateCCWKey != null);
                } else if (this.rotateCCWText.length() > 0) {
                    arrayList.add(this.rotateCCWCommand);
                    this.rotateCWCommand.setEnabled(this.rotateCWKey != null);
                }
                this.setAngleCommand.setEnabled(false);
            }
            if (this.rotateRNDText.length() > 0) {
                arrayList.add(this.rotateRNDCommand);
            }
            this.commands = arrayList.toArray(new KeyCommand[arrayList.size()]);
        }
        this.setAngleCommand.setEnabled(this.getMap() != null && this.validAngles.length == 1 && this.setAngleText.length() > 0);
        return this.commands;
    }

    public Command myKeyEvent(KeyStroke keyStroke) {
        this.myGetKeyCommands();
        Command command = null;
        if (this.setAngleCommand.matches(keyStroke)) {
            this.beginInteractiveRotate();
        } else if (this.rotateCWCommand.matches(keyStroke)) {
            ChangeTracker changeTracker = new ChangeTracker(this);
            this.angleIndex = (this.angleIndex + 1) % this.validAngles.length;
            command = changeTracker.getChangeCommand();
        } else if (this.rotateCCWCommand.matches(keyStroke)) {
            ChangeTracker changeTracker = new ChangeTracker(this);
            this.angleIndex = (this.angleIndex - 1 + this.validAngles.length) % this.validAngles.length;
            command = changeTracker.getChangeCommand();
        } else if (this.rotateRNDCommand.matches(keyStroke)) {
            ChangeTracker changeTracker = new ChangeTracker(this);
            Random random = GameModule.getGameModule().getRNG();
            if (this.validAngles.length == 1) {
                this.setAngle(random.nextDouble() * 360.0);
            } else {
                this.angleIndex = random.nextInt(this.validAngles.length);
            }
            command = changeTracker.getChangeCommand();
        }
        return command;
    }

    public void beginInteractiveRotate() {
        this.getMap().pushMouseListener(this);
        this.getMap().addDrawComponent(this);
        this.getMap().getView().addMouseMotionListener(this);
        this.getMap().getView().setCursor(Cursor.getPredefinedCursor(1));
        this.pivot = this.getPosition();
    }

    public void setPivot(int n, int n2) {
        this.pivot = new Point(n, n2);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.drawGhost = true;
        this.startAngle = this.getRelativeAngle(mouseEvent.getPoint(), this.getPosition());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseReleased(MouseEvent mouseEvent) {
        try {
            Point point = this.getGhostPosition();
            Command command = null;
            ChangeTracker changeTracker = new ChangeTracker(this);
            if (!this.getPosition().equals(point)) {
                GamePiece gamePiece = Decorator.getOutermost(this);
                gamePiece.setProperty("Moved", Boolean.TRUE);
                command = this.getMap().placeOrMerge(gamePiece, this.getMap().snapTo(point));
            }
            this.setAngle(this.tempAngle);
            command = changeTracker.getChangeCommand().append(command);
            GameModule.getGameModule().sendAndLog(command);
            Object var7_6 = null;
            this.getMap().getView().setCursor(null);
            this.getMap().removeDrawComponent(this);
            this.getMap().popMouseListener();
            this.getMap().getView().removeMouseMotionListener(this);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.getMap().getView().setCursor(null);
            this.getMap().removeDrawComponent(this);
            this.getMap().popMouseListener();
            this.getMap().getView().removeMouseMotionListener(this);
            throw throwable;
        }
    }

    public void setProperty(Object object, Object object2) {
        if ("useUnrotatedShape".equals(object)) {
            this.useUnrotatedShape = Boolean.TRUE.equals(object2);
        }
        super.setProperty(object, object2);
    }

    public Object getProperty(Object object) {
        if ((this.name + FACING).equals(object)) {
            return String.valueOf(this.angleIndex + 1);
        }
        if ((this.name + DEGREES).equals(object)) {
            return String.valueOf((int)Math.abs(this.validAngles[this.angleIndex]));
        }
        return super.getProperty(object);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.drawGhost) {
            Point point = this.getMap().mapCoordinates(mouseEvent.getPoint());
            double d = this.getRelativeAngle(point, this.pivot);
            this.tempAngle = this.getAngle() - (d - this.startAngle) / (Math.PI / 180);
        }
        this.getMap().repaint();
    }

    private double getRelativeAngle(Point point, Point point2) {
        double d;
        if (point.y == point2.y) {
            d = point.x < point2.x ? 1.5707963267948966 : -1.5707963267948966;
        } else {
            d = Math.atan((float)(point.x - point2.x) / (float)(point2.y - point.y));
            if (point2.y < point.y) {
                d += Math.PI;
            }
        }
        return d;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public Image getRotatedImage(double d, Component component) {
        Image image = this.getCachedUnrotatedImage(d);
        if (this.unrotated.isChanged()) {
            this.clearCachedImages();
            image = null;
        }
        if (image == null) {
            Rectangle rectangle = this.piece.boundingBox();
            Rectangle rectangle2 = this.boundingBox();
            if (rectangle2.width > 0 && rectangle2.height > 0) {
                image = new BufferedImage(rectangle2.width, rectangle2.height, 6);
                ((BufferedImage)image).setRGB(0, 0, rectangle2.width, rectangle2.height, new int[rectangle2.width * rectangle2.height], 0, rectangle2.width);
                Graphics2D graphics2D = ((BufferedImage)image).createGraphics();
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                AffineTransform affineTransform = AffineTransform.getTranslateInstance(-rectangle2.x, -rectangle2.y);
                affineTransform.rotate(-Math.PI / 180 * d, this.centerX(), this.centerY());
                affineTransform.translate(rectangle.x, rectangle.y);
                graphics2D.drawImage(this.unrotated.getImage(component), affineTransform, component);
            } else {
                RotateFilter rotateFilter = new RotateFilter(d);
                rectangle2 = this.piece.boundingBox();
                rotateFilter.transformSpace(rectangle2);
                FilteredImageSource filteredImageSource = new FilteredImageSource(this.unrotated.getImage(component).getSource(), rotateFilter);
                image = component.createImage(filteredImageSource);
            }
            this.images.put(new Double(d), image);
            this.bounds.put(new Double(d), rectangle2);
        }
        return image;
    }

    private Image getCachedUnrotatedImage(double d) {
        if (this.validAngles.length == 1) {
            d = this.validAngles[0];
        }
        Image image = (Image)this.images.get(new Double(d));
        return image;
    }

    private void clearCachedImages() {
        Iterator iterator = this.images.values().iterator();
        while (iterator.hasNext()) {
            Image image = (Image)iterator.next();
            GameModule.getGameModule().getDataArchive().unCacheImage(image);
        }
        this.images.clear();
        this.bounds.clear();
    }

    public String getDescription() {
        return "Can Rotate";
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Rotate.htm");
    }

    public PieceEditor getEditor() {
        return new Ed(this);
    }

    private static class Ed
    implements PieceEditor,
    PropertyChangeListener {
        private BooleanConfigurer anyConfig;
        private HotKeyConfigurer anyKeyConfig;
        private IntConfigurer facingsConfig;
        private HotKeyConfigurer cwKeyConfig;
        private HotKeyConfigurer ccwKeyConfig;
        private HotKeyConfigurer rndKeyConfig;
        private StringConfigurer nameConfig;
        private JTextField anyCommand;
        private JTextField cwCommand;
        private JTextField ccwCommand;
        private JTextField rndCommand;
        private Box anyControls;
        private Box cwControls;
        private Box ccwControls;
        private Box rndControls;
        private JPanel panel;

        public Ed(FreeRotator freeRotator) {
            this.nameConfig = new StringConfigurer(null, "Description:  ", freeRotator.name);
            this.cwKeyConfig = new HotKeyConfigurer(null, "Command to rotate clockwise:  ", freeRotator.rotateCWKey);
            this.ccwKeyConfig = new HotKeyConfigurer(null, "Command to rotate counterclockwise:  ", freeRotator.rotateCCWKey);
            this.rndKeyConfig = new HotKeyConfigurer(null, "Command to rotate randomly:  ", freeRotator.rotateRNDKey);
            this.anyConfig = new BooleanConfigurer(null, "Allow arbitrary rotations", new Boolean(freeRotator.validAngles.length == 1));
            this.anyKeyConfig = new HotKeyConfigurer(null, "Command to rotate:  ", freeRotator.setAngleKey);
            this.facingsConfig = new IntConfigurer(null, "Number of allowed facings:  ", new Integer(freeRotator.validAngles.length == 1 ? 6 : freeRotator.validAngles.length));
            this.panel = new JPanel();
            this.panel.setLayout(new BoxLayout(this.panel, 1));
            this.panel.add(this.nameConfig.getControls());
            this.panel.add(this.facingsConfig.getControls());
            this.cwControls = Box.createHorizontalBox();
            this.cwControls.add(this.cwKeyConfig.getControls());
            this.cwControls.add(new JLabel(" Menu text:  "));
            this.cwCommand = new JTextField(12);
            this.cwCommand.setMaximumSize(this.cwCommand.getPreferredSize());
            this.cwCommand.setText(freeRotator.rotateCWText);
            this.cwControls.add(this.cwCommand);
            this.panel.add(this.cwControls);
            this.ccwControls = Box.createHorizontalBox();
            this.ccwControls.add(this.ccwKeyConfig.getControls());
            this.ccwControls.add(new JLabel(" Menu text:  "));
            this.ccwCommand = new JTextField(12);
            this.ccwCommand.setMaximumSize(this.ccwCommand.getPreferredSize());
            this.ccwCommand.setText(freeRotator.rotateCCWText);
            this.ccwControls.add(this.ccwCommand);
            this.panel.add(this.ccwControls);
            this.panel.add(this.anyConfig.getControls());
            this.anyControls = Box.createHorizontalBox();
            this.anyControls.add(this.anyKeyConfig.getControls());
            this.anyControls.add(new JLabel(" Menu text:  "));
            this.anyCommand = new JTextField(12);
            this.anyCommand.setMaximumSize(this.anyCommand.getPreferredSize());
            this.anyCommand.setText(freeRotator.setAngleText);
            this.anyControls.add(this.anyCommand);
            this.panel.add(this.anyControls);
            this.rndControls = Box.createHorizontalBox();
            this.rndControls.add(this.rndKeyConfig.getControls());
            this.rndControls.add(new JLabel(" Menu text:  "));
            this.rndCommand = new JTextField(12);
            this.rndCommand.setMaximumSize(this.rndCommand.getPreferredSize());
            this.rndCommand.setText(freeRotator.rotateRNDText);
            this.rndControls.add(this.rndCommand);
            this.panel.add(this.rndControls);
            this.anyConfig.addPropertyChangeListener(this);
            this.propertyChange(null);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            boolean bl = Boolean.TRUE.equals(this.anyConfig.getValue());
            this.anyControls.setVisible(bl);
            this.facingsConfig.getControls().setVisible(!bl);
            this.cwControls.setVisible(!bl);
            this.ccwControls.setVisible(!bl);
            this.panel.revalidate();
        }

        public Component getControls() {
            return this.panel;
        }

        public String getType() {
            SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
            if (Boolean.TRUE.equals(this.anyConfig.getValue())) {
                sequenceEncoder.append("1");
                sequenceEncoder.append((KeyStroke)this.anyKeyConfig.getValue());
                sequenceEncoder.append(this.anyCommand.getText() == null ? "" : this.anyCommand.getText().trim());
            } else {
                sequenceEncoder.append(this.facingsConfig.getValueString());
                sequenceEncoder.append((KeyStroke)this.cwKeyConfig.getValue());
                sequenceEncoder.append((KeyStroke)this.ccwKeyConfig.getValue());
                sequenceEncoder.append(this.cwCommand.getText() == null ? "" : this.cwCommand.getText().trim());
                sequenceEncoder.append(this.ccwCommand.getText() == null ? "" : this.ccwCommand.getText().trim());
            }
            sequenceEncoder.append((KeyStroke)this.rndKeyConfig.getValue());
            sequenceEncoder.append(this.rndCommand.getText() == null ? "" : this.rndCommand.getText().trim());
            sequenceEncoder.append(this.nameConfig.getValueString());
            return FreeRotator.ID + sequenceEncoder.getValue();
        }

        public String getState() {
            return "0";
        }
    }
}

