/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.Map;
import VASSAL.command.Command;
import VASSAL.command.NullCommand;
import VASSAL.counters.BoundsTracker;
import VASSAL.counters.Deck;
import VASSAL.counters.DeckVisitor;
import VASSAL.counters.DeckVisitorDispatcher;
import VASSAL.counters.GamePiece;
import VASSAL.counters.PieceCloner;
import VASSAL.counters.PieceFilter;
import VASSAL.counters.PieceIterator;
import VASSAL.counters.Stack;
import VASSAL.tools.FormattedString;
import java.util.Enumeration;
import javax.swing.KeyStroke;

public class GlobalCommand {
    protected KeyStroke keyStroke;
    protected boolean reportSingle;
    protected int selectFromDeck = -1;
    protected FormattedString reportFormat = new FormattedString();

    public void setKeyStroke(KeyStroke keyStroke) {
        this.keyStroke = keyStroke;
    }

    public void setReportFormat(String string) {
        this.reportFormat.setFormat(string);
    }

    public KeyStroke getKeyStroke() {
        return this.keyStroke;
    }

    public String getReportFormat() {
        return this.reportFormat.getFormat();
    }

    public boolean isReportSingle() {
        return this.reportSingle;
    }

    public void setReportSingle(boolean bl) {
        this.reportSingle = bl;
    }

    public Command apply(Map map, PieceFilter pieceFilter) {
        return this.apply(new Map[]{map}, pieceFilter);
    }

    public Command apply(Map[] mapArray, PieceFilter pieceFilter) {
        Command command;
        String string = this.reportFormat.getText();
        if (string.length() > 0) {
            command = new Chatter.DisplayText(GameModule.getGameModule().getChatter(), "*" + string);
            command.execute();
        } else {
            command = new NullCommand();
        }
        for (int i = 0; i < mapArray.length; ++i) {
            String string2 = mapArray[i].getChangeFormat();
            if (this.reportSingle) {
                mapArray[i].setAttribute("changeFormat", "");
            }
            Visitor visitor = new Visitor(command, pieceFilter, this.keyStroke);
            DeckVisitorDispatcher deckVisitorDispatcher = new DeckVisitorDispatcher(visitor);
            GamePiece[] gamePieceArray = mapArray[i].getPieces();
            for (int j = 0; j < gamePieceArray.length; ++j) {
                deckVisitorDispatcher.accept(gamePieceArray[j]);
            }
            visitor.getTracker().repaint();
            if (this.reportSingle) {
                mapArray[i].setAttribute("changeFormat", string2);
            }
            command = visitor.getCommand();
        }
        return command;
    }

    public int getSelectFromDeck() {
        return this.selectFromDeck;
    }

    public void setSelectFromDeck(int n) {
        this.selectFromDeck = n;
    }

    private class Visitor
    implements DeckVisitor {
        private Command command;
        private BoundsTracker tracker;
        private PieceFilter filter;
        private KeyStroke stroke;

        public Visitor(Command command, PieceFilter pieceFilter, KeyStroke keyStroke) {
            this.command = command;
            this.tracker = new BoundsTracker();
            this.filter = pieceFilter;
            this.stroke = keyStroke;
        }

        public Object visitDeck(Deck deck) {
            Object var2_2 = null;
            if (GlobalCommand.this.selectFromDeck != 0) {
                deck.setDragCount(GlobalCommand.this.selectFromDeck < 0 ? deck.getPieceCount() : GlobalCommand.this.selectFromDeck);
                PieceIterator pieceIterator = deck.drawCards();
                while (pieceIterator.hasMoreElements()) {
                    this.apply(pieceIterator.nextPiece());
                }
            }
            return var2_2;
        }

        public Object visitStack(Stack stack) {
            Enumeration enumeration = stack.getPieces();
            while (enumeration.hasMoreElements()) {
                this.apply((GamePiece)enumeration.nextElement());
            }
            return null;
        }

        public Object visitDefault(GamePiece gamePiece) {
            this.apply(gamePiece);
            return null;
        }

        private void apply(GamePiece gamePiece) {
            if (this.filter == null || this.filter.accept(gamePiece)) {
                this.tracker.addPiece(gamePiece);
                gamePiece.setProperty("snapshot", PieceCloner.getInstance().clonePiece(gamePiece));
                this.command.append(gamePiece.keyEvent(this.stroke));
                this.tracker.addPiece(gamePiece);
            }
        }

        public Command getCommand() {
            return this.command;
        }

        public BoundsTracker getTracker() {
            return this.tracker;
        }
    }
}

