/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.ChangeTracker;
import VASSAL.command.Command;
import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.HotKeyConfigurer;
import VASSAL.configure.PieceAccessConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.EditablePiece;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceAccess;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.PlayerAccess;
import VASSAL.tools.SequenceEncoder;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class Hideable
extends Decorator
implements EditablePiece {
    public static final String ID = "hide;";
    public static final String HIDDEN_BY = "hiddenBy";
    protected String hiddenBy;
    protected KeyStroke hideKey;
    protected String command = "Invisible";
    protected PieceAccess access = PlayerAccess.getInstance();
    protected Color bgColor;
    protected KeyCommand[] commands;
    protected KeyCommand hideCommand;

    public void setProperty(Object object, Object object2) {
        if (HIDDEN_BY.equals(object)) {
            this.hiddenBy = (String)object2;
        } else {
            super.setProperty(object, object2);
        }
    }

    public Object getProperty(Object object) {
        if (HIDDEN_BY.equals(object)) {
            return this.hiddenBy;
        }
        if ("Invisible".equals(object)) {
            return this.invisibleToMe() ? Boolean.TRUE : Boolean.FALSE;
        }
        if ("InvisibleToOthers".equals(object)) {
            return this.invisibleToOthers() ? Boolean.TRUE : Boolean.FALSE;
        }
        return super.getProperty(object);
    }

    public Hideable() {
        this("hide;I", null);
    }

    public Hideable(String string, GamePiece gamePiece) {
        this.setInner(gamePiece);
        this.mySetType(string);
    }

    public void mySetType(String string) {
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        decoder.nextToken();
        this.hideKey = decoder.nextKeyStroke('I');
        this.command = decoder.nextToken("Invisible");
        this.bgColor = decoder.nextColor(null);
        this.access = PieceAccessConfigurer.decode(decoder.nextToken(null));
        this.commands = null;
    }

    public void mySetState(String string) {
        this.hiddenBy = "null".equals(string) ? null : string;
    }

    public String myGetType() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
        sequenceEncoder.append(this.hideKey).append(this.command).append(this.bgColor).append(PieceAccessConfigurer.encode(this.access));
        return ID + sequenceEncoder.getValue();
    }

    public String myGetState() {
        return this.hiddenBy == null ? "null" : this.hiddenBy;
    }

    public boolean invisibleToMe() {
        return !this.access.currentPlayerHasAccess(this.hiddenBy);
    }

    public boolean invisibleToOthers() {
        return this.hiddenBy != null;
    }

    public Shape getShape() {
        if (this.invisibleToMe()) {
            return new Rectangle();
        }
        return this.piece.getShape();
    }

    public Rectangle boundingBox() {
        if (this.invisibleToMe()) {
            return new Rectangle();
        }
        return this.piece.boundingBox();
    }

    public void draw(Graphics graphics, int n, int n2, Component component, double d) {
        if (this.invisibleToMe()) {
            return;
        }
        if (this.invisibleToOthers()) {
            Object object;
            Graphics2D graphics2D;
            if (this.bgColor != null) {
                graphics2D = (Graphics2D)graphics;
                graphics.setColor(this.bgColor);
                object = AffineTransform.getScaleInstance(d, d);
                ((AffineTransform)object).translate((double)n / d, (double)n2 / d);
                graphics2D.fill(((AffineTransform)object).createTransformedShape(this.piece.getShape()));
            }
            if (graphics instanceof Graphics2D) {
                graphics2D = (Graphics2D)graphics;
                object = graphics2D.getComposite();
                graphics2D.setComposite(AlphaComposite.getInstance(3, 0.3f));
                this.piece.draw(graphics, n, n2, component, d);
                graphics2D.setComposite((Composite)object);
            }
        } else {
            this.piece.draw(graphics, n, n2, component, d);
        }
    }

    public String getName() {
        if (this.invisibleToMe()) {
            return "";
        }
        if (this.invisibleToOthers()) {
            return this.piece.getName() + "(" + this.command + ")";
        }
        return this.piece.getName();
    }

    public KeyCommand[] myGetKeyCommands() {
        if (this.commands == null) {
            this.hideCommand = new KeyCommand(this.command, this.hideKey, Decorator.getOutermost(this));
            this.commands = this.command.length() > 0 && this.hideKey != null ? new KeyCommand[]{this.hideCommand} : new KeyCommand[0];
        }
        this.hideCommand.setEnabled(this.access.currentPlayerCanModify(this.hiddenBy));
        return this.commands;
    }

    public Command myKeyEvent(KeyStroke keyStroke) {
        this.myGetKeyCommands();
        if (this.hideCommand.matches(keyStroke)) {
            ChangeTracker changeTracker = new ChangeTracker(this);
            if (this.invisibleToOthers()) {
                this.hiddenBy = null;
            } else if (!this.invisibleToMe()) {
                this.hiddenBy = this.access.getCurrentPlayerId();
            }
            return changeTracker.getChangeCommand();
        }
        return null;
    }

    public String getDescription() {
        return "Invisible";
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Hideable.htm");
    }

    public PieceEditor getEditor() {
        return new Ed(this);
    }

    public static void setAllHidden(boolean bl) {
        if (bl) {
            PieceAccess.GlobalAccess.hideAll();
        } else {
            PieceAccess.GlobalAccess.revertAll();
        }
    }

    protected static class Ed
    implements PieceEditor {
        protected HotKeyConfigurer hideKeyInput;
        protected JTextField hideCommandInput;
        protected ColorConfigurer colorConfig;
        protected PieceAccessConfigurer accessConfig;
        protected JPanel controls = new JPanel();

        public Ed(Hideable hideable) {
            this.controls.setLayout(new BoxLayout(this.controls, 1));
            this.hideKeyInput = new HotKeyConfigurer(null, "Keyboard command:  ", hideable.hideKey);
            this.controls.add(this.hideKeyInput.getControls());
            Box box = Box.createHorizontalBox();
            this.hideCommandInput = new JTextField(16);
            this.hideCommandInput.setMaximumSize(this.hideCommandInput.getPreferredSize());
            this.hideCommandInput.setText(hideable.command);
            box.add(new JLabel("Menu Text:  "));
            box.add(this.hideCommandInput);
            this.controls.add(box);
            this.colorConfig = new ColorConfigurer(null, "Background color:  ", hideable.bgColor);
            this.controls.add(this.colorConfig.getControls());
            this.accessConfig = new PieceAccessConfigurer(null, "Can by hidden by:  ", hideable.access);
            this.controls.add(this.accessConfig.getControls());
        }

        public String getState() {
            return "null";
        }

        public String getType() {
            SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
            sequenceEncoder.append((KeyStroke)this.hideKeyInput.getValue()).append(this.hideCommandInput.getText()).append(this.colorConfig.getValue() == null ? "" : this.colorConfig.getValueString()).append(this.accessConfig.getValueString());
            return Hideable.ID + sequenceEncoder.getValue();
        }

        public Component getControls() {
            return this.controls;
        }
    }
}

