/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.counters.Decorator;
import VASSAL.counters.EditablePiece;
import VASSAL.counters.EventFilter;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.InputEvent;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.KeyStroke;

public class Immobilized
extends Decorator
implements EditablePiece {
    public static final String ID = "immob;";
    protected boolean shiftToSelect = false;
    protected boolean ctlShiftToSelect = false;
    protected boolean ignoreGrid = false;
    protected boolean neverSelect = false;
    protected boolean neverMove = false;
    protected boolean moveIfSelected = false;
    protected EventFilter selectFilter;
    protected EventFilter moveFilter;
    protected static final char MOVE_SELECTED = 'I';
    protected static final char MOVE_NORMAL = 'N';
    protected static final char NEVER_MOVE = 'V';
    protected static final char IGNORE_GRID = 'g';
    protected static final char SHIFT_SELECT = 'i';
    protected static final char CTL_SHIFT_SELECT = 'c';
    protected static final char NEVER_SELECT = 'n';
    protected static EventFilter NEVER = new EventFilter(){

        public boolean rejectEvent(InputEvent inputEvent) {
            return true;
        }
    };

    public Immobilized() {
        this(null, ID);
    }

    public Immobilized(GamePiece gamePiece, String string) {
        this.setInner(gamePiece);
        this.mySetType(string);
    }

    public void mySetType(String string) {
        this.shiftToSelect = false;
        this.ctlShiftToSelect = false;
        this.neverSelect = false;
        this.ignoreGrid = false;
        this.neverMove = false;
        this.moveIfSelected = false;
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        decoder.nextToken();
        String string2 = decoder.nextToken("");
        String string3 = decoder.nextToken("");
        if (string2.indexOf(105) >= 0) {
            this.shiftToSelect = true;
            this.moveIfSelected = true;
        }
        if (string2.indexOf(99) >= 0) {
            this.ctlShiftToSelect = true;
            this.moveIfSelected = true;
        }
        if (string2.indexOf(110) >= 0) {
            this.neverSelect = true;
            this.neverMove = true;
        }
        if (string2.indexOf(103) >= 0) {
            this.ignoreGrid = true;
        }
        if (string3.length() > 0) {
            switch (string3.charAt(0)) {
                case 'V': {
                    this.neverMove = true;
                    this.moveIfSelected = false;
                    break;
                }
                case 'I': {
                    this.neverMove = false;
                    this.moveIfSelected = true;
                    break;
                }
                default: {
                    this.neverMove = false;
                    this.moveIfSelected = false;
                }
            }
        }
        this.selectFilter = this.neverSelect ? NEVER : (this.shiftToSelect ? new UseShift() : (this.ctlShiftToSelect ? new UseCtlShift() : null));
        this.moveFilter = this.neverMove ? NEVER : (this.moveIfSelected ? new MoveIfSelected() : null);
    }

    public String getName() {
        return this.piece.getName();
    }

    public KeyCommand[] myGetKeyCommands() {
        return new KeyCommand[0];
    }

    public Command myKeyEvent(KeyStroke keyStroke) {
        return null;
    }

    public Object getProperty(Object object) {
        if ("NoStack".equals(object)) {
            return Boolean.TRUE;
        }
        if ("Immobile".equals(object)) {
            return new Boolean(this.moveIfSelected || this.neverMove);
        }
        if ("IgnoreGrid".equals(object)) {
            return new Boolean(this.ignoreGrid);
        }
        if ("selectEventFilter".equals(object)) {
            return this.selectFilter;
        }
        if ("moveEventFilter".equals(object)) {
            return this.moveFilter;
        }
        return super.getProperty(object);
    }

    public void draw(Graphics graphics, int n, int n2, Component component, double d) {
        this.piece.draw(graphics, n, n2, component, d);
    }

    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    public Shape getShape() {
        return this.piece.getShape();
    }

    public String myGetType() {
        StringBuffer stringBuffer = new StringBuffer(ID);
        if (this.neverSelect) {
            stringBuffer.append('n');
        } else if (this.shiftToSelect) {
            stringBuffer.append('i');
        } else if (this.ctlShiftToSelect) {
            stringBuffer.append('c');
        }
        if (this.ignoreGrid) {
            stringBuffer.append('g');
        }
        stringBuffer.append(';');
        if (this.neverMove) {
            stringBuffer.append('V');
        } else if (this.moveIfSelected) {
            stringBuffer.append('I');
        } else {
            stringBuffer.append('N');
        }
        return stringBuffer.toString();
    }

    public String myGetState() {
        return "";
    }

    public void mySetState(String string) {
    }

    public String getDescription() {
        return "Does not stack";
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("NonStacking.htm");
    }

    public PieceEditor getEditor() {
        return new Ed(this);
    }

    private static class Ed
    implements PieceEditor {
        private JComboBox selectionOption = new JComboBox();
        private JComboBox movementOption;
        private JCheckBox ignoreGridBox;
        private Box controls;

        public Ed(Immobilized immobilized) {
            this.selectionOption.addItem("normally");
            this.selectionOption.addItem("when shift-key down");
            this.selectionOption.addItem("when ctl-shift-key down");
            this.selectionOption.addItem("never");
            if (immobilized.neverSelect) {
                this.selectionOption.setSelectedIndex(3);
            } else if (immobilized.ctlShiftToSelect) {
                this.selectionOption.setSelectedIndex(2);
            } else if (immobilized.shiftToSelect) {
                this.selectionOption.setSelectedIndex(1);
            } else {
                this.selectionOption.setSelectedIndex(0);
            }
            this.ignoreGridBox = new JCheckBox("Ignore map grid when moving");
            this.ignoreGridBox.setSelected(immobilized.ignoreGrid);
            this.controls = Box.createVerticalBox();
            Box box = Box.createHorizontalBox();
            box.add(new JLabel("Select piece  "));
            box.add(this.selectionOption);
            this.controls.add(box);
            this.movementOption = new JComboBox();
            this.movementOption.addItem("normally");
            this.movementOption.addItem("only if selected");
            this.movementOption.addItem("never");
            if (immobilized.neverMove) {
                this.movementOption.setSelectedIndex(2);
            } else if (immobilized.moveIfSelected) {
                this.movementOption.setSelectedIndex(1);
            } else {
                this.movementOption.setSelectedIndex(0);
            }
            box = Box.createHorizontalBox();
            box.add(new JLabel("Move piece  "));
            box.add(this.movementOption);
            this.controls.add(box);
            this.controls.add(this.ignoreGridBox);
        }

        public String getState() {
            return "";
        }

        public String getType() {
            String string = Immobilized.ID;
            switch (this.selectionOption.getSelectedIndex()) {
                case 1: {
                    string = string + 'i';
                    break;
                }
                case 2: {
                    string = string + 'c';
                    break;
                }
                case 3: {
                    string = string + 'n';
                }
            }
            if (this.ignoreGridBox.isSelected()) {
                string = string + 'g';
            }
            string = string + ';';
            switch (this.movementOption.getSelectedIndex()) {
                case 0: {
                    string = string + 'N';
                    break;
                }
                case 1: {
                    string = string + 'I';
                    break;
                }
                case 2: {
                    string = string + 'V';
                }
            }
            return string;
        }

        public Component getControls() {
            return this.controls;
        }
    }

    protected class MoveIfSelected
    implements EventFilter {
        protected MoveIfSelected() {
        }

        public boolean rejectEvent(InputEvent inputEvent) {
            return !Boolean.TRUE.equals(Immobilized.this.getProperty("Selected"));
        }
    }

    protected class UseCtlShift
    implements EventFilter {
        protected UseCtlShift() {
        }

        public boolean rejectEvent(InputEvent inputEvent) {
            return (!inputEvent.isShiftDown() || !inputEvent.isControlDown()) && !Boolean.TRUE.equals(Immobilized.this.getProperty("Selected"));
        }
    }

    protected class UseShift
    implements EventFilter {
        protected UseShift() {
        }

        public boolean rejectEvent(InputEvent inputEvent) {
            return !inputEvent.isShiftDown() && !Boolean.TRUE.equals(Immobilized.this.getProperty("Selected"));
        }
    }
}

