/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.command.Command;
import VASSAL.command.NullCommand;
import VASSAL.counters.BoundsTracker;
import VASSAL.counters.GamePiece;
import VASSAL.counters.PieceCloner;
import VASSAL.counters.PieceSorter;
import VASSAL.counters.Stack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.KeyStroke;

public class KeyBuffer {
    private static KeyBuffer theBuffer;
    private List pieces;
    private BoundsTracker bounds;
    private Comparator pieceSorter = new PieceSorter();

    private KeyBuffer() {
        this.pieces = new ArrayList();
        this.bounds = new BoundsTracker();
    }

    public static void init(KeyBuffer keyBuffer) {
        if (theBuffer == null) {
            theBuffer = keyBuffer;
        }
    }

    public static KeyBuffer getBuffer() {
        if (theBuffer == null) {
            theBuffer = new KeyBuffer();
        }
        return theBuffer;
    }

    public void add(GamePiece gamePiece) {
        if (gamePiece != null && !this.pieces.contains(gamePiece)) {
            this.pieces.add(gamePiece);
            gamePiece.setProperty("Selected", Boolean.TRUE);
        }
    }

    public void clear() {
        while (this.pieces.size() > 0) {
            this.remove((GamePiece)this.pieces.get(this.pieces.size() - 1));
        }
    }

    public void remove(GamePiece gamePiece) {
        if (gamePiece != null) {
            this.pieces.remove(gamePiece);
            gamePiece.setProperty("Selected", null);
        }
    }

    public boolean contains(GamePiece gamePiece) {
        if (gamePiece instanceof Stack) {
            Enumeration enumeration = ((Stack)gamePiece).getPieces();
            while (enumeration.hasMoreElements()) {
                if (this.pieces.contains(enumeration.nextElement())) continue;
                return false;
            }
            return true;
        }
        return this.pieces.contains(gamePiece);
    }

    public boolean isEmpty() {
        return this.pieces.size() == 0;
    }

    public Command keyCommand(KeyStroke keyStroke) {
        this.sort(this.pieceSorter);
        Command command = new NullCommand();
        this.bounds.clear();
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.pieces.iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            GamePiece gamePiece = (GamePiece)iterator.next();
            this.bounds.addPiece(gamePiece);
            gamePiece.setProperty("snapshot", PieceCloner.getInstance().clonePiece(gamePiece));
            Command command2 = gamePiece.keyEvent(keyStroke);
            command = command.append(command2);
            this.bounds.addPiece(gamePiece);
        }
        this.bounds.repaint();
        return command;
    }

    public Enumeration getPieces() {
        return Collections.enumeration(this.pieces);
    }

    public void sort(Comparator comparator) {
        Collections.sort(this.pieces, comparator);
    }

    public boolean containsChild(Stack stack) {
        Enumeration enumeration = stack.getPieces();
        while (enumeration.hasMoreElements()) {
            if (!this.contains((GamePiece)enumeration.nextElement())) continue;
            return true;
        }
        return false;
    }
}

