/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.command.Command;
import VASSAL.configure.HotKeyConfigurer;
import VASSAL.counters.BoundsTracker;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyBuffer;
import VASSAL.counters.PieceCloner;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;

public class KeyCommand
extends AbstractAction {
    private String name;
    private KeyStroke stroke;
    private GamePiece target;
    private boolean global;
    private boolean enabled = true;

    public KeyCommand(String string, KeyStroke keyStroke, GamePiece gamePiece) {
        super(keyStroke == null ? string : string + "  " + HotKeyConfigurer.getString(keyStroke));
        this.target = gamePiece;
        this.name = string;
        this.stroke = keyStroke;
    }

    public KeyCommand(String string, KeyStroke keyStroke, GamePiece gamePiece, boolean bl) {
        this(string, keyStroke, gamePiece);
        this.setEnabled(bl);
    }

    public String getName() {
        return this.name;
    }

    public boolean matches(KeyStroke keyStroke) {
        return this.isEnabled() && keyStroke != null && keyStroke.equals(this.stroke);
    }

    public KeyStroke getKeyStroke() {
        return this.stroke;
    }

    public GamePiece getTarget() {
        return this.target;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public void setGlobal(boolean bl) {
        this.global = bl;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.global) {
            GameModule.getGameModule().sendAndLog(KeyBuffer.getBuffer().keyCommand(this.stroke));
        } else {
            BoundsTracker boundsTracker = new BoundsTracker();
            GamePiece gamePiece = Decorator.getOutermost(this.target);
            boundsTracker.addPiece(gamePiece);
            gamePiece.setProperty("snapshot", PieceCloner.getInstance().clonePiece(gamePiece));
            Command command = gamePiece.keyEvent(this.stroke);
            if (this.target.getId() != null) {
                GameModule.getGameModule().sendAndLog(command);
            }
            boundsTracker.addPiece(gamePiece);
            boundsTracker.repaint();
        }
    }
}

