/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.ChangeTracker;
import VASSAL.command.Command;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.FormattedStringConfigurer;
import VASSAL.configure.HotKeyConfigurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.EditablePiece;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.tools.FormattedString;
import VASSAL.tools.SequenceEncoder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;

public class Labeler
extends Decorator
implements EditablePiece {
    public static final String ID = "label;";
    protected Color textBg = Color.black;
    protected Color textFg = Color.white;
    public static final int CENTER = 0;
    public static final int RIGHT = 1;
    public static final int LEFT = 2;
    public static final int TOP = 3;
    public static final int BOTTOM = 4;
    public static int HORIZONTAL_ALIGNMENT = 0;
    public static int VERTICAL_ALIGNMENT = 3;
    private String label = "";
    private String lastCachedLabel;
    private KeyStroke labelKey;
    private String menuCommand = "Change Label";
    private Font font = new Font("Dialog", 0, 10);
    private KeyCommand[] commands;
    private FormattedString nameFormat = new FormattedString("$pieceName$ ($label$)");
    private FormattedString labelFormat = new FormattedString("");
    private static final String PIECE_NAME = "pieceName";
    private static final String LABEL = "label";
    private Image labelImage;
    private JLabel lbl;
    private char verticalJust = (char)98;
    private char horizontalJust = (char)99;
    private char verticalPos = (char)116;
    private char horizontalPos = (char)99;
    private int verticalOffset = 0;
    private int horizontalOffset = 0;
    protected int rotateDegrees;
    protected String propertyName;
    protected KeyCommand menuKeyCommand;

    public Labeler() {
        this(ID, null);
    }

    public Labeler(String string, GamePiece gamePiece) {
        this.lbl = new JLabel();
        this.mySetType(string);
        this.setInner(gamePiece);
    }

    public void mySetType(String string) {
        this.commands = null;
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        decoder.nextToken();
        this.labelKey = decoder.nextKeyStroke(null);
        this.menuCommand = decoder.nextToken("Change Label");
        int n = decoder.nextInt(10);
        this.textBg = decoder.nextColor(null);
        this.textFg = decoder.nextColor(Color.black);
        this.verticalPos = decoder.nextChar('t');
        this.verticalOffset = decoder.nextInt(0);
        this.horizontalPos = decoder.nextChar('c');
        this.horizontalOffset = decoder.nextInt(0);
        this.verticalJust = decoder.nextChar('b');
        this.horizontalJust = decoder.nextChar('c');
        this.nameFormat.setFormat(decoder.nextToken("$pieceName$ ($label$)"));
        String string2 = decoder.nextToken("Dialog");
        int n2 = decoder.nextInt(0);
        this.font = new Font(string2, n2, n);
        this.rotateDegrees = decoder.nextInt(0);
        this.propertyName = decoder.nextToken("TextLabel");
        this.lbl.setForeground(this.textFg);
        this.lbl.setFont(this.font);
    }

    public Object getProperty(Object object) {
        if (object.equals(this.propertyName)) {
            return this.getLabel();
        }
        if ("visibleState".equals(object)) {
            return this.getLabel() + this.piece.getProperty(object);
        }
        return super.getProperty(object);
    }

    public String myGetType() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
        sequenceEncoder.append(this.labelKey);
        sequenceEncoder.append(this.menuCommand);
        sequenceEncoder.append(this.font.getSize());
        String string = ColorConfigurer.colorToString(this.textBg);
        sequenceEncoder.append(string == null ? "" : string);
        string = ColorConfigurer.colorToString(this.textFg);
        sequenceEncoder.append(string == null ? "" : string);
        sequenceEncoder.append(String.valueOf(this.verticalPos));
        sequenceEncoder.append(String.valueOf(this.verticalOffset));
        sequenceEncoder.append(String.valueOf(this.horizontalPos));
        sequenceEncoder.append(String.valueOf(this.horizontalOffset));
        sequenceEncoder.append(String.valueOf(this.verticalJust));
        sequenceEncoder.append(String.valueOf(this.horizontalJust));
        sequenceEncoder.append(this.nameFormat.getFormat());
        sequenceEncoder.append(this.font.getFamily());
        sequenceEncoder.append(this.font.getStyle());
        sequenceEncoder.append(String.valueOf(this.rotateDegrees));
        sequenceEncoder.append(this.propertyName);
        return ID + sequenceEncoder.getValue();
    }

    public String myGetState() {
        return this.label;
    }

    public void mySetState(String string) {
        this.setLabel(string.trim());
    }

    public String getName() {
        if (this.label.length() == 0) {
            return this.piece.getName();
        }
        this.nameFormat.setProperty(PIECE_NAME, this.piece.getName());
        this.nameFormat.setProperty(LABEL, this.getLabel());
        return this.nameFormat.getText(Decorator.getOutermost(this));
    }

    public static void drawLabel(Graphics graphics, String string, int n, int n2, int n3, int n4, Color color, Color color2) {
        Labeler.drawLabel(graphics, string, n, n2, new Font("Dialog", 0, 10), n3, n4, color, color2, null);
    }

    public static void drawLabel(Graphics graphics, String string, int n, int n2, Font font, int n3, int n4, Color color, Color color2, Color color3) {
        graphics.setFont(font);
        int n5 = graphics.getFontMetrics().stringWidth(string + "  ");
        int n6 = graphics.getFontMetrics().getHeight();
        int n7 = n;
        int n8 = n2;
        switch (n3) {
            case 0: {
                n7 = n - n5 / 2;
                break;
            }
            case 2: {
                n7 = n - n5;
            }
        }
        switch (n4) {
            case 0: {
                n8 = n2 - n6 / 2;
                break;
            }
            case 4: {
                n8 = n2 - n6;
            }
        }
        if (color2 != null) {
            graphics.setColor(color2);
            graphics.fillRect(n7, n8, n5, n6);
        }
        if (color3 != null) {
            graphics.setColor(color3);
            graphics.drawRect(n7, n8, n5, n6);
        }
        graphics.setColor(color);
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.drawString(" " + string + " ", n7, n8 + graphics.getFontMetrics().getHeight() - graphics.getFontMetrics().getDescent());
    }

    public void draw(Graphics graphics, int n, int n2, Component component, double d) {
        this.updateCachedImage();
        this.piece.draw(graphics, n, n2, component, d);
        if (this.labelImage != null) {
            Object object;
            Point point = this.getLabelPosition();
            int n3 = n + (int)(d * (double)point.x);
            int n4 = n2 + (int)(d * (double)point.y);
            AffineTransform affineTransform = null;
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (this.rotateDegrees != 0) {
                affineTransform = graphics2D.getTransform();
                object = AffineTransform.getRotateInstance(Math.toRadians(this.rotateDegrees), n, n2);
                graphics2D.transform((AffineTransform)object);
            }
            if (d != 1.0) {
                object = this.labelImage;
                object = GameModule.getGameModule().getDataArchive().getScaledImage(this.labelImage, d);
                graphics.drawImage((Image)object, n3, n4, component);
            } else {
                graphics.drawImage(this.labelImage, n3, n4, component);
            }
            if (this.rotateDegrees != 0) {
                graphics2D.setTransform(affineTransform);
            }
        }
    }

    protected void updateCachedImage() {
        String string = this.getLabel();
        if (string != null && !string.equals(this.lastCachedLabel)) {
            this.labelImage = null;
        }
        if (this.labelImage == null && string != null && string.length() > 0) {
            this.labelImage = this.createImage(null);
        }
    }

    private Point getLabelPosition() {
        int n = this.horizontalOffset;
        int n2 = this.verticalOffset;
        Rectangle rectangle = this.piece.getShape().getBounds();
        switch (this.verticalPos) {
            case 't': {
                n2 += rectangle.y;
                break;
            }
            case 'b': {
                n2 += rectangle.y + rectangle.height;
            }
        }
        switch (this.horizontalPos) {
            case 'l': {
                n += rectangle.x;
                break;
            }
            case 'r': {
                n += rectangle.x + rectangle.width;
            }
        }
        switch (this.verticalJust) {
            case 'b': {
                n2 -= this.lbl.getHeight();
                break;
            }
            case 'c': {
                n2 -= this.lbl.getHeight() / 2;
            }
        }
        switch (this.horizontalJust) {
            case 'c': {
                n -= this.lbl.getWidth() / 2;
                break;
            }
            case 'r': {
                n -= this.lbl.getWidth();
            }
        }
        return new Point(n, n2);
    }

    public void setLabel(String string) {
        if (string == null) {
            string = "";
        }
        int n = string.indexOf("$" + this.propertyName + "$");
        while (n >= 0) {
            string = string.substring(0, n) + string.substring(n + this.propertyName.length() + 2);
            n = string.indexOf("$" + this.propertyName + "$");
        }
        this.label = string;
        this.labelFormat.setFormat(this.label);
        this.labelImage = this.getMap() != null && this.label != null && this.label.length() > 0 ? this.createImage(this.getMap().getView()) : null;
    }

    public void setBackground(Color color) {
        this.textBg = color;
    }

    public void setForeground(Color color) {
        this.textFg = color;
    }

    protected Image createImage(Component component) {
        this.lastCachedLabel = this.getLabel();
        this.lbl.setText(this.lastCachedLabel);
        this.lbl.setSize(this.lbl.getPreferredSize());
        int n = this.lbl.getWidth();
        int n2 = this.lbl.getHeight();
        BufferedImage bufferedImage = new BufferedImage(n, n2, 6);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.textBg != null) {
            graphics2D.setColor(this.textBg);
            graphics2D.fillRect(0, 0, n, n2);
        }
        this.lbl.paint(graphics2D);
        return bufferedImage;
    }

    public String getLabel() {
        return this.labelFormat.getText(Decorator.getOutermost(this));
    }

    public Rectangle boundingBox() {
        this.lbl.setText(this.getLabel());
        this.lbl.setSize(this.lbl.getPreferredSize());
        Rectangle rectangle = this.piece.boundingBox();
        Rectangle rectangle2 = this.piece.getShape().getBounds();
        Point point = this.getLabelPosition();
        Rectangle rectangle3 = new Rectangle(point, this.lbl.getSize());
        return rectangle.union(rectangle2).union(rectangle3);
    }

    public Shape getShape() {
        if (this.labelKey != null) {
            return this.piece.getShape();
        }
        Area area = new Area(this.piece.getShape());
        Rectangle rectangle = new Rectangle(this.getLabelPosition(), this.lbl.getSize());
        area.add(new Area(rectangle));
        return area;
    }

    public KeyCommand[] myGetKeyCommands() {
        if (this.commands == null) {
            this.menuKeyCommand = new KeyCommand(this.menuCommand, this.labelKey, Decorator.getOutermost(this));
            this.commands = this.labelKey == null || this.menuCommand == null || this.menuCommand.length() == 0 ? new KeyCommand[0] : new KeyCommand[]{this.menuKeyCommand};
        }
        return this.commands;
    }

    public Command myKeyEvent(KeyStroke keyStroke) {
        this.myGetKeyCommands();
        Command command = null;
        if (this.menuKeyCommand.matches(keyStroke)) {
            ChangeTracker changeTracker = new ChangeTracker(this);
            String string = (String)JOptionPane.showInputDialog(this.getMap() == null ? null : this.getMap().getView().getTopLevelAncestor(), this.menuKeyCommand.getName(), null, 3, null, null, this.label);
            if (string == null) {
                changeTracker = null;
            } else {
                this.setLabel(string);
                command = changeTracker.getChangeCommand();
            }
        }
        return command;
    }

    public String getDescription() {
        return "Text Label";
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Label.htm");
    }

    public PieceEditor getEditor() {
        return new Ed(this);
    }

    private static class Ed
    implements PieceEditor {
        private HotKeyConfigurer labelKeyInput;
        private JPanel controls = new JPanel();
        private StringConfigurer command;
        private StringConfigurer initialValue;
        private ColorConfigurer fg;
        private ColorConfigurer bg;
        private JComboBox hPos;
        private JComboBox vPos;
        private JComboBox hJust;
        private JComboBox vJust;
        private IntConfigurer hOff;
        private IntConfigurer vOff;
        private IntConfigurer fontSize;
        private ListCellRenderer renderer;
        private FormattedStringConfigurer format;
        private JComboBox fontFamily;
        private IntConfigurer rotate;
        private BooleanConfigurer bold;
        private BooleanConfigurer italic;
        private StringConfigurer propertyNameConfig;

        public Ed(Labeler labeler) {
            int n;
            this.controls.setLayout(new BoxLayout(this.controls, 1));
            this.initialValue = new StringConfigurer(null, "Text:  ", labeler.label);
            this.controls.add(this.initialValue.getControls());
            this.format = new FormattedStringConfigurer(null, "Name format:  ", new String[]{Labeler.PIECE_NAME, Labeler.LABEL});
            this.format.setValue(labeler.nameFormat.getFormat());
            this.controls.add(this.format.getControls());
            this.command = new StringConfigurer(null, "Menu Command:  ", labeler.menuCommand);
            this.controls.add(this.command.getControls());
            this.labelKeyInput = new HotKeyConfigurer(null, "Keyboard Command:  ", labeler.labelKey);
            this.controls.add(this.labelKeyInput.getControls());
            Box box = Box.createHorizontalBox();
            box.add(new JLabel("Font:  "));
            this.fontFamily = new JComboBox();
            String[] stringArray = new String[]{"Serif", "SansSerif", "Monospaced", "Dialog", "DialogInput"};
            for (n = 0; n < stringArray.length; ++n) {
                this.fontFamily.addItem(stringArray[n]);
            }
            this.fontFamily.setSelectedItem(labeler.font.getFamily());
            box.add(this.fontFamily);
            this.controls.add(box);
            box = Box.createHorizontalBox();
            this.fontSize = new IntConfigurer(null, "Font size:  ", new Integer(labeler.font.getSize()));
            box.add(this.fontSize.getControls());
            box.add(new JLabel("  Bold:  "));
            n = labeler.font.getStyle();
            this.bold = new BooleanConfigurer(null, "", new Boolean(n != 0 && n != 2));
            box.add(this.bold.getControls());
            box.add(new JLabel("  Italic:  "));
            this.italic = new BooleanConfigurer(null, "", new Boolean(n != 0 && n != 1));
            box.add(this.italic.getControls());
            this.controls.add(box);
            box = Box.createHorizontalBox();
            this.fg = new ColorConfigurer(null, "Text Color:  ", labeler.textFg);
            box.add(this.fg.getControls());
            this.bg = new ColorConfigurer(null, "  Background Color:  ", labeler.textBg);
            box.add(this.bg.getControls());
            this.controls.add(box);
            this.renderer = new MyRenderer();
            Character[] characterArray = new Character[]{new Character('c'), new Character('r'), new Character('l')};
            Character[] characterArray2 = new Character[]{new Character('c'), new Character('t'), new Character('b')};
            box = Box.createHorizontalBox();
            box.add(new JLabel("Vertical position:  "));
            this.vPos = new JComboBox<Character>(characterArray2);
            this.vPos.setRenderer(this.renderer);
            this.vPos.setSelectedItem(new Character(labeler.verticalPos));
            box.add(this.vPos);
            this.vOff = new IntConfigurer(null, "  Offset:  ", new Integer(labeler.verticalOffset));
            box.add(this.vOff.getControls());
            this.controls.add(box);
            box = Box.createHorizontalBox();
            box.add(new JLabel("Horizontal position:  "));
            this.hPos = new JComboBox<Character>(characterArray);
            this.hPos.setRenderer(this.renderer);
            this.hPos.setSelectedItem(new Character(labeler.horizontalPos));
            box.add(this.hPos);
            this.hOff = new IntConfigurer(null, "  Offset:  ", new Integer(labeler.horizontalOffset));
            box.add(this.hOff.getControls());
            this.controls.add(box);
            box = Box.createHorizontalBox();
            box.add(new JLabel("Vertical text justification:  "));
            this.vJust = new JComboBox<Character>(characterArray2);
            this.vJust.setRenderer(this.renderer);
            this.vJust.setSelectedItem(new Character(labeler.verticalJust));
            box.add(this.vJust);
            this.controls.add(box);
            box = Box.createHorizontalBox();
            box.add(new JLabel("Horizontal text justification:  "));
            this.hJust = new JComboBox<Character>(characterArray);
            this.hJust.setRenderer(this.renderer);
            this.hJust.setSelectedItem(new Character(labeler.horizontalJust));
            box.add(this.hJust);
            this.controls.add(box);
            this.rotate = new IntConfigurer(null, "Rotate Text (Degrees):  ", new Integer(labeler.rotateDegrees));
            this.controls.add(this.rotate.getControls());
            this.propertyNameConfig = new StringConfigurer(null, "Property Name:  ", labeler.propertyName);
            this.controls.add(this.propertyNameConfig.getControls());
        }

        public String getState() {
            return this.initialValue.getValueString();
        }

        public String getType() {
            SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
            sequenceEncoder.append((KeyStroke)this.labelKeyInput.getValue());
            sequenceEncoder.append(this.command.getValueString());
            Integer n = (Integer)this.fontSize.getValue();
            if (n == null || n <= 0) {
                n = new Integer(10);
            }
            sequenceEncoder.append(n.toString());
            sequenceEncoder.append(this.bg.getValueString());
            sequenceEncoder.append(this.fg.getValueString());
            sequenceEncoder.append(this.vPos.getSelectedItem().toString());
            n = (Integer)this.vOff.getValue();
            if (n == null) {
                n = new Integer(0);
            }
            sequenceEncoder.append(n.toString());
            sequenceEncoder.append(this.hPos.getSelectedItem().toString());
            n = (Integer)this.hOff.getValue();
            if (n == null) {
                n = new Integer(0);
            }
            sequenceEncoder.append(n.toString());
            sequenceEncoder.append(this.vJust.getSelectedItem().toString());
            sequenceEncoder.append(this.hJust.getSelectedItem().toString());
            sequenceEncoder.append(this.format.getValueString());
            sequenceEncoder.append(this.fontFamily.getSelectedItem().toString());
            int n2 = 0 + (this.bold.booleanValue() != false ? 1 : 0) + (this.italic.booleanValue() != false ? 2 : 0);
            sequenceEncoder.append(n2 + "");
            n = (Integer)this.rotate.getValue();
            if (n == null) {
                n = new Integer(0);
            }
            sequenceEncoder.append(n.toString());
            sequenceEncoder.append(this.propertyNameConfig.getValueString());
            return Labeler.ID + sequenceEncoder.getValue();
        }

        public Component getControls() {
            return this.controls;
        }

        private static class MyRenderer
        extends DefaultListCellRenderer {
            private MyRenderer() {
            }

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                switch (((Character)object).charValue()) {
                    case 't': {
                        this.setText("Top");
                        break;
                    }
                    case 'b': {
                        this.setText("Bottom");
                        break;
                    }
                    case 'c': {
                        this.setText("Center");
                        break;
                    }
                    case 'l': {
                        this.setText("Left");
                        break;
                    }
                    case 'r': {
                        this.setText("Right");
                    }
                }
                return this;
            }
        }
    }
}

